##############################################################
# update_CAS.sh
# script that updates the CAS directory from the DEPHY github
#
# Etienne Vignon, November 2021
##############################################################

# Do I regenerate the driver files from the python scripts?
git_update=1
regenerate_driver=1


#============================================================
ici=`pwd`
rundefdir=$ici/INPUT/RUN

if [ -d "CAS" ]; then
echo 'CAS already exists'
else
mkdir CAS
fi

cd CAS

if [ "$git_update" = 1 ] ; then

mkdir -p savecas$$
mv `ls -1 . | grep -v saveca*` savecas$$
git clone  https://github.com/GdR-DEPHY/DEPHY-SCM.git
mv DEPHY-SCM/* . ; rm -rf DEPHY-SCM
cp DEPHY_Format*.pdf ../DOC/.

fi

for cas in `ls | grep -v "[a-z]"`; do
cd $cas


for subcas in $(ls -d */ | cut -f1 -d'/'); do
cd $subcas
echo $cas/$subcas

driver_def=driver_DEF.py
driver_scm=driver_SCM.py

if [ "$regenerate_driver" = 1 ] ; then 

if [ -f "$driver_def" ]; then
echo 'run driver DEF for case ' ${cas}/${subcas}
python $driver_def
fi

if [ -f "$driver_scm" ]; then
echo 'run driver SCM for case ' ${cas}/${subcas}
python $driver_scm
fi

fi

file_driver_scm=${cas}_${subcas}_SCM_driver.nc
echo 'file_driver is' $file_driver_scm
if [ -f "$file_driver_scm" ]; then
echo 'create cas.nc for ' ${cas}/${subcas}
ln -s $file_driver_scm cas.nc
cp $rundefdir/$cas/run.def .
else
echo 'no driver SCM for case ' ${cas}/${subcas}
fi

cd ..
done

cd ..
done

# special procedure for RICO REF CASE

#cd RICO
#ln -s SHORT REF

# special procedure for GABLS4 case for tuning

cd GABLS4
ln -sf STAGE3-SHORT STAGE3SHORT
