#!/bin/bash

echo "j'entre dans cas2def.sh"
#startDate = "19970621113000" ;
#endDate = "19970622023000" ;
new_input=1


if [ $new_input = 0 ] ; then
   ncdump -h setup/cas.nc > tmp
   surfaceType="land" ;  surfaceForcing="0" ;  forcingForcingWind="z0"
else
   ncdump -h cas.nc | sed -e 's/qvadv/qadv/g' -e 's/^.*.://' > tmp
   forc_ustar=0 ; forc_u=0 ; forc_v=0 ; z0=0.
fi


\rm cas.def ; touch cas.def

for var in \
	adv_ta adv_theta adv_thetal \
	adv_qv adv_qt adv_rv adv_rt \
	forc_wap forc_wa forc_geo \
    ta_nud theta_nud thetal_nud \
	qv_nud qt_nud rv_nud rt_nud \
    ua_nud va_nud \
    nudging_ua nudging_va nudging_ta nudging_theta nudging_thetal \
    nudging_qv nudging_qt nudging_rv nudging_rt \
	radiation\
	pa_nudging_ua pa_nudging_va pa_nudging_ta pa_nudging_theta pa_nudging_thetal \
    zh_nudging_ua zh_nudging_va zh_nudging_ta zh_nudging_theta zh_nudging_thetal \
    pa_nudging_qv pa_nudging_qt pa_nudging_rv pa_nudging_rt \
    zh_nudging_qv zh_nudging_qt zh_nudging_rv zh_nudging_rt \
	surface_type surface_forcing_temp surface_forcing_moisture surface_forcing_wind ; do

	val=`grep "^$var =" tmp | tail -1 | cut -d= -f2 | awk ' { print $1 } ' | sed -e 's/"//g' `
	echo $var =$val


	# Regarder le probleme de trad
	if [ "$val" != "" ] ; then
	varname=$var
		case $var in


				surface_type) varname=nat_surf 
				case `echo $val | sed -e 's/ //g'` in
					land) val=1 ;;
					ocean) val=0 ;;
					seaice) val=3 ;;
					landice) val=2 ;;
				esac ;;

			    surface_forcing_temp) varname=ok_flux_surf
                                     varname2=ok_forc_tsurf                    
                    if [ $val = "ts" ] 
                    then 
                   	    echo $varname2=y >> cas.def 
                   	    val=n
                    elif [ $val = surface_flux ] 
                    then
                    	val=y 
                    else 
                    	val=n
                    fi  ;;


                surface_forcing_moisture) varname=ok_flux_surf
                                         varname2=ok_prescr_beta                    
                    if [ $val = "beta" ] 
                    then 
                   	    echo $varname2=y >> cas.def 
			    beta=`ncdump -v beta cas.nc | sed -e '1,/data:/d' -e '$d' | head -2 | cut -d\, -f1`
			    echo betaevap=$beta | sed -e 's/ //g' | sed -e 's/=beta=/=/g' >> cas.def
                   	    val=n
                    elif [ $val = surface_flux ] 
                    then
                    	val=y 
                    else 
                    	val=n
                    fi  ;;


                beta) varname=betaevap ;;



                surface_forcing_wind) varname=ok_prescr_ust              
                    if [ $val = "z0" ] 
                    then 
                   	    val=n
                        z0=`ncdump -v z0 cas.nc | sed -e '1,/data:/d' -e '$d' | head -2 | cut -d\, -f1`
                        echo z0=$z0 | sed -e 's/ //g' | sed -e 's/=z0=/=/g' >> cas.def
                    elif [ $val = "ustar" ] 
                    then
                    	val=y 
                    else 
                    	val=n
                    fi  ;;



                radiation) varname=iflag_radia
                case $val in
                        "off") val=0 ;;
                        "tend") val=0 ;;
                        *) val=1
                esac ;;
         

			    nudging_ta) varname=nudging_t ;;
			    pa_nudging_ta) varname=p_nudging_t ;;
			    zh_nudging_ta) varname=z_nudging_t ;;


			    nudging_qv) varname=nudging_qv ;;
                pa_nudging_qv) varname=p_nudging_qv ;;
			    zh_nudging_qv) varname=z_nudging_qv ;;

			    nudging_ua) varname=nudging_u ;;
                pa_nudging_ua) varname=p_nudging_u ;;
			    zh_nudging_ua) varname=z_nudging_u ;;

			    nudging_va) varname=nudging_v ;;
                pa_nudging_va) varname=p_nudging_v ;;
			    zh_nudging_va) varname=z_nudging_v ;;

			    forc_wa) varname=forc_w ;;
			    forc_wap) varname=forc_omega ;;

			    adv_ta) varname=tadv ;;





		esac
		echo $varname=$val >> cas.def
# twice for surfecaForcing since it controls both surface fluxes and Ts


	fi
done

echo 'end list var'
############# coordonnees #############################################
for coord in lon lat ; do ncdump cas.nc -v $coord | grep $coord | tail -1 | awk ' { print "r'$coord'="$3 } ' | sed -e 's/\,//g' >> cas.def ; done
for coord in lon lat ; do ncdump cas.nc -v $coord | grep $coord | tail -1 | awk ' { print "r'$coord'="$3 } ' ; done

echo 'end coord'
############# Pression de surface #####################################
# Pour le moment, on ne gere pas les changement de pression de surface
# Cette commande rale. C'est dommage
#psurf=`cdo output -selvar,ps cas.nc | head -1`
# EV comme cdo rale, j'utilise ncdump
psurf=`ncdump -v ps cas.nc | sed -e '1,/data:/d' -e '$d' | tail -n +2  | sed 's/\;//g'`
echo $psurf
echo psurf=$psurf | sed -e 's/ //g' | sed -e 's/ps=//g' >> cas.def
echo 'end pression surface'

############# Altitude de la surface #####################################
zorog=`ncdump -v orog cas.nc | sed -e '1,/data:/d' -e '$d' | head -2 | cut -d\, -f1`
echo $zorog
echo zorog=$zorog | sed -e 's/ //g' | sed -e 's/=orog=/=/g' >> cas.def
echo 'end altitude surface'



############# Gestion du calendrier ###################################
time_i=`ncdump -h cas.nc | grep start_date | cut -d\" -f2`
time_f=`ncdump -h cas.nc | grep end_date | cut -d\" -f2`
yr_i=`echo $time_i | cut -c1-4`
mo_i=`echo $time_i | cut -c6-7`
da_i=`echo $time_i | cut -c9-10`
hr_i=`echo $time_i | cut -c12-13`
mn_i=`echo $time_i | cut -c15-16`
sc_i=`echo $time_i | cut -c18-19`
echo DATE INI $yr_i $mo_i  $da_i $hr_i $mn_i $sc_i $time_i
yr_f=`echo $time_f | cut -c1-4`
mo_f=`echo $time_f | cut -c6-7`
da_f=`echo $time_f | cut -c9-10`
hr_f=`echo $time_f | cut -c12-13`
mn_f=`echo $time_f | cut -c15-16`
sc_f=`echo $time_f | cut -c18-19`
echo DATE END $yr_f $mo_f  $da_f $hr_f $mn_f $sc_f $time_f
(( yr_d = $yr_f - $yr_i ))
(( mo_d = 10#$mo_f - 10#$mo_i ))
(( da_d = 10#$da_f - 10#$da_i ))
(( hr_d = 10#$hr_f - 10#$hr_i ))
(( mn_d = 10#$mn_f - 10#$mn_i ))
(( sc_d = 10#$sc_f - 10#$sc_i ))

echo PREVOIR DE PASSER AU CALENDRIER VRAI
calend=360

# Jour compte depuis le debut de l'annee
if [ $calend = 360 ] ; then
	d0mo=( 0 30 60 90 120 150 180 210 240 270 300 330 )
	yr_length=360
fi
day_i=$(( d0mo[$(( 10#$mo_i - 1 ))] +  10#$da_i ))

# Longeur de la simulation en jours, incluant la prise en compte des heures
hour_i=$(( 10#$day_i * 24 + 10#$hr_i ))
hour_f=$(( $(( d0mo[$(( 10#$mo_f - 1 ))] +  10#$da_f + 10#$yr_d * 10#$yr_length )) * 24 + 10#$hr_f ))
echo HOUR $hour_i $hour_f $da_i $da_f
#nday=$(( $(( $hour_f - $hour_i -1 )) / 24 + 1 ))
nhour=$(( $(( 10#$hour_f - 10#$hour_i -1 )) + 1 ))
day_step=`grep day_step gcm1d.def | cut -d= -f2`
nday=-`echo $nhour $day_step | awk ' { print int ( ( $1 * $2 ) / 24. ) } '`



echo dayref=$(( d0mo[$(( 10#$mo_i - 1 ))] +  10#$da_i )) >> cas.def
echo anneeref=$yr_i >> cas.def
echo nday=$nday >> cas.def
echo time_ini=`echo $hr_i $mn_i $sc_i | awk ' { print ( $1 * 3600 + $2 * 60 + $3 ) / 3600. } '`  >> cas.def

cas=`basename \`( cd .. ; pwd )\``
echo CAS $cas

# Specificites du cas Sandu. En cous d'instruction
if [ $cas = SANDU ] ; then
	sed -e "s/anneeref=2007/anneeref=2006/" -e "s/time_ini=.*.$/time_ini=18/" -i cas.def
	cat <<eod>> cas.def
iflag_z0_oce=-1
z0min=0.002
eod
fi

echo "je sors de cas2def.sh"
