#!/bin/bash

# Specify the path to the RESU directory
# datapathpre="../../../../V20170518.trunk/1D/RESU/"
ici=`pwd`
cd ../../RESU
datapathpre=`pwd`
cd $ici
datapathsuf="/gabls4/hourly.nc"

listedef="NPv5.70 NPv6.0.7 NPv6.0.9 NPv6.0.10.2"

for DEF in $listedef ; do
  defdir=$DEF"L79"
  inputfile=$datapathpre/$defdir$datapathsuf
  if ! [ -f $inputfile ] ; then
    echo $inputfile not found
  else
    ./atlas_temp.py -i $inputfile -o ./
    ./atlas_wind.py -i $inputfile -o ./
    echo $defdir done
  fi
done

pdfjam-slides6up --pagenumbering true --frame false atlas_*.pdf -o diag_gabls4.pdf
rm -f atlas_*.pdf
