#!/bin/bash
##################################################################
# 0 or 1 or 2 or 3 arguments :
#   - 1st = name of the input parameter set (eg : AR4 --> physiq.def = INPUT/AR4_physiq.def
#   - 2nd = suffix of the model name (eg : foo --> model = lmdz1d_foo.e)
#   - 3rd = suffix of the simulation name (eg : 4 --> output file = histmth_foo_4.nc)
# If there is no model name suffix, 1st argument should be a dot.
# Examples :
#   xqt.x AR4  -->  input parameters = INPUT/AR4_physiq.def
#                   model = lmdz1d.e
#                   output = histmth_AR4.nc
#   xqt.x . norad 3 --> model = lmdz1d_norad.e
#                       output = histmth_norad_3.nc
#   xqt.x . . 22 --> model = lmdz1d.e
#                    output = histmth_22.nc
##################################################################
#
#
##  First switch to the requested set of input parameters, if any.
if [ -n "$1" -a "$1" != \. ]
then
  for ii in `ls INPUT/${1}_*.def`
  do
    name=`echo ${ii} | sed -e "s+^INPUT/${1}_++"`
    rm -f ${name}
    echo ln -s ${ii} ${name}
    ln -s ${ii} ${name}
  done
  for ii in `ls INPUT/${1}_*.data`
  do
    name=`echo ${ii} | sed -e "s+^INPUT/${1}_++"`
    rm -f ${name}
    echo ln -s ${ii} ${name}
    ln -s ${ii} ${name}
  done
  input="_$1"
else
  input=""
fi
#
## Second, switch to the requested model executable, if any.
if [ -n "$2" -a "$2" != \. ]
then
 exec="_$2"
else
 exec=""
fi
#
## Third, set simulation name, if any.
if [ -n "$3" -a "$3" != \. ]
then
 simul="_$3"
else
 simul=""
fi
suffix=${input}${exec}${simul}
#

## save suffixe-free output files
rm -f *.nc.zzzztemporary
for suf in mth day ins hf LES ; do
if [ -f hist$suf.nc ]
then
mv hist$suf.nc hist$suf.nc.zzzztemporary
fi
done

##
echo SIMULATION
./lmdz1d${exec}.e | sed -e '/t_mod/d' > lmdz1d${exec}.lis

tail -2 lmdz1d${exec}.lis
#
echo SIMULATION FINISHED

#for suf in mth day ins hf LES ; do
for suf in hf ; do

echo Cas du fichier hist$suf.nc
if [ -f hist$suf.nc ]
then
echo Traitement du fichier hist$suf.nc
#  Si necessaire, on refait un axe des temps (pour Grads) et on oriente l'axe des pressions positif vers le bas
  time_name=`ncdump -h hist$suf.nc|grep 't_inst_.*(time_counter)'|sed -e"s/^.*t_inst_\(.*\)(time_counter).*$/t_inst_\1/"`
  if [ -n "${time_name}" ]
  then
   ncrename -v ${time_name},time_counter hist$suf.nc
  fi
#  On met 1.e35 comme valeur indefinie ; selon les version de nco on passe par un chgmnt de nom de _FillValue ou non.
  ncrename -a _FillValue,bidonundef hist$suf.nc  2>/dev/null
#
  if [ "$?" = "1" ]
  then
   ncatted -O -a positive,presnivs,o,c,down -a _FillValue,,m,f,1.e35 hist$suf.nc 
  else
   ncatted -O -a positive,presnivs,o,c,down -a bidonundef,,m,f,1.e35 hist$suf.nc
   ncrename -a bidonundef,_FillValue hist$suf.nc
  fi

  if [ -n "${suffix}" ]
  then
   cp -f hist$suf.nc hist$suf${suffix}.nc
   rm -f hist$suf.nc
  else
   rm -f hist$suf.nc.zzzztemporary
  fi
fi
if [ -f hist$suf.nc.zzzztemporary ]
then
  mv hist$suf.nc.zzzztemporary hist$suf.nc
fi
done

