#!/bin/bash

#=====================================================
# script that makes a thorough testing of the LMDZ SCM 
# for the setting-up of new reference versions
# Etienne, March 2023
#=====================================================
echo "You start the trusting of the LMDZ SCM"
echo "this script will clean your 1D folder"
echo "and recompile from scratch erasing compiled objects."
echo "Are you sure you want to continue?"
read answer
if [[ $answer == "oui" || $answer == "yes" ]]
then
echo "ok I continue"
else
exit
fi

echo "Which LMDZ svn revision do you want to test (ex: 4471)?"
read svnrev

echo "Which LMDZ svn revision will serve as reference for convergence test (ex: 4430)?"
read svnrevref

echo "Which LMDZ physics do you want to test (ex: NPv6.3)?"
read myphys

echo "how many vertical levels (ex: 95)?"
read llm

echo "which radiation scheme (olrad or rrtm or ecrad)?"
read myrad


# check if physics exists
#=========================

if [ ! -f ./INPUT/PHYS/physiq.def_$myphys ]; then
   echo physics $myphys not found
   exit
fi

# now clean the 1D folder
#=============================
bash clean.sh

# make the list of all cases
#===========================

# standard format cases:

list_newcases=" "

cd CAS
for cas in `ls -d * | grep -v "[a-z]"`; do
    cd $cas
    tmp=$cas
    for subcas in $(ls -d * |  grep -v "[a-z]"  | cut -f1 -d'/'); do
       tmp=$tmp\/$subcas
       list_newcases="${list_newcases} $tmp"
       tmp=$cas
    done
    cd ..
done
cd ..

# list of non tested cases (error, to be solved)
list_badcases="ayotte idealq eq_rd_cv_1p1eq2"

list_oldcases=" "
cd OLDCASES
for cas in `ls -d * | grep -v "[A-Z]"`; do
    ibad=0
    for badcas in $list_badcases ; do
	    if [ $badcas == $cas ] ; then
		    ibad=1
            fi
    done
    if [ $ibad == 0 ] ; then
    list_oldcases="${list_oldcases} $cas"
    fi
done
cd ..

# merge the two lists

list_allcases="${list_newcases} ${list_oldcases}"



echo "here the list of all cases that will be tested"
echo $list_allcases

# modify the run.sh with the new list of cases to compile and run
sed -i "s|listecas=.*|listecas=\"${list_allcases}\"|" run.sh
sed -i "s/LLM=.*/LLM=${llm}/" run.sh
sed -i "s|rad=\".*|rad=\"${myrad}\"|" run.sh
sed -i "s/listedef=.*/listedef=${myphys}/" run.sh
# deactivate diagnostics
sed -i "s/i_diag=.*/i_diag=0/" run.sh
# force full compilation
sed -i "s/ok_full_compile=.*/ok_full_compile=true/" run.sh



# run run.sh for all cases and check compilation by checking the presence of lmdz1d.e
#=====================================================================================

fbilan=bilan_trusting_${svnrev}_vs_${svnrevref}_L${llm}_${myrad}.txt
rm -f $fbilan

echo bilan trusting LMDZ SCM for svn rev $svnrev using reference $svnrevref and phys $myphys >> $fbilan
echo `date` >> $fbilan
echo ========================================================== >> $fbilan
# update LMDZ with the reference svn revision

cd ../modipsl/modeles/LMDZ
rm -rf libo/*
rm -f libf/grid/dimension/dimension*
svn update -r $svnrevref
cd -

echo I run run.sh for LMDZ ref svn revision $svnrevref with physics $myphys
echo $llm vertical levels and $myrad radiation code
./run.sh > listing_runsh_trusting_ref 2>&1

mv EXEC EXECREF

if [ -f ./bin/lmdz1d.e ] ; then
  echo "compilation of lmdz SCM with ref revision " $svnrevref  "is OK" >> $fbilan
else
  echo "compilation of lmdz SCM with ref revision " $svnrevref  "failed" >> $fbilan
  exit 1
fi

cd ../modipsl/modeles/LMDZ
rm -rf libo/*
rm -f libf/grid/dimension/dimension*
svn update -r $svnrev
cd -

echo I run run.sh for LMDZ test svn revision $svnrev with physics $myphys
./run.sh > listing_runsh_trusting_test 2>&1

if [ -f ./bin/lmdz1d.e ] ; then
  echo "compilation of lmdz SCM with test revision " $svnrev  "is OK" >> $fbilan
else
  echo "compilation of lmdz SCM with test revision " $svnrev  "failed" >> $fbilan
  exit 1
fi



# Check if execution run correctly for each case + convergence
#=============================================================

echo ========================================================= >> $fbilan

ierror=0
for cas in $list_allcases ; do
  

  # execution ref version
  icompare=0
  iref=0
  if [ -f ./EXECREF/${myphys}L${llm}/$cas/restartphy.nc ] ; then
          echo CAS $cas correcly runs for REF >> $fbilan
          icompare=$(($icompare + 1))
	  iref=$(($iref + 1))
  else
          echo CAS $cas fails for REF  >> $fbilan
  fi

  # execution test version
  if [ -f ./EXEC/${myphys}L${llm}/$cas/restartphy.nc ] ; then
	  echo CAS $cas correcly runs for TEST >> $fbilan
          icompare=$(($icompare + 1))
  else
	  echo CAS $cas fails for TEST >> $fbilan
	  if [ $iref -eq 1 ] ; then
          ierror=$(($ierror + 1))
          echo !!! LOSS OF EXECUTION for CASE $cas !!! >> $fbilan
	  fi
  fi

  # convergence
  if [ $icompare -eq 2 ] ; then
     if  cmp -s ./EXECREF/${myphys}L${llm}/$cas/restartphy.nc ./EXEC/${myphys}L${llm}/$cas/restartphy.nc  ; then
        echo Convergence between test and ref version >> $fbilan
     else
	echo !!! LOSS OF CONVERGENCE FOR CASE $cas !!! >> $fbilan
	ierror=$(($ierror + 1))
     fi
  fi

echo ---------------------------------------------------- >> $fbilan

done
echo =========== $ierror errors to be investigated ===========   >> $fbilan








