#-*- coding:UTF-8 -*-
# draw a diagnostic plot for the MPACE REF case
# Authors: E. Vignon
# use module netCDF4 
#####################################################################################################################

import os
import sys
import matplotlib as mpl
# "backend" pour sortie fichier uniquement
#mpl.use('agg')
import matplotlib.pyplot as plt
import numpy as np
from matplotlib import dates
from datetime import datetime
from datetime import timedelta
import netCDF4 as nc4
import matplotlib.ticker as ticker
import matplotlib.cm as cm
import itertools
import matplotlib.dates as mdates
sys.path = ['../../../../DIAGS/',] + sys.path
from dicocoul import *
import util_hightune as util


# READ OBS
######################################

def read_obs_MPACE(time_units,time_calendar):
 
    # init
    dico_var_RS={}
    dico_var_radar={}   
    dico_var_aircraft={}

    file_RS='../../../'+DIRDATA+'OBS/MPACE/REF/RS_MPACE_20041009.170000.nc'
    #file_RS='../../../'+DIRDATA+'OBS/MPACE/REF/RS_MPACE_20041009.230200.nc'
    file_radar='../../../'+DIRDATA+'OBS/MPACE/REF/OBS_radar.nc'
    file_aircraft='../../../'+DIRDATA+'OBS/MPACE/REF/OBS_aircraft.nc'

    # read RS
    ds=nc4.Dataset(file_RS,'r')
    dico_var_RS['pressure']=np.asarray(ds.variables['pres'])*100. # in Pa
    dico_var_RS['temp']=np.asarray(ds.variables['tdry'])+273.15   # in K
    dico_var_RS['rhl']=np.asarray(ds.variables['rh'] )            # in %
    dico_var_RS['z']=np.asarray(ds.variables['alt'])             # in m asl
    p0=100000.
    cp=1005.0
    Rd=287.0
    dico_var_RS['theta']=dico_var_RS['temp']*(dico_var_RS['pressure']/p0)**(-Rd/cp)
    dico_var_RS['rhi']=util.rhl2rhi( dico_var_RS['rhl'],dico_var_RS['temp'], dico_var_RS['pressure'])
    dico_var_RS['qv']=util.rh2qv( dico_var_RS['rhl'],dico_var_RS['temp'], dico_var_RS['pressure'],'liquid')
    
    # read Radar data
    ds=nc4.Dataset(file_radar,'r')
    dico_var_radar['z']=np.asarray(ds.variables['zf'])                # in m abo. radar. level ~ asl
    dico_var_radar['lwp']=np.asarray(ds.variables['lwp'])                 # in kg/m2
    dico_var_radar['iwp']=np.asarray(ds.variables['iwp'])                 # in kg/m2
    dico_var_radar['iwc']=np.asarray(ds.variables['iwc'])                 # in kg/m3
    dico_var_radar['cloudbase']=np.asarray(ds.variables['cloudbase'])     # in m
    dico_var_radar['cloudtop']=np.asarray(ds.variables['cloudtop'])      # in m    
    dico_var_radar['tke_dissip']=np.asarray(ds.variables['tke_dissip'])  # in m2/s3

    # read aicraft data
    ds=nc4.Dataset(file_aircraft,'r')
    dico_var_aircraft['normalized_height']=np.asarray(ds.variables['normalized_height'])
    dico_var_aircraft['iwc']=np.asarray(ds.variables['iwc'])                # in kg/m3
    dico_var_aircraft['lwc']=np.asarray(ds.variables['lwc'])                # in kg/m3

    
    # time of file
    # need to create a clean time variable
    timedec=ds.variables['time']
    timearray=np.asarray(timedec)
    ll=len(timearray)
    timenum=timearray*3600.+nc4.date2num(datetime(2004,10,9,17,0,0),time_units,calendar=time_calendar)
    timedate=[nc4.num2date(x,units = time.units,calendar = calendrier) for x in timenum]

    dico_var_radar['timenum']=timenum
    dico_var_radar['timedate']=timedate

    dico_var_aircraft['timenum']=timenum
    dico_var_aircraft['timedate']=timedate
                       
 
    
    return dico_var_RS, dico_var_radar, dico_var_aircraft
    





############################################## MAIN PROGRAM #######################################################
# init
Case='MPACE'
SubCase='REF'
cas=Case+'_'+SubCase
axevert='z'
nompar='../../../param/param_'+Case+'_'+SubCase+'.py'



# date radiosounding
date_RS=datetime(2004,10,9,17,0,0)
#date_RS=datetime(2004,10,9,23,2,0)

# date beginning and end for profile statistics
date_beg=datetime(2004,10,9,17,0,0)
date_end=datetime(2004,10,10,05,0,0)

# Load simulation parameters
dicoglob=globals()
exec(open(nompar).read(),dicoglob)
dicosimu=globals()
exec(open("../../../simus.py").read(),dicosimu)
listficext=listfic
dicofic={}      # accès à toutes les données en fonction du nom de fichier
dicovar={}      # accès à la variable demandée    "           "       "
varlist=['theta','qv','rhl','rhi','rneb','ql','qi', 'lwp', 'iwp','zf','zh','pf','ph','rho','tke_dissip','pr_lsc_i']


#-----------------------------------
# boucle sur les fichiers de listfic
#-----------------------------------
listficpresent=[]
for nomfic in listficext:
    print "nomfic", nomfic 
    # fichier netcdf
    try:
        dicofic[nomfic]= nc4.Dataset('../../../'+DIRDATA+nomfic,'r')
        ficok=True
    #except RuntimeError:
    except:
        ficok=False
        print "<p>WARNING: erreur ouverture fichier %s</p>" % (nomfic)
    # liste des variables du fichier
    #print dicofic[nomfic].variables.keys()
    
    if (ficok ):    
        listficpresent.append(nomfic)
        for nomvar in varlist:
            mesg=[]
            if (util.data_pourprofil(dicofic[nomfic],nomvar,axevert,mesg)): 

            # donnees ok
                dicovar[nomfic,nomvar]=dicofic[nomfic].variables[nomvar]
                # vertical coordinate variables
                #---------------------------------
                # nom des dimensions de la variable
                nomdim=dicovar[nomfic,nomvar].dimensions
                nomz=nomdim[1]
                # variable verticale : zf ou zh, pf ou ph
                nomvarh=axevert+nomz[-1]
                mesg=[]
                alti=util.recup_champ(dicofic[nomfic],nomvarh,mesg)
                dicovar[nomfic,nomvar,'coordz']=alti
                
            elif util.data_pourserietempo(dicofic[nomfic],nomvar,mesg):
            	dicovar[nomfic,nomvar]=dicofic[nomfic].variables[nomvar]

            else:
            	 print "<p>WARNING: erreur ouverture variable %s</p>" % (nomvar)
            	 dicovar[nomfic,nomvar]=[]

        # time du fichier
        time=dicofic[nomfic].variables['time']   
        if hasattr(time,'calendar'):
            calendrier=time.calendar
        else:
            calendrier='standard'
    
        timedate=[nc4.num2date(x,units = time.units,calendar = calendrier,only_use_python_datetimes=True) for x in time]
        dicovar[nomfic,'timedate']=timedate
        timenum=[nc4.date2num(x,units = time.units,calendar = calendrier) for x in timedate]
        dicovar[nomfic,'timenum']=np.asarray(timenum)

        # closest date to radiosounding time
        timeprof=nc4.date2num(date_RS,time.units,calendar=calendrier)
        indtimeRS=util.ind_plusproche(time[:],timeprof)
        dateRS=nc4.num2date(time[indtimeRS],time.units,calendar=calendrier)
        dicovar[nomfic,'dateRS']=dateRS
        dicovar[nomfic,'indtimeRS']=indtimeRS
        # warning si time[indtimepp] est éloignée de timeprof (delta_timeprof en secondes)
        delta_timeprof=abs(timeprof-time[indtimeRS])
        if delta_timeprof > 3600:
            print '<p>WARNING : ',nomfic,' date la plus proche : ',dateRS,'</p>'
    
        # beg and end dates for averaging
    
        timenumbeg=nc4.date2num(date_beg,time.units,calendar=calendrier)
        indtimebeg=util.ind_plusproche(time[:],timenumbeg)
        datebeg=nc4.num2date(time[indtimebeg],time.units,calendar=calendrier)
        dicovar[nomfic,'datebeg']=datebeg
        dicovar[nomfic,'indtimebeg']=indtimebeg
        # warning si time[indtimepp] est éloignée de timeprof (delta_timeprof en secondes)
        delta_timeprof=abs(timenumbeg-time[indtimebeg])
        if delta_timeprof > 3600:
            print '<p>WARNING : ',nomfic,' date la plus proche : ',datebeg,'</p>'   
        
        
        timenumend=nc4.date2num(date_end,time.units,calendar=calendrier)
        indtimeend=util.ind_plusproche(time[:],timenumend)
        dateend=nc4.num2date(time[indtimeend],time.units,calendar=calendrier)
        dicovar[nomfic,'dateend']=dateend
        dicovar[nomfic,'indtimeend']=indtimeend
        # warning si time[indtimepp] est éloignée de timeprof (delta_timeprof en secondes)
        delta_timeprof=abs(timenumend-time[indtimeend])
        if delta_timeprof > 3600:
            print '<p>WARNING : ',nomfic,' date la plus proche : ',dateend,'</p>'           
    
        # add Liquid Ice water content variable

        qi=np.asarray(dicovar[nomfic,'qi'])
        ri=qi/(1.0-qi)
        ql=np.asarray(dicovar[nomfic,'ql'])
        rl=ql/(1.0-ql)
        rho=np.array(dicovar[nomfic,'rho'])
        if len(ql)>1 and len(rho)>1:
           dicovar[nomfic,'lwc']=rl*rho
           dicovar[nomfic,'lwc','coordz']=dicovar[nomfic,'ql','coordz']
        else:
           dicovar[nomfic,'lwc']=[]
           dicovar[nomfic,'lwc','coordz']=[]

        if len(qi)>1 and len(rho)>1:
           dicovar[nomfic,'iwc']=ri*rho
           dicovar[nomfic,'iwc','coordz']=dicovar[nomfic,'qi','coordz']
        else:
           dicovar[nomfic,'iwc']=[]
           dicovar[nomfic,'iwc','coordz']=[]

        # add normalized height variable

        rneb=np.asarray(dicovar[nomfic,'rneb'])
        zz=np.asarray(dicovar[nomfic,'rneb','coordz'])
        hn=np.zeros((len(rneb[:,0]),len(rneb[0,:])))*np.nan 
        for i in range(len(rneb[:,0])):
            clearsky=True
            cloudbase=np.nan
            cloudtop=np.nan
            for k in range(len(rneb[0,:])):
                if (rneb[i,k]>0.5 and clearsky and zz[i,k]<2000.):
                    cloudbase=zz[i,k]
                    clearsky=False
                if (cloudbase*0==0 and (not clearsky) and rneb[i,k]<0.1):
                    cloudtop=zz[i,k]
                    clearsky=True
                    break
            hn[i,:]=(zz[i,:]-cloudbase)/(cloudtop-cloudbase)
        dicovar[nomfic,'hn']=hn
        dicovar[nomfic,'hn','coordz']=dicovar[nomfic,'rneb','coordz']




# READ OBS   
dico_var_RS, dico_var_radar, dico_var_aircraft=read_obs_MPACE(time.units,calendrier)


# MAKE PLOTS
###############################################################

# time height plots, one per simulation

for nomfic in listficpresent:
    print nomfic 
    if (len(dicovar[nomfic,'iwc'])<1 or len(dicovar[nomfic,'tke_dissip'])<1):
        print 'I skip because variable iwc or tke_dissip not present in files'
        continue    
    simuname=util.titre_nomfic(nomfic)
    print simuname 
    namefig='../../../'+DIRDATA+'OUTPUT/'+simuname + '/' + Case+'/'+SubCase+'/timeheight_' + cas + '_' + simuname + '.png'

    fig=plt.figure(1, figsize=(15, 15))


# define xlticks
    fmt = '%Y-%m-%d_%H:%M:%S'
    timeticklab=[]
    indt1=0
    indt2=-1
    timetick=dico_var_radar['timenum'][indt1:indt2] 
    timedate=dico_var_radar['timedate'][indt1:indt2]     
    for t in timedate:
        str_time = t.strftime(fmt) 
        tt=str_time[11:13]
        timeticklab.append(tt)
    timetick=timetick[::12]
    timeticklab=timeticklab[::12]
    
# PLOT
  
    ax1=plt.subplot(3,2,1)
    indt1=5
    indt2=-1
    champ=dico_var_radar['iwc'][indt1:indt2,:]
    base=dico_var_radar['cloudbase'][indt1:indt2]
    top=dico_var_radar['cloudtop'][indt1:indt2]    
    zz=dico_var_radar['z']
    timevar=dico_var_radar['timenum'][indt1:indt2] 
    timedate=dico_var_radar['timedate'][indt1:indt2]     
    vmin=-7
    vmax=-3
    cs1 = ax1.pcolormesh(timevar,zz[0,:],np.log10(np.transpose(np.array(champ))),cmap='ocean_r',vmin=vmin,vmax=vmax)
    ax1.plot(timevar,base,'-k',linewidth=2)
    ax1.plot(timevar,top,'-k',linewidth=2)
    ax1.set_ylim(0,2000)
    cbar_ax = fig.add_axes([0.01, 0.10, 0.02, 0.7])
    ff1=fig.colorbar(cs1, cax=cbar_ax,label=r'$\mathrm{IWC\ [kg\ m^{-3}]}$')
    ff1.set_ticks([-7,-6,-5,-4,-3])
    ff1.set_ticklabels([r'$\mathrm{10^{-7}}$',r'$\mathrm{10^{-6}}$',r'$\mathrm{10^{-5}}$',r'$\mathrm{10^{-4}}$',r'$\mathrm{10^{-3}}$'])
    ax1.set_ylabel('z [m]')
    ax1.set_xticks(timetick)
    ax1.set_xticklabels(timeticklab,rotation=45)
    ax1.set_xlim(timenumbeg,timenumend)      

    ax2=plt.subplot(3,2,2)
    
    indt1=dicovar[nomfic,'indtimebeg']
    indt2=dicovar[nomfic,'indtimeend']
    champ=dicovar[nomfic,'iwc'][indt1:indt2,:]
    zz=dicovar[nomfic,'iwc','coordz'][0,:]
    timevar=dicovar[nomfic,'timenum'][indt1:indt2]
    vmin=-7
    vmax=-3
    cs2 = ax2.pcolormesh(timevar,zz,np.log10(np.transpose(np.squeeze(champ))),cmap='ocean_r',vmin=vmin,vmax=vmax)
    ax2.set_ylim(0,2000)
    ax2.set_xticks(timetick)
    ax2.set_xticklabels(timeticklab,rotation=45)
    ax2.set_xlim(timenumbeg,timenumend)  
    
    ax3=plt.subplot(3,2,3)
    
    indt1=5
    indt2=-1
    champ=dico_var_radar['tke_dissip'][indt1:indt2,:]
    base=dico_var_radar['cloudbase'][indt1:indt2]
    top=dico_var_radar['cloudtop'][indt1:indt2]   
    zz=dico_var_radar['z']
    timevar=dico_var_radar['timenum'][indt1:indt2]
    vmin=-6
    vmax=-1
    cs3 = ax3.pcolormesh(timevar,zz[0,:],np.log10(np.transpose(np.array(champ))),cmap='magma_r',vmin=vmin,vmax=vmax)
    ax3.plot(timevar,base,'-k',linewidth=2)
    ax3.plot(timevar,top,'-k',linewidth=2)
    ax3.set_ylim(0,2000)
    cbar_ax2 = fig.add_axes([0.93, 0.10, 0.02, 0.7])
    ff2=fig.colorbar(cs3, cax=cbar_ax2,label=r'$\mathrm{TKE\ dissipation\ [m^{2}\ s^{-3}]}$')
    ff2.set_ticks([-6,-5,-4,-3,-2,-1])
    ff2.set_ticklabels([r'$\mathrm{10^{-6}}$',r'$\mathrm{10^{-5}}$',r'$\mathrm{10^{-4}}$',r'$\mathrm{10^{-3}}$',r'$\mathrm{10^{-2}}$',r'$\mathrm{10^{-1}}$'])
    ax3.set_ylabel('z [m]')
    ax3.set_xlabel('UTC time')
    ax3.set_xticks(timetick)
    ax3.set_xticklabels(timeticklab,rotation=45)
    ax3.set_xlim(timenumbeg,timenumend)        
    
    
    ax4=plt.subplot(3,2,4)
    
    indt1=dicovar[nomfic,'indtimebeg']
    indt2=dicovar[nomfic,'indtimeend']
    champ=dicovar[nomfic,'tke_dissip'][indt1:indt2,:]
    zz=dicovar[nomfic,'tke_dissip','coordz'][0,:]
    timevar=dicovar[nomfic,'timenum'][indt1:indt2]
    vmin=-6
    vmax=-1
    cs4 = ax4.pcolormesh(timevar,zz,np.log10(np.transpose(np.squeeze(champ))),cmap='magma_r',vmin=vmin,vmax=vmax)
    ax4.set_ylim(0,2000)
#    ax4.set_xlabel('UTC time')
    ax4.set_xticks(timetick)
    ax4.set_xticklabels(timeticklab,rotation=45)
    ax4.set_xlim(timenumbeg,timenumend)  


    ax6=plt.subplot(3,2,6)
    
    indt1=dicovar[nomfic,'indtimebeg']
    indt2=dicovar[nomfic,'indtimeend']
    champ1=np.squeeze(dicovar[nomfic,'lwp'])
    champ2=np.squeeze(dicovar[nomfic,'iwp'])
    timevar=dicovar[nomfic,'timenum']
    plt.plot(timevar,champ1,'-',linewidth=1,color='blue',label='lwp model')
    plt.plot(timevar,champ2,'-',linewidth=1,color='grey',label='iwp model')
    champ1=np.squeeze(dico_var_radar['lwp'])
    champ2=np.squeeze(dico_var_radar['iwp'])
    timevar=dico_var_radar['timenum']
    plt.plot(timevar,champ1,'--',linewidth=2,color='blue',label='lwp obs')
    plt.plot(timevar,champ2,'--',linewidth=2,color='grey',label='iwp obs')
    ax6.legend()
    ax6.set_ylim(0,0.5)
    ax6.set_xlabel('UTC time')
    ax6.set_xticks(timetick)
    ax6.set_xticklabels(timeticklab,rotation=45)
    ax6.set_ylabel(r'$\mathrm{[kg\ kg^{-1}]}$')
    ax6.set_xlim(timenumbeg,timenumend)  

    fig.suptitle(cas + ' ' + simuname, fontsize=12)
    plt.savefig(namefig)
#    plt.show()
    plt.close(fig)


namefigprofiles='../../../'+DIRDATA+'OUTPUT/lwc_iwc_profiles_' + cas + '.png'

# mean vertical profiles of LWC and IWC

fig=plt.figure(1, figsize=(15, 15))


SMALL_SIZE = 12
MEDIUM_SIZE = 12
BIGGER_SIZE = 14

plt.rc('font', size=MEDIUM_SIZE)          # controls default text sizes
plt.rc('axes', titlesize=MEDIUM_SIZE)     # fontsize of the axes title
plt.rc('axes', labelsize=MEDIUM_SIZE)    # fontsize of the x and y labels
plt.rc('xtick', labelsize=SMALL_SIZE)    # fontsize of the tick labels
plt.rc('ytick', labelsize=SMALL_SIZE)    # fontsize of the tick labels
plt.rc('legend', fontsize=MEDIUM_SIZE)    # legend fontsize
plt.rc('figure', titlesize=MEDIUM_SIZE)  # fontsize of the figure title 



ax3=plt.subplot(2,2,3)
yvar=dico_var_aircraft['normalized_height']
xvar=np.nanmedian(dico_var_aircraft['lwc'][0::,:],axis=0)
ax3.plot(xvar,yvar,'-',linewidth=2,color='black',label='lwc aircraft')
ax3.set_xlabel(r'lwc $\mathrm{[kg\ m^{-3}]}$')
ax3.set_ylabel(r'normalized height')
ax3.set_ylim(-1,1.5)
ax3.set_xlim(0,0.0005)

ax4=plt.subplot(2,2,4)
zz=dico_var_radar['z']
hn_radar=np.zeros((len(zz[:,0]),len(zz[0,:])))
for k in range(len(zz[0,:])):
    hn_radar[:,k]=(zz[:,k]-dico_var_radar['cloudbase'])/(dico_var_radar['cloudtop']-dico_var_radar['cloudbase'])

xvar=np.mean(dico_var_radar['iwc'][0::,:],axis=0)
yvar=np.mean(hn_radar,axis=0)
ax4.plot(xvar,yvar,'--',linewidth=2,color='black',label='iwc radar')
yvar=dico_var_aircraft['normalized_height']
xvar=np.nanmean(dico_var_aircraft['iwc'][0::,:],axis=0)
ax4.plot(xvar,yvar,'-',linewidth=2,color='black',label='iwc aircraft')
ax4.set_xlabel(r'iwc $\mathrm{[kg\ m^{-3}]}$')
ax4.set_ylabel(r'normalized height')
ax4.set_ylim(-1,1.5)
ax4.set_xlim(0,0.0005)

adname=['CTRL','CTRL-CIWC', 'REF']
ii=-1
for nomfic in listficpresent:
    ii=ii+1
    simuname=util.titre_nomfic(nomfic)
    indt1=dicovar[nomfic,'indtimebeg']
    indt2=dicovar[nomfic,'indtimeend']
    xvar=np.squeeze(np.nanmean(dicovar[nomfic,'lwc'][indt1:indt2,:],axis=0))
    yvar=np.squeeze(np.nanmean(dicovar[nomfic,'hn'][indt1:indt2,:],axis=0))
    ax3.plot(xvar,yvar,color=dicocoul[util.basefic(nomfic)],linestyle=dicostyl[util.basefic(nomfic)],label='lwc '+adname[ii])
    xvar=np.squeeze(np.nanmean(dicovar[nomfic,'iwc'][indt1:indt2,:],axis=0))
    yvar=np.squeeze(np.nanmean(dicovar[nomfic,'hn'][indt1:indt2,:],axis=0))
    ax4.plot(xvar,yvar,color=dicocoul[util.basefic(nomfic)],linestyle=dicostyl[util.basefic(nomfic)],label='iwc ' + adname[ii])
    #xvar=np.squeeze(np.nanmean(dicovar[nomfic,'pr_lsc_i'][indt1:indt2,:],axis=0))
    #yvar=np.squeeze(np.nanmean(dicovar[nomfic,'hn'][indt1:indt2,:],axis=0))
    #ax4.plot(xvar,yvar,color=dicocoul[util.basefic(nomfic)],linestyle=':',label='sf ' + adname[ii])


ax3.legend()
ax4.legend()



ax1=plt.subplot(2,2,1)
ax1.set_ylim(zmin,zmax)
xmin=vmintab['theta']
xmax=vmaxtab['theta']
ax1.set_xlim(xmin,xmax)
ax1.set_ylabel('z [m]')
ax1.set_xlabel(r'$\mathrm{\theta}$ [K]')
zz=dico_var_RS['z']
vari=dico_var_RS['theta']
ax1.plot(vari,zz,color=dicocoul['OBS'],linestyle=dicostyl['OBS'],label='OBS')
plt.grid()

ax2=plt.subplot(2,2,2)
ax2.set_ylim(zmin,zmax)
xmin=50
xmax=130
ax2.set_xlim(xmin,xmax)
ax2.set_ylabel('z [m]')
ax2.set_xlabel(r'RHl [%]')
zz=dico_var_RS['z']
vari=dico_var_RS['rhl']
ax2.plot(vari,zz,color=dicocoul['OBS'],linestyle='-',label='RHl OBS')
vari=dico_var_RS['rhi']
ax2.plot(vari,zz,color=dicocoul['OBS'],linestyle=':',label='RHi OBS')


plt.grid()




ii=-1
for nomfic in listficpresent:
    ii=ii+1
    simuname=util.titre_nomfic(nomfic)
    zz=np.squeeze(np.nanmean(dicovar[nomfic,'theta','coordz'][indt1:indt2,:],axis=0))
    vari=np.squeeze(np.nanmean(dicovar[nomfic,'theta'][indt1:indt2,:],axis=0))
    ax1.plot(vari,zz,color=dicocoul[util.basefic(nomfic)],linestyle=dicostyl[util.basefic(nomfic)],label=adname[ii])
    zz=np.squeeze(np.nanmean(dicovar[nomfic,'rhl','coordz'][indt1:indt2,:],axis=0))
    vari=np.squeeze(np.nanmean(dicovar[nomfic,'rhl'][indt1:indt2,:],axis=0))
    ax2.plot(vari,zz,color=dicocoul[util.basefic(nomfic)],linestyle='-',label='RHl ' + adname[ii])
    zz=np.squeeze(np.nanmean(dicovar[nomfic,'rhi','coordz'][indt1:indt2,:],axis=0))
    vari=np.squeeze(np.nanmean(dicovar[nomfic,'rhi'][indt1:indt2,:],axis=0))
    ax2.plot(vari,zz,color=dicocoul[util.basefic(nomfic)],linestyle=':',label='RHi ' + adname[ii])


ax1.legend()
ax2.legend()
ax1.title.set_text('(a)')
ax2.title.set_text('(b)')
ax3.title.set_text('(c)')
ax4.title.set_text('(d)')




plt.savefig(namefigprofiles)
plt.close()




 


    

# vertical profiles at RS time

# prepare the figure

fig=plt.figure(1, figsize=(15, 15))
fig.tight_layout()
namefig='../../../'+DIRDATA+'OUTPUT/vertical_profiles_obs_' + cas + '.png'

SMALL_SIZE = 10
MEDIUM_SIZE = 11
BIGGER_SIZE = 14

plt.rc('font', size=MEDIUM_SIZE)          # controls default text sizes
plt.rc('axes', titlesize=MEDIUM_SIZE)     # fontsize of the axes title
plt.rc('axes', labelsize=MEDIUM_SIZE)    # fontsize of the x and y labels
plt.rc('xtick', labelsize=SMALL_SIZE)    # fontsize of the tick labels
plt.rc('ytick', labelsize=SMALL_SIZE)    # fontsize of the tick labels
plt.rc('legend', fontsize=MEDIUM_SIZE)    # legend fontsize
plt.rc('figure', titlesize=MEDIUM_SIZE)  # fontsize of the figure title 



ax1=plt.subplot(2,3,1)
ax1.set_ylim(zmin,zmax)
xmin=vmintab['theta']
xmax=vmaxtab['theta']
ax1.set_xlim(xmin,xmax)
ax1.set_ylabel('z [m]')
ax1.set_xlabel(r'$\mathrm{\theta}$ [K]')
zz=dico_var_RS['z']
vari=dico_var_RS['theta']
ax1.plot(vari,zz,color=dicocoul['OBS'],linestyle=dicostyl['OBS'],label='OBS')
plt.grid()

ax2=plt.subplot(2,3,2)
ax2.set_ylim(zmin,zmax)
xmin=vmintab['rhl']
xmax=vmaxtab['rhl']
ax2.set_xlim(xmin,xmax)
ax2.set_ylabel('z [m]')
ax2.set_xlabel(r'RHl [%]')
zz=dico_var_RS['z']
vari=dico_var_RS['rhl']
ax2.plot(vari,zz,color=dicocoul['OBS'],linestyle=dicostyl['OBS'],label='OBS')
plt.grid()


ax3=plt.subplot(2,3,3)
ax3.set_ylim(zmin,zmax)
xmin=vmintab['ql']
xmax=vmaxtab['ql']
ax3.set_xlim(xmin,xmax)
ax3.set_ylabel('z [m]')
ax3.set_xlabel(r'ql [$\mathrm{kg\ kg^{-1}}$]')
zz=dico_var_RS['z']
plt.grid()

ax4=plt.subplot(2,3,4)
ax4.set_ylim(zmin,zmax)
xmin=vmintab['qv']
xmax=vmaxtab['qv']
ax4.set_xlim(xmin,xmax)
ax4.set_ylabel('z [m]')
ax4.set_xlabel(r'qv [$\mathrm{kg\ kg^{-1}}$]')
zz=dico_var_RS['z']
vari=dico_var_RS['qv']
ax4.plot(vari,zz,color=dicocoul['OBS'],linestyle=dicostyl['OBS'],label='OBS')
plt.grid()

ax5=plt.subplot(2,3,5)
ax5.set_ylim(zmin,zmax)
xmin=vmintab['rhi']
xmax=vmaxtab['rhi']
ax5.set_xlim(xmin,xmax)
ax5.set_ylabel('z [m]')
ax5.set_xlabel(r'RHi [%]')
zz=dico_var_RS['z']
vari=dico_var_RS['rhi']
ax5.plot(vari,zz,color=dicocoul['OBS'],linestyle=dicostyl['OBS'],label='OBS')
plt.grid()

ax6=plt.subplot(2,3,6)
ax6.set_ylim(zmin,zmax)
xmin=vmintab['qi']
xmax=vmaxtab['qi']
ax6.set_xlim(xmin,xmax)
ax6.set_ylabel('z [m]')
ax6.set_xlabel(r'qi [$\mathrm{kg\ kg^{-1}}$]')
zz=dico_var_RS['z']
plt.grid()



for nomfic in listficpresent:
    simuname=util.titre_nomfic(nomfic)
    ind=dicovar[nomfic,'indtimeRS']
    zz=np.squeeze(dicovar[nomfic,'theta','coordz'][ind,:])
    vari=np.squeeze(dicovar[nomfic,'theta'][ind,:])
    print(util.basefic(nomfic))
    ax1.plot(vari,zz,color=dicocoul[util.basefic(nomfic)],linestyle=dicostyl[util.basefic(nomfic)],label=simuname)
    zz=np.squeeze(dicovar[nomfic,'rhl','coordz'][ind,:])
    vari=np.squeeze(dicovar[nomfic,'rhl'][ind,:])
    ax2.plot(vari,zz,color=dicocoul[util.basefic(nomfic)],linestyle=dicostyl[util.basefic(nomfic)],label=simuname)
    zz=np.squeeze(dicovar[nomfic,'ql','coordz'][ind,:])
    vari=np.squeeze(dicovar[nomfic,'ql'][ind,:])
    ax3.plot(vari,zz,color=dicocoul[util.basefic(nomfic)],linestyle=dicostyl[util.basefic(nomfic)],label=simuname)
    zz=np.squeeze(dicovar[nomfic,'qv','coordz'][ind,:])
    vari=np.squeeze(dicovar[nomfic,'qv'][ind,:])
    ax4.plot(vari,zz,color=dicocoul[util.basefic(nomfic)],linestyle=dicostyl[util.basefic(nomfic)],label=simuname)
    zz=np.squeeze(dicovar[nomfic,'rhi','coordz'][ind,:])
    vari=np.squeeze(dicovar[nomfic,'rhi'][ind,:])
    ax5.plot(vari,zz,color=dicocoul[util.basefic(nomfic)],linestyle=dicostyl[util.basefic(nomfic)],label=simuname)
    zz=np.squeeze(dicovar[nomfic,'qi','coordz'][ind,:])
    vari=np.squeeze(dicovar[nomfic,'qi'][ind,:])
    ax6.plot(vari,zz,color=dicocoul[util.basefic(nomfic)],linestyle=dicostyl[util.basefic(nomfic)],label=simuname)


ax1.legend()
strhhprof=date_RS.strftime('%Y-%m-%d_%H:%M')
fig.suptitle(cas+ ' ' + strhhprof, fontsize=12)
plt.savefig(namefig)
#plt.show()
plt.close(fig)
