#!/usr/bin/env python

"""This script puts back comments that were originally at the end of
an instruction, then moved at the following line. Because it involves
working with two lines, this is not a beginner-level task with sed. So
we do it with Python."""

import re
import sys

if len(sys.argv) != 2: sys.exit("Required argument: file name")

f = open(sys.argv[1])
text = f.read()
f.close()

# Put back comments to end of previous line, only if NAG polish has
# not already moved them after an instruction:
modified = re.sub(r"\n *! x_Lionel", " !", text)

# Remaining " x_Lionel":
modified = re.sub(" x_Lionel", "", modified)

f = open(sys.argv[1], "w")
f.write(modified)
f.close()
