# This is a script in Bash.

# Author: Lionel GUEZ

# This script was used for revision 1992 of LMDZ, to convert files in
# libf/phylmd from fixed source form to free source form. This script
# was run from the directory phylmd.

# The main tool used by this script is the polish mode of the NAG
# Fortran compiler (version 5.3), available on Ciclad. There are two
# limitations of this tool: it does not accept preprocessor
# directives, and it does not deal well with end-of-line comments (it
# sometimes moves the comments before of after the instruction
# line). We circumvent these two limitations by: commenting out
# preprocessing lines before using NAG polish, and putting them back
# afterwards; moving end-of-line comments to next line before using
# NAG polish, and putting them back afterwards. The script also
# replaces #include by include.

# This script calls the accompanying Python script
# "move_back_comments.py".

##set -x
set -e

script_dir=`dirname $0`

for my_file in *.F
  do
  my_base=${my_file%.F}
  # 1. Comment out preprocessing lines
  # 2. Comment out Fortran include lines
  # 3. Move end-of-line comments to next line (ASCII codes 34 and 39
  #    for quote and double quote)

  sed --regexp-extended --expression='s/^\#/c conversion_Lionel#/' \
      --expression='s/^ *include/c conversion_Lionelinclude/i' \
      --expression='s/^([ \t]+[^ \t!][^!\d039\d034]*)!/\1\nc x_Lionel/' \
      $my_base.F >$my_base.f
  
  set +e
  nagfor =polish -132 -alter_comments -kwcase=U -margin=0 -norenumber \
      -width=77 $my_base.f
  return_code=$?
  set -e

  if (($return_code != 0))
      then
      echo "Waiting for modification of $my_base.f..."
      read -p "Hit Return to continue."
      nagfor =polish -132 -alter_comments -kwcase=U -margin=0 -norenumber \
	  -width=77 $my_base.f
  fi

  svn mv $my_base.F $my_base.F90

  # 1. Uncomment #include and include lines, #include lines become
  #    Fortran include lines, all lines keep their indentation
  # 2. Uncomment other preprocessing lines
  # 3. Replace lines containging only space by empty lines
  # 4. Remove space between ! and $OMP
  sed 's/! *conversion_Lionel\#\?include/include/i' $my_base.f90_pol \
      | sed --regexp-extended --expression='s/^ *! *conversion_Lionel\#/#/' \
      --expression='s/ +$//' --expression='s/! +\$OMP/!$OMP/' >$my_base.F90

  $script_dir/move_back_comments.py $my_base.F90

  rm $my_base.f $my_base.f90_pol
done
