
! $Id: $

MODULE infotrac_phy

   USE strings_mod, ONLY: maxlen
!   PUBLIC :: tracers, type_trac                            !--- Full tracers database, tracers type keyword
!   PUBLIC :: nqtot,   nbtr,   nqo,   nqCO2,   nqtottr      !--- Main dimensions
   INTEGER,SAVE :: nqtot,   nbtr,   nqo,   nqCO2,   nqtottr      !--- Main dimensions
   INTEGER,SAVE :: niso,ntiso
   CHARACTER(LEN=maxlen), SAVE :: type_trac                     !--- Keyword for tracers type(s)

  TYPE :: keys_type                                        !=== TYPE FOR A SET OF KEYS ASSOCIATED TO AN ELEMENT
    CHARACTER(LEN=maxlen)              :: name             !--- Tracer name
    CHARACTER(LEN=maxlen), ALLOCATABLE :: key(:)           !--- Keys string list
    CHARACTER(LEN=maxlen), ALLOCATABLE :: val(:)           !--- Corresponding values string list
  END TYPE keys_type

  TYPE :: trac_type                                        !=== TYPE FOR A SINGLE TRACER NAMED "name"
    CHARACTER(LEN=maxlen) :: name        = ''              !--- Name of the tracer
    CHARACTER(LEN=maxlen) :: gen0Name    = ''              !--- First generation ancestor name
    CHARACTER(LEN=maxlen) :: parent      = ''              !--- Parent name
    CHARACTER(LEN=maxlen) :: longName    = ''              !--- Long name (with advection scheme suffix)
    CHARACTER(LEN=maxlen) :: type        = 'tracer'        !--- Type  (so far: 'tracer' / 'tag')
    CHARACTER(LEN=maxlen) :: phase       = 'g'             !--- Phase ('g'as / 'l'iquid / 's'olid)
    CHARACTER(LEN=maxlen) :: component   = ''              !--- Coma-separated list of components (Ex: lmdz,inca)
    INTEGER               :: iGeneration = -1              !--- Generation number (>=0)
    INTEGER               :: iqParent    = 0               !--- Parent index
    INTEGER,  ALLOCATABLE :: iqDescen(:)                   !--- Descendants index (in growing generation order)
    INTEGER               :: nqDescen    = 0               !--- Number of descendants (all generations)
    INTEGER               :: nqChildren  = 0               !--- Number of children  (first generation)
    TYPE(keys_type)       :: keys                          !--- <key>=<val> pairs vector
    INTEGER               :: iadv        = 10              !--- Advection scheme used
    LOGICAL               :: isInPhysics = .TRUE.          !--- "true" tracers: in tr_seri. COUNT(isInPhysics)=nqtottr
    INTEGER               :: iso_iGroup  = 0               !--- Isotopes group index in isotopes(:)
    INTEGER               :: iso_iName   = 0               !--- Isotope  name  index in isotopes(iso_iGroup)%trac(:)
    INTEGER               :: iso_iZone   = 0               !--- Isotope  zone  index in isotopes(iso_iGroup)%zone(:)
    INTEGER               :: iso_iPhase  = 0               !--- Isotope  phase index in isotopes(iso_iGroup)%phase
  END TYPE trac_type

   TYPE(trac_type), ALLOCATABLE, TARGET, SAVE ::  tracers(:)


!$OMP THREADPRIVATE(nqtot, nbtr, nqo, nqtottr, nqCO2, type_trac)
!$OMP THREADPRIVATE(niso,ntiso)
!$OMP THREADPRIVATE(trac_type,tracers)




CONTAINS

SUBROUTINE init_infotrac_phy(nqtot_, type_trac_)
   IMPLICIT NONE
   INTEGER,          INTENT(IN) :: nqtot_
   CHARACTER(LEN=*), INTENT(IN) :: type_trac_
   CHARACTER(LEN=maxlen) :: modname='init_infotrac_phy'

   nqtot = nqtot_
   type_trac = type_trac_

  END SUBROUTINE init_infotrac_phy

END MODULE infotrac_phy
