MODULE YOMLW15

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOMLW15* - COEFF. OF THE LONGWAVE RADIATION TRANSFER
!*                         FROZEN VERSION (CYCLE 15) OF YOELW
!     ------------------------------------------------------------------

INTEGER(KIND=JPIM) :: MXIXT15
INTEGER(KIND=JPIM) :: NINT15
INTEGER(KIND=JPIM) :: NIPD15
INTEGER(KIND=JPIM) :: NIPD215
INTEGER(KIND=JPIM) :: NTR15
INTEGER(KIND=JPIM) :: NTRA15
INTEGER(KIND=JPIM) :: NUA15
INTEGER(KIND=JPIM) :: NG115
INTEGER(KIND=JPIM) :: NG1P115
REAL(KIND=JPRB) :: AT15(8,3)
REAL(KIND=JPRB) :: BT15(8,3)
REAL(KIND=JPRB) :: RNTNU15(4)
REAL(KIND=JPRB) :: GA15(11,16,3)
REAL(KIND=JPRB) :: GB15(11,16,3)
REAL(KIND=JPRB) :: OCT15(4)
REAL(KIND=JPRB) :: O1H15
REAL(KIND=JPRB) :: O2H15
REAL(KIND=JPRB) :: RPIALF015
REAL(KIND=JPRB) :: RT115(2)
REAL(KIND=JPRB) :: TINTP15(11)
REAL(KIND=JPRB) :: TREF15
REAL(KIND=JPRB) :: TSTAND15
REAL(KIND=JPRB) :: TSTP15
REAL(KIND=JPRB) :: WG115(2)
REAL(KIND=JPRB) :: XP15(6,6)
REAL(KIND=JPRB) :: RVGCO215
REAL(KIND=JPRB) :: RVGH2O15
REAL(KIND=JPRB) :: RVGO315

!        * E.C.M.W.F. PHYSICS PACKAGE *

!        96-11: Ph. Dandin. Meteo-France
!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME        TYPE     PURPOSE
!  ----     :  ----   : ------------------------------------------------
!  MXIXT15  :  INTEGER  MAXIMUM TEMPERATURE INDEX FOR TRANSMISSIVITIES
!  NINT15   :  INTEGER  NUMBER OF SPECTRAL INTERVALS
!  NIPD15   :  INTEGER  NUMBER OF BANDS DESCRIBED BY PADE APPROXIMANTS
!  NIPD215  :  INTEGER  NIPD15*2
!  NTR15    :  INTEGER  NUMBER OF REFERENCE TEMPERATURES
!  NTRA15   :  INTEGER  NUMBER OF TRANSMISSION FUNCTIONS
!  NUA15    :  INTEGER  NUMBER OF ABSORBER AMOUNTS
!  NG115    :  INTEGER  ORDER OF THE GAUSSIAN QUADRATURE
!  NG1P115  :  INTEGER  NG115+1
!  AT15     :  REAL     A-TYPE COEFF. FOR TEMPERATURE DEPENDENCE
!  BT15     :  REAL     B-TYPE COEFF. FOR TEMPERATURE DEPENDENCE
!  RNTNU15  :  REAL     ABSORPTION COEFFICIENT E-TYPE
!  GA15     :  REAL     PADE APPROXIMANTS - NUMERATOR
!  GB15     :  REAL     PADE APPROXIMANTS - DENOMINATOR
!  OCT15    :  REAL     TEMPERATURE DEPENDENCE COEFFICIENTS FOR OZONE
!  O1H15    :  REAL     K/DELTA 1ST OZONE SUB-INTERVAL
!  O2H15    :  REAL     K/DELTA 2ND OZONE SUB-INTERVAL
!  RPIALF015:  REAL     PI*ALFA0/DELTA OZONE SUB-INTERVALS
!  RT115    :  REAL     ROOTS FOR GAUSSIAN QUADRATURE
!  TINTP15  :  REAL     TEMPERATURE INTERVALS FOR TRANSMISSIVITIES
!  TREF15   :  REAL     REF. TEMPERATURE IN PLANCK FUNCTION POLYNOMIAL
!  TSTAND15 :  REAL     REFERENCE TEMPERATURE FOR TEMPERATURE DEPENDENCE
!  TSTP15   :  REAL     TEMEPERATURE STEP BETWEEN TRANSMISSIVITIES
!  WG115    :  REAL     WEIGHTS FOR GAUSSIAN QUADRATURE
!  XP15     :  REAL     POLYNOMIAL COEFFICIENTS OF PLANCK FUNCTION
!  RVGCO215 :  REAL     RESIDUAL PRESSURE FOR CO2 VOIGT LINE HALF-WIDTH
!  RVGH2O15 :  REAL     RESIDUAL PRESSURE FOR H2O VOIGT LINE HALF-WIDTH
!  RVGO315  :  REAL     RESIDUAL PRESSURE FOR O3  VOIGT LINE HALF-WIDTH
!     ------------------------------------------------------------------
!$OMP THREADPRIVATE(at15,bt15,ga15,gb15,mxixt15,ng115,ng1p115,nint15,nipd15,nipd215)
!$OMP THREADPRIVATE(ntr15,ntra15,nua15,o1h15,o2h15,oct15,rntnu15,rpialf015,rt115,rvgco215)
!$OMP THREADPRIVATE(rvgh2o15,rvgo315,tintp15,tref15,tstand15,tstp15,wg115,xp15)
END MODULE YOMLW15
