!$gpum horizontal klon
MODULE lmdz_call_reevap

CONTAINS

   SUBROUTINE call_reevap(klon, klev, abortphy, flag_inhib_tend, itap, &
                          temp, qv, ql, qi, paprs, &
                          d_temp_eva, d_qv_eva, d_ql_eva, d_qi_eva)

      USE lmdz_reevap, ONLY: reevap
      USE add_phys_tend_mod, ONLY: add_phys_tend, prt_enerbil
    
      IMPLICIT NONE
!============================================================================
! call_reevap in the main interface between the LMDZ physics monitor physiq_mod
! and the reevap routine
!
! contact: Etienne Vignon etienne.vignon@lmd.ipsl.fr
!============================================================================

!======================================================================
! Declarations
!======================================================================

! Input variables:
!-----------------
      INTEGER, INTENT(IN) :: klon, klev  ! horizontal and vertical dimensions
      INTEGER, INTENT(IN)   :: abortphy, flag_inhib_tend, itap ! flag and physics time counter for add_phys_tend
      REAL, DIMENSION(klon, klev), INTENT(IN) :: temp ! temperature [K]
      REAL, DIMENSION(klon, klev), INTENT(IN) :: qv ! specific humidity (vapor) [kg/kg]
      REAL, DIMENSION(klon, klev), INTENT(IN) :: ql ! specific liquid water [kg/kg]
      REAL, DIMENSION(klon, klev), INTENT(IN) :: qi ! specific ice water [kg/kg]
      REAL, DIMENSION(klon, klev + 1), INTENT(IN) :: paprs ! pressure at layers bottom interface [Pa]

! Output variables:
!-----------------
      REAL, DIMENSION(klon, klev), INTENT(OUT) :: d_temp_eva ! temperature increment due to evap. [K]
      REAL, DIMENSION(klon, klev), INTENT(OUT) :: d_qv_eva ! specific humidity increment due to evap [kg/kg]
      REAL, DIMENSION(klon, klev), INTENT(OUT) :: d_ql_eva ! specific liquid water increment due to evap [kg/kg]
      REAL, DIMENSION(klon, klev), INTENT(OUT) :: d_qi_eva ! specific ice water increment due to evap [kg/kg]

! Local variables:
!----------------

      REAL, DIMENSION(klon, klev) :: du0, dv0, dqbs0

!======================================================================
! call reevap routine
!======================================================================
     
      CALL reevap(klon, klev, temp, qv, ql, qi, &
      &         d_temp_eva, d_qv_eva, d_ql_eva, d_qi_eva)

     
!======================================================================
! add tendencies
!======================================================================
      du0(:, :) = 0.
      dv0(:, :) = 0.
      dqbs0(:, :) = 0.

      CALL add_phys_tend &
         (du0, dv0, d_temp_eva, d_qv_eva, d_ql_eva, d_qi_eva, dqbs0, paprs, &
          'eva', abortphy, flag_inhib_tend, itap, 0)
      CALL prt_enerbil('eva', itap)

   END SUBROUTINE call_reevap

END MODULE lmdz_call_reevap
