MODULE lmdz_reevap_ini

!--------------------------------------------------------------------
! This module initializes all the parameters needed for reevap
! (evaporation of condensates at the beginning of physics) routines.
!--------------------------------------------------------------------

   IMPLICIT NONE

! parameters for reevap

   REAL :: RCPD, RLSTT, RLVTT, RVTMP2
!$OMP THREADPRIVATE(RCPD, RLSTT, RLVTT, RVTMP2)

   INTEGER :: fl_cor_ebil ! flag for energy conservation
!$OMP THREADPRIVATE(fl_cor_ebil)
   
   INTEGER :: iflag_ice_thermo ! control of activation of thermodynamical effect of ice
!$OMP THREADPRIVATE(iflag_ice_thermo)

CONTAINS

   SUBROUTINE reevap_ini(fl_cor_ebil_in, iflag_ice_thermo_in, RCPD_in, RLSTT_in, RLVTT_in, RVTMP2_in)
      IMPLICIT NONE

      REAL, INTENT(IN)      :: RCPD_in, RLSTT_in, RLVTT_in, RVTMP2_in
      INTEGER, INTENT(IN)   :: iflag_ice_thermo_in, fl_cor_ebil_in

      RCPD = RCPD_in
      RLSTT = RLSTT_in
      RLVTT = RLVTT_in
      RVTMP2 = RVTMP2_in
      iflag_ice_thermo = iflag_ice_thermo_in
      fl_cor_ebil = fl_cor_ebil_in

   END SUBROUTINE reevap_ini

END MODULE lmdz_reevap_ini
