!
! $Id: pbl_surface_mod.F90 5990 2025-12-19 18:14:40Z ymeurdesoif $
!
MODULE pbl_surface_data
!
! Planetary Boundary Layer and Surface module
!
! This module manages the calculation of turbulent diffusion in the boundary layer 
! and all interactions towards the differents sub-surfaces.
!
!
  IMPLICIT NONE

! Declaration of variables saved in restart file
  REAL, ALLOCATABLE, DIMENSION(:), SAVE     :: fder   ! flux drift
  !$OMP THREADPRIVATE(fder)
!GG
  REAL, ALLOCATABLE, DIMENSION(:),  SAVE     :: hice   ! flux drift
  !$OMP THREADPRIVATE(hice)
  REAL, ALLOCATABLE, DIMENSION(:), SAVE     :: tice   ! flux drift
  !$OMP THREADPRIVATE(tice)
  REAL, ALLOCATABLE, DIMENSION(:), SAVE     :: bilg_cumul   ! flux drift
  !$OMP THREADPRIVATE(bilg_cumul)
!GG
  REAL, ALLOCATABLE, DIMENSION(:,:), SAVE    :: snow   ! snow at surface
  !$OMP THREADPRIVATE(snow)
  REAL, ALLOCATABLE, DIMENSION(:,:), SAVE   :: qsurf  ! humidity at surface
  !$OMP THREADPRIVATE(qsurf)
  REAL, ALLOCATABLE, DIMENSION(:,:,:), SAVE          :: ftsoil ! soil temperature
  !$OMP THREADPRIVATE(ftsoil)
  REAL, ALLOCATABLE, DIMENSION(:), SAVE              :: ydTs0, ydqs0  
                                                     ! nul forced temperature and humidity differences
  !$OMP THREADPRIVATE(ydTs0, ydqs0)

#ifdef ISO
  REAL, ALLOCATABLE, DIMENSION(:,:,:), SAVE   :: xtsnow   ! snow at surface
  !$OMP THREADPRIVATE(xtsnow)
  REAL, ALLOCATABLE, DIMENSION(:,:), SAVE   :: Rland_ice   ! snow at surface
  !$OMP THREADPRIVATE(Rland_ice)  
  REAL, ALLOCATABLE, DIMENSION(:,:), SAVE   :: Roce   ! snow at surface
  !$OMP THREADPRIVATE(Roce)  
#endif

  INTEGER, SAVE :: iflag_pbl_surface_t2m_bug
  !$OMP THREADPRIVATE(iflag_pbl_surface_t2m_bug)
  INTEGER, SAVE :: iflag_new_t2mq2m
  !$OMP THREADPRIVATE(iflag_new_t2mq2m)
  LOGICAL, SAVE :: ok_bug_zg_wk_pbl
  !$OMP THREADPRIVATE(ok_bug_zg_wk_pbl)


!JYG<
  REAL, SAVE      :: smallestreal
  !$OMP THREADPRIVATE(smallestreal)

  REAL, SAVE  :: beta_land         ! beta for wx_dts
  !$OMP THREADPRIVATE(beta_land)


END MODULE pbl_surface_data
