MODULE YOMPHY

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!*
!     ------------------------------------------------------------------

!     VARIABLES DE CONTROLE DE LA PHYSIQUE :

! * GROUPE DES CLES GENERALES.
!        LMPHYS  : CLE GENERALE POUR LES PARAMETRISATIONS METEO-FRANCE.
!                : GLOBAL SWITCH FOR METEO-FRANCE PACKAGE.
!        LREASUR : TRUE, ON LIT LES CHAMPS DE SURFACE.
!                : TRUE, SURFACE FIELDS ARE READ.

! * GROUPE DES CLES NE COMMANDANT PAS L'APPEL AUX ROUTINES AM-----.
!        LCAPE   : CLE ACTIVANT LA FERMETURE EN CAPE SI LCVRA.
!                : KEY ACTIVATING THE CAPE CLOSURE IF LCVRA.
!        LCONDWT : CLE ACTIVANT l'EAU LIQUIDE.
!                : KEY ACTIVATING LIQUID WATER.
!        LCVCAS  : CLE ACTIVANT LE CALCUL DES SEGMENTS CONVECTIFS ACTIFS.
!                : KEY ACTIVATING CONVECTIVE ACTIVE SEGMENTS COMPUTATION.
!        LSCMF   : CLE ACTIVANT LE CALCUL DE FRACTIONS MAILLE SIGNIFICATIVES  
!                  KEY ACTIVATING SIGNIFICANT MESH FRACTIONS.
!        LCVDD   : CLE ACTIVANT LE CALCUL DES DOWNDRAFTS.
!                : KEY FOR DOWNDRAFT COMPUTATIONS.
!        LCVLIS  : LORS DU TRAITEMENT PAR LA CONVECTION
!                  DES FLUX DIFFUSIFS TURBULENTS SECS,
!                  CLE ACTIVANT LE TRAITEMENT CONSISTANT DE S ET Q.
!                : KEY TO COMPUTE CONSISTENTLY FOR S AND Q
!                  CONVECTION AND DRY TURBULENT PROCESSES INTERACTION.
!        LCVPGY  : CLE ACTIVANT LES CALCULS DE CONVECTION PROFONDE GY.
!                : KEY ACTIVATING GY CONVECTION CALCULATIONS.
!        LCVPP   : CLE ACTIVANT LES CALCULS DE CONVECTION PEU PROFONDE.
!                : KEY ACTIVATING SHALLOW-CONVECTION CALCULATIONS.
!        LCVPPKF : KEY ACTIVATING THE KFB SCHEME (SHALLOW-CONVECTION).
!       LDIFCONS : CLE ACTIVANT LA DIFFUSION DES VARIABLES CONSERVATIVES.
!                : KEY ACTIVATING VERTICAL DIFFUSION ON CONSERVATIVE VARIABLES.
!        LECT    : CLE ACTIVANT LA DIFFUSION ECT.
!                : KEY ACTIVATING TKE DIFFUSION.
!        LPTKE   : CLE ACTIVANT LA DIFFUSION ECT PSEUDO PROGNOSTIQUE.
!                : KEY ACTIVATING PSEUDO PROGNOSTIC TKE DIFFUSION.
!        LPBLE   : CLE POUR ENTRAINEMENT AU SOMMET DE COUCHE LIMITE (IF LECT).
!                  KEY ACTIVATING THE PBL TOP-ENTRAINMENT RATE.
!        LFPCOR  : CLE POUR UTILISATION DU FLUX DE PRECIP. CONVECTIF LISSE POUR !                  LA NEBUL.
!                : KEY FOR THE USE OF A SMOOTH FLUX OF CONVECTIVE RAIN FOR THE 
!                  CLOUD COVER.
!        LHUNEG  : CLE POUR LA CORRECTION DES HUMIDITES NEGATIVES.
!                : KEY FOR CORRECTION OF NEGATIVE HUMIDITIES.
!        LNEBNXR : CLE ACTIVANT LE CALCUL DE NEBULOSITE XU/RANDALL.
!                : KEY FOR USING XU/RANDALL CLOUDINESS FORMULATION.
!        LHUCN   : CLE ACTIVANT LE NOUVEAU CALCUL D'HUMIDITE CRITIQUE.
!                : KEY FOR USING NEW FORMULATION OF CRITICAL HUMIDITY.
!        LQXRTGH : CLE ACTIVANT LE CALCUL DE LA COURBE TANGENT HYPERBOLIQUE
!                  DE RH DANS LE SCHEMA DE NEBULOSITE XU/RANDALL.
!                : KEY FOR USING TANGENS HYPERBOLIC FUNCTION OF RH PROFILE
!                  IN THE XU/RANDALL CLOUDINESS FORMULATION.
!        LNEIGE  : CLE POUR LA PRISE EN COMPTE DU CYCLE CRYOSCOPIQUE.
!                : KEY FOR THE CRYOSCOPIC CYCLE (PHYSICS AND THERMODS.).
!        LRNUMX  : CLE ACTIVANT LE RECOUVREMENT NUAGEUX MAX. EN RAYONMT.
!                : KEY FOR MAX. OVERLAP OF ADJACENT RADIATIVE CLOUDS.
!        LCLSATUR: CLE ACTIVANT LA DEPENDANCE SUR LA SATURATION DE LA GLACE
!                  ET L'EAU LIQUIDE DANS LE NUAGE.
!                : KEY FOR DEPENDENCY ON IWC/LWC SATURATION.
!        LVOIGT  : CLE ACTIVANT L'EFFET DE VOIGT DANS ACRANEB
!                  KEY FOR VOIGT EFFECT IN ACRANEB.
!        LVFULL  : CLE ACTIVANT LE CALCUL COMPLET D'EFFET VOIGT (PLUS CHER)
!                  KEY FOR COMPREHENSIVE COMPUTATION OF VOIGT EFFECT
!        LRRGUST : CLE ACTIVANT L'INFLUENCE DES "RAFALES HUMIDES" DANS LE
!                : CALCUL DES COEFFICIENTS TURBULENTS.
!                : KEY ACTIVATING "MOIST GUSTINESS" INFLUENCE IN TURBULENT 
!                : COEFFICIENTS COMPUTATION.
!        LSRCON  : CLE ACTIVANT LA SOUSTRACTION DES PRECIPITATIONS RESOLUES
!                  DE LA CONVERGENCE D'HUMIDITE AVANT APPEL DE LA CONVECTION PROFONDE.
!                : KEY TO SUBSTRACT GRID-SCALE PRECIPITATION FROM MOISTURE CONVERGENCE
!                  BEFORE PASSING IT TO DEEP CONVECTION.
!        LSRCONT : CLE ACTIVANT LA SOUSTRACTION DES PRECIPITATIONS RESOLUES
!                  DE L'ENERGIE EN ENTREE DE LA CONVECTION PROFONDE.
!                : KEY TO SUBSTRACT GRID-SCALE PRECIPITATION FROM THE ENERGY FLUXES
!                  IN INPUT TO DEEP CONVECTION.
!        LSLC    : CLE ACTIVANT LA CONVECTION EN PENTE
!                : KEY FOR SLANTWISE CONVECTION
!        LNOIAS  : CLE COUPANT LA CONVECTION POUR DE L INSTABILITE ABSOLUE SECHE.
!                : STOP CONVECTION IN THE CASE OF DRY ABSOLUT INSTABILITY.
!        L2PHYS  : CLE ACTIVANT LE DOUBLE APPEL A APLPAR.
!                : KEY FOR 2 APLPAR CALLS.
!        LRAYLU  : CLE D'APPEL DU RAYONNEMENT LUNAIRE.
!                : KEY FOR CALLING THE MOON RADIATION.
!                  (IN ACRANEB ).
!        LREWS   : CLE D'APPEL DE L'OPTION ECHANGE AVEC LA SURFACE
!                : KEY FOR CALLING THE ECHANGE WITH SURFACE OPTION 
!                  (IN ACRANEB)
!        LRPROX  : CLE D'APPEL DE L'OPTION D'ECHANGE INTER-NIVEAU APPROCHE

!        LRMIX   : ACTIVATION DU CALCUL DE ZMIX (SEE JFG POUR PLUS DE PRECISION)
!                  EPAISSEUR OPTIQUE QQ PART ENTRE MIN ET MAX (ZMIX=0 OU 1)
!                  (POUR LES ECHANGES INTER-NIVEAUX)

!        LRSTAB  :  STABILISATION

!        LRAUTOEV: CALCUL EXACT DONC TRES COUTEUX DES ECHANGES INTER-NIVEAUX

!        LRTPP   : SI .T. L'ECHANGE ENTRE COUCHES ADJACENTES TIENT COMPTE DU 
!                  PROFIL CONTINU DE "T"
!                  IF .T. EXCHANGE TERMS BETWEEN ADJACENT LAYERS USE A 
!                  CONTINUOUS "T" PROFILE
!        LRTDL   : SI .T. LES CALCULS D'ECHANGE ENTRE COUCHES ADJACENTES 
!                  NE SONT PLUS LINEARISES
!                  IF .T. EXCHANGE TERMS BETWEEN ADJACENT LAYERS ARE TREATED 
!                  FULLY NONLINEARLY
!        LRAYPL  : CLE DE RECHERCHE DES PLAGES JOUR/NUIT.
!                : KEY TO LOOK FOR DAY/NIGHT AREAS.
!                  (IN ACRANEB ).
!        LO3ABC  : CLE D'ACTIVATION DES PROFILES D'OZONE CLIMATOLOGIQUES
!                  KEY TO USE CLIMATOLOGICAL PROFILES FOR OZONE
!        LGLT    : CLE ACTIVANT L'UTILISATION DU VENT GEOSTROPHIQUE PLUTOT
!                  QUE LE VENT REEL DANS LE CALCUL DU LIFT
!                : KEY FOR USING GEOSTROPHIC WIND IN PLACE OF REAL WIND
!                  IN THE LIFT COMPUTATION
!        LNEWD   : CLE D'APPEL DE MODIFICATIONS RECENTES DANS LE G.W.D.
!                : KEY FOR CALLING NEW MODIFICATIONS IN THE G.W.D.
!        LPROCLD : KEY FOR CALLING PROGNOSTIC CLOUD PARAMETRIZATION
!        LEVAPP  : KEY FOR ACTIVATING PRECIPITATION EVAPORATION    
!        LCOLLEC : KEY FOR ACTIVATING COLLECTION OF CLOUD CONDENSATE 
!                  BY PRECIPITATION
!        LNSMLIS : KEY FOR ACTIVATING SMOOTHING OF SMITH'S CLOUDINESS
!        LADJCLD : KEY FOR CALLING SMITH'S ADUJSTMENT AFTER DIFFUSION.
!        LAEROSEA: KEY TO USE SEA AEROSOLS
!        LAEROLAN: KEY TO USE LAND AEROSOLS
!        LAEROSOO: KEY TO USE SOOT (?) AEROSOLS
!        LAERODES: KEY TO USE DESERT AEROSOLS
!        LAEROVOL: KEY TO USE VOLCANOES AEROSOLS
!        LAEROSUL: KEY TO USE SULFATES AEROSOLS
!        LRELAXT : KEY TO USE TEMPERATURE RELAXATION
!        LRELAXW : KEY TO USE WATER CONTENT RELAXATION

!        LAUTONEB: KEY FOR DOING AUTOCONVERSION BEFORE RADIATION.
!        LSSD    : KEY ACTIVATING STATISTICAL SEDIMENTATION
!        LZ0HSREL: CLE ACTIVANT L'UTILISATION DE Z0 THERMIQUE SANS RELIEF
!                  KEY TO USE THERMAL ROUGHNESS LENGTH WITHOUT OROGRAPHY
!        L3MT    : CLE ACTIVANT LE SCHEMA 3MT
!                : KEY FOR THE 3MT SCHEME

! * GROUPE DES CLES COMMANDANT L'APPEL AUX ROUTINES AM-----.
!       CGMIXLEN : MNEMONIQUE PERMETTANT DE CHOISIR LE TYPE DE CALCUL DE LONGUEUR DE MELANGE.
!                : MNEMONIC DEFINING THE KIND OF TURBULENT MIXING LENGTH COMPUTATION.
!        LPRGML  : CLE ACTIVANT LA LONGUEUR PRONOSTIQUE DE MELANGE.
!                : KEY FOR PROGNOSTIC MIXING LENGTH.
!        LCVRA   : CLE D'APPEL DE LA CONVECTION PROFONDE.
!                : KEY FOR CALLING DEEP CONVECTION.
!                  ( ACCVIMP ).
!        LCVPRO  : CLE D'APPEL DE LA CONVECTION PRONOSTIQUE.
!                  KEY FOR CALLING PROGNOSTIC CONVECTION.
!                  ( ACCVUD  ).
!        LCDDPRO : CLE D'APPEL DU DOWNDRAFT PRONOSTIQUE.
!                  KEY FOR CALLING PROGNOSTIC DOWNDRAFT.
!                  ( ACMODO  ).
!        LGWD    : CLE D'APPEL DU "GRAVITY WAVE DRAG".
!                : KEY FOR CALLING THE "GRAVITY WAVE DRAG".
!                  ( ACDRAG ).
!        LGWDC   : CLE D'APPEL DU "GRAVITY WAVE DRAG" CONVECTIF.
!                : KEY FOR CALLING THE CONVECTIVE "GRAVITY WAVE DRAG".
!                  ( ACDRAC ).
!        LHMTO   : CLE D'APPEL DES CALCULS AUX HAUTEURS METEO.
!                : KEY FOR INTERPOLATIONS AT SCREEN AND "WIND" HEIGHTS.
!                  ( ACHMT ).
!        LNEBCO  : CLE D'APPEL DE LA NEBULOSITE CONVECTIVE.
!                : KEY FOR SWITCHING ON THE USE OF CONV. CLOUDINESS.
!                  ( ACNEBC ).
!        LNEBN   : CLE D'APPEL DE LA NEBULOSITE "STRA + PREC. CONVECTIVES"
!                : KEY FOR CALLING THE "STRATIFORM + CONV. PRECIP" CLOUDINESS SCHEME.
!                  ( ACNEBN ).
!        LNEBR   : CLE D'APPEL DU SCHEMA STAT. DE GENERATION DES NUAGES.
!                : KEY FOR CALLING THE STAT. SCHEME FOR CLOUDINESS.
!                  ( ACNEBR ).
!        LNEBT   : CLE D'APPEL DE LA NEBULOSITE "CLASSIQUE".
!                : KEY FOR CALLING THE CLASSICAL CLOUDINESS SCHEME.
!                  ( ANEBT ).
!       LND2DIFF : CLE D'APPEL DE LA NEBULOSITE DIAGNOSTIQUE POUR LA DIFFUSION
!                : KEY FOR CALLING DIAGNOSTIC CLOUDINESS FOR DIFFUSION
!        LOZONE  : CLE D'APPEL A LA PHYSIQUE DE L'OZONE.
!                : KEY FOR CALLING THE OZONE'S PHYSICS.
!                  ( ACOZONE ).
!        LRAY    : CLE D'APPEL DU RAYONNEMENT EMERAUDE/PERIDOT.
!                : KEY FOR CALLING THE EMERAUDE/PERIDOT RAD. SCHEME.
!                  ( ACRANEB ).
!        LRAYFM  : CLE D'APPEL DU RAYONNEMENT FMR CEPMMT (PHYSIQUE M-F)
!                : KEY FOR CALLING ECMWF FMR RAD. SCHEME IN M-F PHYSICS
!                  ( RADINT ).
!        LRAYFM15: CLE D'APPEL DU RAYONNEMENT FMR CEPMMT (PHYSIQUE M-F)
!                : KEY FOR CALLING ECMWF FMR RAD. SCHEME IN M-F PHYSICS
!                : VERSION GELEE - FROZEN VERSION - PhD 96/11 ~CYCLE 15
!                  ( RADINT15 ).
!        LRRMES  : CLE D'APPEL AU DRAG MESOSPHERIQUE "NEWTONIEN".
!                  KEY FOR CALLING THE MESOSPHERIC NEWTONIAN DRAG.
!                  ( ACDRME ).
!        LSFHYD  : CLE D'APPEL DU BILAN HYDRIQUE DU SOL "HYPER-SIMPL.".
!                : KEY FOR HYPER-SIMPLIFIED SOIL HYDROLOGY.
!                  ( ACDRO ).
!        LSNV    : CLE D'APPEL DU NOUVEAU SCHEMA DE NEIGE.
!                : KEY FOR THE NEW SNOW SCHEME.
!                  ( ACHMT,ACSOL,ACDROV,ACVEG ).
!        LSOLV   : CLE D'APPEL DE LA NOUVELLE PHYS. DU SOL (VEGET.).
!                : KEY FOR NOILHAN-PLANTON SOIL AND VEGETATION SCHEME.
!                  ( ACSOL,ACDROV,ACVEG ).
!        LFGEL   : CLE D'APPEL DU GEL DE L'EAU DU SOL AVEC ISBA (LSOLV)
!                : KEY FOR SOIL FREEZING WITH ISBA (LSOLV)
!                  ( ACSOL, ACDROV)
!        LVGSN   : CLE POUR COMBINER VEGETATION ET NEIGE
!                : KEY FOR COMBINING VEGETATION AND SNOW
!                  ( ACHMT,ACSOL,ACDROV,ACVEG ).
!        LSTRA   : CLE D'APPEL DES PLUIES STRATIFORMES "CLASSIQUES".
!                  KEY FOR CLASSICAL STRATIFORM PRECIPITATIONS.
!                  ( ACPLUIE ).
!        LSTRAS  : CLE D'APPEL DU SCHEMA DE STAT. DE PRECIPITATION
!                : KEY FOR CALLING THE STAT. SCHEME FOR PRECIPITATION.
!                  ( ACPLUIS ).
!       LSTRAPRO : KEY FOR CALLING ACPLUIE_PROG
!        LTHERMO : CLE D'APPEL DES CALCULS THERMODYNAMIQUES.
!                  KEY FOR CALLING MOIST THERMODYNAMIC CALCULATIONS.
!                  ( ACTQSAT ).
!        LVDIF   : CLE D'APPEL DE LA DIFFUSION VERTICALE "CLASSIQUE".
!                  KEY FOR CALLING THE VERTICAL TURBULENT EXCHANGE.
!                  ( ACHMT,ACCOEFK,ACDIFUS ).
!        LBLVAR  : KEY FOR CALLING SPECIFIC 2M OBS OPERATOR FROM 
!                  LAST LEVEL (USED FOR VARPACK)
!        LPBLE   : Top PBL Entrainment
!       LPHCDPI  : Common dynamisc physics interfase is used if it is TRUE
!       LPIL     : SELECTION OF LUC's PIL INSTEAD OF ORIGINAL LOPEZ
!       LPHSPSH  : KEY FOR PSEUDO HISTORIC SURFACE PRECIP SENSIBLE HEAT
!       LSMNIMBT : NO ICE MELTING BELOW TRIPLE POINT TEMPERATURE (ACQMESM)
!       LSMROT   : USE ROTSTAYN FOR ICE FRACTION IN ACSMI1/ACQMESM
!       LSMTPS   : TRIPLE POINT SMOOTHING (ACSMI1)
!       L1DRHCRI : COMPUTE A SINGLE RHCRIT PROFILE IN LAM
!       LGWRHCRI : USE GAW IN THE RHCRI PROFILE



! * GROUPE DES INDICES DE CALCUL.
!        NBITER : NOMBRE D'ITERATIONS DANS LES BOUCLES DE NEWTON.
!               : NUMBER OF ITERATIONS IN THE NEWTON LOOPS.
!        NDPSFI : INDICATEUR BINAIRE : NDPSFI=1 SI LES VARIATIONS DE LA
!                 MASSE DE L'ATMOSPHERE DUES AU CYCLE HYDROLOGIQUE SONT
!                 MODELISEES, NDPSFI=0 SINON.
!               : BINARY INDICATOR : NDPSFI=1 IF THE VARIATION OF THE
!                 ATMOSPHERIC MASS DUE TO THE HYDROLOGICAL CYCLE HAVE TO
!                 BE TAKEN INTO ACCOUNT, NDPSFI=0 OTHERWISE.
!        NPHYREP: REPRODUCTIBILITE DES CALCULS PHYSIQUES EN MODE MULTI-PROCESSEURS:
!                   1 REPRODUCTIBILITE ASSUREE DANS TOUTE LA PHYSIQUE.
!                   0 REPRODUCTIBILITE NON ASSUREE.
!                  -1 REPRODUCTIBILITE ASSUREE PARTOUT SAUF ACCVIMP ET ACCVIMPD.
!                  -2 REPRODUCTIBILITE ASSUREE PARTOUT SAUF ACDRAG.
!                  -3 REPRODUCTIBILITE ASSUREE PARTOUT SAUF ACPLUI.
!                  -4 REPRODUCTIBILITE ASSUREE PARTOUT SAUF ACRANEB.
!               : REPRODUCTIBILITY OF PHYSICAL COMPUTATIONS IN MULTI-PROCESSORS MODE:
!                   1 REPRODUCTIBILITY ENSURED IN THE WHOLE PHYSICS.
!                   0 REPRODUCTIBILITY NOT ENSURED.
!                  -1 REPRODUCTIBILITY ENSURED EXCEPT IN ACCVIMP ET ACCVIMPD.
!                  OTHER ITEMS: SEE ABOVE THE FRENCH PART OF THE DOC.!...
!        NOIR   : ECLIPSE OU NON? (SOLEIL NOIR!)
!                 NOIR=1 ECLIPSE DU 11.8.1999.
!                 NOIR=0 PAS D'ECLIPSE.
!                 NOIR=-999 ECLIPSE TOUS LES JOURS!... (POUR TESTS D'IMPACT).

!   NPHY :  Number indicating the kind of physics, for DDH

!       NSMTBOT : Temperature to use for qsat at the bottom (acsmi1)
!                     0=interpolate Ts and T_L
!                     1=use T_L
!       NSMDNEB : Cloudiness gradient attenuation mode (acsmi1)
!                     0= no action
!                     1=smoothing
!                     2=gradient limitation with RSMDNEBX
!       NPRAG   : 1 to activate aggregation in ACPREC
!       NPRAC   : 1 to activate accretion in ACPREC
!       NPRRI   : 1 to activate riming in ACPREC

! * GROUPE DES CLES COMMANDANT L'APPEL AUX ROUTINES AM-----.
!       LAJUCV  : CLE D'APPEL DE L'AJUSTEMENT CONVECTIF SEC
!                  KEY FOR CALLING THE DRY CONVECTIVE ADJUSTMENT.
!                  ( ACAJUCV ).
!       LNEBGR  : Schema de Turb/(N,RR)stra de Herve GRENIER  (ACNEBGR)
!       LNEBGY  : Schema de Turb/(N,RR)stra de J.F. GUEREMY   (ACNEBGY)
!       LCVRAV3 : Schema de convect. profonde Bougeault-V3 (ACCVIMP_V3)
!       LBCCOND : Schema de condens. de Bechtold-Chaboureau    (ACCOND)

! * GROUPE DES INDICES DE CALCUL.
INTEGER(KIND=JPIM) :: NBITER
INTEGER(KIND=JPIM) :: NDPSFI
! * GROUPE DES CLES GENERALES.
LOGICAL :: LMPHYS
LOGICAL :: LREASUR
! * GROUPE DES CLES NE COMMANDANT PAS L'APPEL AUX ROUTINES AM-----.
LOGICAL :: LCAPE
LOGICAL :: LCONDWT
LOGICAL :: LCVDD
LOGICAL :: LCVPGY
LOGICAL :: LCVPP
LOGICAL :: LDIFCONS
LOGICAL :: LHUNEG
LOGICAL :: LNEIGE
LOGICAL :: LRNUMX
LOGICAL :: LCLSATUR
LOGICAL :: LVOIGT
LOGICAL :: LVFULL
LOGICAL :: LSRCON
LOGICAL :: LSRCONT
LOGICAL :: LSLC
LOGICAL :: L2PHYS
LOGICAL :: LRAYLU
LOGICAL :: LREWS
LOGICAL :: LRPROX
LOGICAL :: LRMIX
LOGICAL :: LRSTAB
LOGICAL :: LRAUTOEV
LOGICAL :: LRTPP
LOGICAL :: LRTDL
LOGICAL :: LRAYPL
LOGICAL :: LRRGUST
LOGICAL :: LO3ABC
LOGICAL :: LNEBNXR
LOGICAL :: LQXRTGH
LOGICAL :: LHUCN
LOGICAL :: LFPCOR
LOGICAL :: LNOIAS
LOGICAL :: LGLT
LOGICAL :: LNEWD
LOGICAL :: LPROCLD
LOGICAL :: LEVAPP  
LOGICAL :: LCOLLEC 
LOGICAL :: LADJCLD
LOGICAL :: L3MT 
LOGICAL :: LAEROSEA
LOGICAL :: LAEROLAN
LOGICAL :: LAEROSOO
LOGICAL :: LAERODES
LOGICAL :: LAEROVOL
LOGICAL :: LAEROSUL
LOGICAL :: LRELAXT
LOGICAL :: LRELAXW
LOGICAL :: LAUTONEB
LOGICAL :: LSSD
LOGICAL :: LPBLE
LOGICAL :: LNSMLIS
LOGICAL :: LBLVAR
LOGICAL :: LZ0HSREL

! * GROUPE DES CLES COMMANDANT L'APPEL AUX ROUTINES AM-----.
CHARACTER (LEN = 20) ::  CGMIXLEN
LOGICAL :: LPRGML
LOGICAL :: LCVRA
LOGICAL :: LCVPRO
LOGICAL :: LCDDPRO
LOGICAL :: LECT
LOGICAL :: LPTKE
LOGICAL :: LGWD
LOGICAL :: LGWDC
LOGICAL :: LHMTO
LOGICAL :: LNEBCO
LOGICAL :: LNEBN
LOGICAL :: LNEBR
LOGICAL :: LNEBT
LOGICAL :: LND2DIFF
LOGICAL :: LOZONE
LOGICAL :: LRAY
LOGICAL :: LRAYFM
LOGICAL :: LRAYFM15
LOGICAL :: LRRMES
LOGICAL :: LSFHYD
LOGICAL :: LSNV
LOGICAL :: LSOLV
LOGICAL :: LFGEL
LOGICAL :: LSTRA
LOGICAL :: LSTRAS
LOGICAL :: LSTRAPRO
LOGICAL :: LNEWSTAT
LOGICAL :: LTHERMO
LOGICAL :: LVDIF
LOGICAL :: LFGELS
LOGICAL :: LCVLIS
LOGICAL :: LCVCAS
LOGICAL :: LSCMF 
LOGICAL :: LVGSN
LOGICAL :: LPHCDPI
LOGICAL :: LAJUCV
LOGICAL :: LNEBGR
LOGICAL :: LNEBGY
LOGICAL :: LCVRAV3
LOGICAL :: LBCCOND
LOGICAL :: LCVPPKF
LOGICAL :: LECTFL 
INTEGER(KIND=JPIM) :: NPHYREP
INTEGER(KIND=JPIM) :: NOIR
LOGICAL :: LPIL
LOGICAL :: LPHSPSH
LOGICAL :: LSMNIMBT
LOGICAL :: LSMROT
LOGICAL :: LSMTPS
LOGICAL :: L1DRHCRI
LOGICAL :: LGWRHCRI
INTEGER (KIND=JPIM) :: NSMTBOT
INTEGER (KIND=JPIM) :: NSMDNEB
INTEGER (KIND=JPIM) :: NPRAG, NPRAC, NPRRI
INTEGER(KIND=JPIM)  :: NPHY  
! Values that NPHY can obtain: 
INTEGER(KIND=JPIM), PARAMETER  ::   JPHYEC =   1  ! for ECMWF physics
INTEGER(KIND=JPIM), PARAMETER  ::   JPHYMF =   2  ! for MF physics
INTEGER(KIND=JPIM), PARAMETER  ::  JPHYARO =   3  ! for AROME physics
!     ------------------------------------------------------------------
!$OMP THREADPRIVATE(cgmixlen,l1drhcri,l2phys,l3mt,ladjcld,laerodes,laerolan,laerosea,laerosoo,laerosul)
!$OMP THREADPRIVATE(laerovol,lajucv,lautoneb,lbccond,lblvar,lcape,lcddpro,lclsatur,lcollec,lcondwt,lcvcas)
!$OMP THREADPRIVATE(lcvdd,lcvlis,lcvpgy,lcvpp,lcvppkf,lcvpro,lcvra,lcvrav3,ldifcons,lect,lectfl,levapp,lfgel)
!$OMP THREADPRIVATE(lfgels,lfpcor,lglt,lgwd,lgwdc,lgwrhcri,lhmto,lhucn,lhuneg,lmphys,lnd2diff,lnebco,lnebgr)
!$OMP THREADPRIVATE(lnebgy,lnebn,lnebnxr,lnebr,lnebt,lneige,lnewd,lnewstat,lnoias,lnsmlis,lo3abc,lozone,lpble)
!$OMP THREADPRIVATE(lphcdpi,lphspsh,lpil,lprgml,lprocld,lptke,lqxrtgh,lrautoev,lray,lrayfm,lrayfm15,lraylu)
!$OMP THREADPRIVATE(lraypl,lreasur,lrelaxt,lrelaxw,lrews,lrmix,lrnumx,lrprox,lrrgust,lrrmes,lrstab,lrtdl)
!$OMP THREADPRIVATE(lrtpp,lscmf,lsfhyd,lslc,lsmnimbt,lsmrot,lsmtps,lsnv,lsolv,lsrcon,lsrcont,lssd,lstra)
!$OMP THREADPRIVATE(lstrapro,lstras,lthermo,lvdif,lvfull,lvgsn,lvoigt,lz0hsrel,nbiter,ndpsfi,noir,nphy)
!$OMP THREADPRIVATE(nphyrep,nprac,nprag,nprri,nsmdneb,nsmtbot)
END MODULE YOMPHY
