SUBROUTINE diverg_gam_loc(klevel,cuvscvgam,cvuscugam,unsairegam, &
        unsapolnga,unsapolsga,  x, y,  div )
  !
  ! P. Le Van
  !
  !  *********************************************************************
  !  ... calcule la divergence a tous les niveaux d'1 vecteur de compos.
  ! x et y...
  !          x et y  etant des composantes covariantes   ...
  !  *********************************************************************
  USE comgeom_mod_h
  USE parallel_lmdz
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h
IMPLICIT NONE
  !
  !  x  et  y  sont des arguments  d'entree pour le s-prog
  !    div      est  un argument  de sortie pour le s-prog
  !
  !



  !
  !    ..........          variables en arguments    ...................
  !
  INTEGER :: klevel
  REAL :: x( ijb_u:ije_u,klevel ),y( ijb_v:ije_v,klevel )
  REAL :: div( ijb_u:ije_u,klevel )
  REAL :: cuvscvgam(ip1jm),cvuscugam(ip1jmp1),unsairegam(ip1jmp1)
  REAL :: unsapolnga,unsapolsga
  !
  !    ...............     variables  locales   .........................

  REAL :: aiy1( iip1 ) , aiy2( iip1 )
  REAL :: sumypn,sumyps
  INTEGER :: l,ij
  !    ...................................................................
  !
  EXTERNAL  SSUM
  REAL :: SSUM
  INTEGER :: ijb,ije,jjb,jje
  !
  !
  ijb=ij_begin
  ije=ij_end
  if (pole_nord) ijb=ij_begin+iip1
  if(pole_sud)  ije=ij_end-iip1

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l = 1,klevel
  !
    DO  ij = ijb, ije - 1
     div( ij + 1, l )     = ( &
           cvuscugam( ij+1 ) * x( ij+1,l ) - cvuscugam( ij ) * x( ij , l) + &
           cuvscvgam(ij-iim) * y(ij-iim,l) - cuvscvgam(ij+1) * y(ij+1,l) )* &
           unsairegam( ij+1 )
    ENDDO
  !
  ! ....  correction pour  div( 1,j,l)  ......
  ! ....   div(1,j,l)= div(iip1,j,l) ....
  !
  !DIR$ IVDEP
    DO  ij = ijb,ije,iip1
     div( ij,l ) = div( ij + iim,l )
    ENDDO
  !
  ! ....  calcul  aux poles  .....
  !
   if (pole_nord) then
      DO  ij  = 1,iim
       aiy1(ij) =    cuvscvgam(    ij       ) * y(     ij     , l )
      ENDDO
      sumypn = SSUM ( iim,aiy1,1 ) * unsapolnga
  !
      DO  ij = 1,iip1
       div(     ij    , l ) = - sumypn
      ENDDO
   endif

    if (pole_sud) then
      DO  ij  = 1,iim
       aiy2(ij) =    cuvscvgam( ij+ ip1jmi1 ) * y( ij+ ip1jmi1, l )
      ENDDO
      sumyps = SSUM ( iim,aiy2,1 ) * unsapolsga
  !
      DO  ij = 1,iip1
       div( ij + ip1jm, l ) =   sumyps
      ENDDO
   endif
  END DO
!$OMP END DO NOWAIT
  !

   RETURN
END SUBROUTINE diverg_gam_loc
