MODULE YOMPHY1

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!*
!     ------------------------------------------------------------------
!     CONSTANTES PHYSIQUES REGLABLES INTERVENANT DANS LA DEFINITION DU
!     SOL, DE LA NEIGE OU DE LA VEGETATION :
!       ALB1    : COEFF. POUR LE SCHEMA (LVGSN).
!               : COEFF. FOR THE SNOW SCHEME (LVGSN).
!       ALB2    : COEFF. POUR LE SCHEMA (LVGSN).
!               : COEFF. FOR THE SNOW SCHEME (LVGSN).
!       ALBGLA  : ALBEDO BANQUISE (SANS NEIGE).
!               : SNOW FREE SEA-ICE ALBEDO.
!       ALBMAX  : ALBEDO MAXIMUM DE LA NEIGE.
!               : MAXIMUM SNOW ALBEDO.
!       ALBMER  : ALBEDO MER.
!               : OPEN SEA ALBEDO.
!       ALBMED  : ALBEDO MER DIFFUS.
!               : OPEN SEA DIFFUSE ALBEDO.
!       ALBMIN  : ALBEDO MINIMUM DE LA NEIGE.
!               : MINIMUM SNOW ALBEDO.
!       ALCRIN  : ALBEDO DE LA NEIGE.
!               : SNOW ALBEDO.
!       ALRCN1  : PREMIERE CONSTANTE POUR L'INFLUENCE NEIGEUSE SUR Z0.
!               : FIRST CONSTANT FOR THE SNOW'S INFLUENCE ON Z0.
!       ALRCN2  : DEUXIEME CONSTANTE POUR L'INFLUENCE NEIGEUSE SUR Z0.
!               : SECOND CONSTANT FOR THE SNOW'S INFLUENCE ON Z0.
!       EA      : EXPOSANT DANS LE SCHEMA SOL-VEGETATION
!               : EXPONENT IN THE SOIL-VEGETATION SCHEME
!       EC2REF  : IDEM
!       EMCRIN  : EMISSIVITE DE LA NEIGE.
!               : SNOW EMISSIVITY.
!       EMMGLA  : EMISSIVITE DE LA BANQUISE
!               : SEA-ICE EMISSIVITY.
!       EMMMER  : EMISSIVITE DE LA MER
!               : OPEN SEA EMISSIVITY.
!       EWFC    : EXPOSANT DANS LE SCHEMA SOL-VEGETATION
!               : EXPONENT IN THE SOIL-VEGETATION SCHEME
!       EWWILT  : IDEM
!       GA      : COEFFICIENT DE REGRESSION DANS LE SCHEMA SOL-VEGETATION
!               : REGRESSION COEFFICIENT IN THE SOIL-VEGETATION SCHEME
!       GC1     : IDEM.
!       GC1S1, GC1S2, GC1S3, GC1S4 : COEFFICIENT POUR LE C1 PHASE VAPEUR
!                                  : COEFFICIENT FOR C1 VAPOUR PHASE
!       GTSVAP  : =0 PTS VARIABLE POUR LE CALCUL DU MAX DE C1. SI < 0 -GTSVAP
!                 REPRESENTE LA TEMPERATURE CONSTANTE EN DEGRE CELSIUS
!                 =0 PTS VARIABLE FOR THE COMPUTATION OF THE MAX OF C1. IF
!                 < 0 -GTSVAP IS CONSTANT TEMPERATURE IN DEGRE
!       GC1Y1   : VALEUR DU C1 POUR WS=0 POUR LA PHASE VAPEUR DE C1
!               : VALUE OF C1 FOR WS=0 FOR VAPOUR PHASE OF C1
!       GVEGMX,GLAIMX,GNEIMX,GWPIMX,GCGEL: COEFF POUR EAU GELEE DU SOL PROFOND.
!       GVEGMX,GLAIMX,GNEIMX,GWPIMX,GCGEL: COEFF FOR ICE IN DEEP SOIL.
!       GVEGMXS,GLAIMXS,GNEIMXS,GCGELS: COEFF POUR EAU GELEE DE SURFACE.
!       GVEGMXS,GLAIMXS,GNEIMXS,GCGELS: COEFF FOR ICE IN THE SUPERFICIAL
!               RESERVOIR.
!       GC2     : REGRESSION COEFFICIENT IN THE SOIL-VEGETATION SCHEME
!       GC2REF  : IDEM.
!       GC3     : IDEM.
!       GCZ0H   : IDEM.
!       GC31    : COEFFICIENT POUR LE DRAINAGE PROFOND (SOL-VEGETATION)
!               : COEFFICIENT FOR THE DEEP SOIL DRAINAGE (SOIL-VEGETATION)
!       GC32    : IDEM
!       GCONV   : FACTEUR DE CHANGEMENT D'UNITE (MASSE VOL. DE L'EAU LIQUIDE)
!       GF1     : COEFFICIENT DE LA FONCTION F1 (SOL-VEGETATION).
!               : COEFFICIENT FOR THE FUNCTION F1 (SOIL-VEGETATION).
!       GF3(18) : COEFFICIENT DE LA FONCTION F3 (SOL-VEGETATION)
!               : COEFFICIENT FOR THE FUNCTION F3 (SOIL-VEGETATION)
!       GF4(18) : COEFFICIENT DE LA FONCTION F4 (SOL-VEGETATION)
!               : COEFFICIENT FOR THE FUNCTION F4 (SOIL-VEGETATION)
!       GWFC    : COEFFICIENT DE REGRESSION DANS LE SCHEMA SOL-VEGETATION
!               : REGRESSION COEFFICIENT IN THE SOIL-VEGETATION SCHEME
!       GWWILT  : IDEM.
!       G1B     : IDEM.
!       G1CGSAT : IDEM.
!       G1C1SAT : IDEM.
!       G1P     : COEFFICIENT DE REGRESSION DANS LE SCHEMA SOL-VEGETATION
!               : REGRESSION COEFFICIENT IN THE SOIL-VEGETATION SCHEME
!       G1WSAT  : IDEM.
!       G2B     : IDEM.
!       G2CGSAT : IDEM.
!       G2C1SAT : IDEM.
!       G2P     : IDEM.
!       G2WSAT  : IDEM.
!       G3CGSAT : IDEM.
!       GSNC1   : IDEM (LSNV).
!       GSNC2   : IDEM (LSNV).
!       GWLEX   : (WL/WLMX)**GWLEX POUR LE CALCUL DU COEF. D'HALSTEAD.
!               : (WL/WLMX)**GWLEX FOR THE HALSTEAD COEF.
!       GWLMX   : COEFFICIENT POUR LE RESERVOIR D'INTERCEPTION MAX.
!               : COEFFICIENT FOR INTERCEPTION WATER CONTENT.
!       HSOL    : INVERSE DE L'INERTIE DU SOL EN SURFACE.
!               : INVERSE OF THE SURFACE SOIL INERTIA.
!       HSOLIWR : INVERSE DE LA QUANTITE CRITIQUE EN EAU (CALCUL DE HSOL).
!               : INVERSE OF CRITICAL SOIL WATER CONTENT (HSOL COMPUTATION).
!       HSOLIT0 : INVERSE DE LA LARGEUR CRITIQUE EN TEMPERATURE (CALCUL DE HSOL).
!               : INVERSE OF TEMPERATURE CRITICAL DEVIATION (HSOL COMPUTATION).
!       NTVGLA  : INDICE DE VEGETATION SUR GLACE.
!               : VEGETATION INDEX OVER ICE.
!       NTVMER  : INDICE DE VEGETATION SUR MER.
!               : VEGETATION INDEX OVER SEA.
!       OMTPRO  : 2 PI SUR LA PER. DE RAPP. DE LA TEMPERATURE PROFONDE.
!               : 2 PI DIVIDED BY THE TIME CONSTANT OF DEEP TEMPERATURE.
!       OMWPRO  : 1.   SUR LA PER. DE RAPP. DU CONTENU EN EAU PROFOND.
!               : 1.   DIVIDED BY THE TIME CONSTANT OF DEEP SOIL WATER.
!       RC1MAX  : VALEUR MAXIMALE DU COEFFICIENT HYDRIQUE G1=C1/RD1
!               : MAXIMUM VALUE FOR THE HYDRIC COEFFICIENT G1
!       RCTGLA  : COEFFICIENT THERMIQUE DE LA GLACE
!               : ICE THERMAL COEFFICIENT.
!       RCGMAX  : COEFFICIENT THERMIQUE DU SOL NU MAXIMUM
!               : MAXIMUM THERMAL BARE GROUND COEFFICIENT.
!       RCTVEG  : COEFFICIENT THERMIQUE DE LA VEGETATION.
!          (18) : VEGETATION THERMAL COEFFICIENT.
!       RD1     : EPAISSEUR DU RESERVOIR SUPERFICIEL.
!               : UPPER RESERVOIR DEPTH.
!       RD2GLA  : EPAISSEUR DU RESERVOIR BANQUISE.
!               : SEA-ICE RESERVOIR DEPTH.
!       RD2MER  : EPAISSEUR DU RESERVOIR MER.
!               : OPEN SEA RESERVOIR DEPTH.
!       RGL(18) : VALEUR LIMITE DU RAYONNEMENT GLOBAL DEPENDANT DU TYPE
!                 DE VEGETATION. RGL INTERVIENT DANS LE CALCUL DE RSTO.
!               : VEGETATION RADIATIVE COEFFICIENT LIMITING GLOBAL
!                 RADIATION. RGL IS USED IN THE COMPUTATION OF RSTO.
!       RHOMAX  : DENSITE MAXIMUM DE LA NEIGE.
!               : MAXIMUM SNOW DENSITY.
!       RHOMIN  : DENSITE MINIMUM DE LA NEIGE.
!               : MINIMUM SNOW DENSITY.
!       RLAIMX  : LAI MAX POUR LE SCHEMA (LVGSN).
!               : LAI MAX FOR THE SNOW SCHEME (LVGSN).
!       RLAI    : LAI A PARTIR DUQUEL ON REDUIT LA FRACTION DE NEIGE (LVGSN).
!               : LAI FROM WHICH THE SNOW FRACTION IS REDUCED (LVGSN).
!       RSMAX   : RESISTANCE STOMATIQUE MAXIMALE.
!               : MAXIMUM STOMATAL RESISTANCE
!       RTINER  : RAPPORT DES INERTIES THERMIQUES PROFONDEUR/SURFACE.
!               : RATIO OF THE DEEP/SURFACE THERMAL INERTIAS.
!       RZ0GLA  : LONGUEUR RUGOSITE DYNAMIQUE DE LA BANQUISE
!               : DYNAMICAL ROUGHNESS LENGTH OF SEA-ICE
!       RZ0MER  : LONGUEUR RUGOSITE DYNAMIQUE DE LA MER
!               : DYNAMICAL ROUGHNESS LENGTH OF SEA
!       RZHZ0G  : RAPPORT LONGUEUR DE RUGOSITE THERMIQUE SUR LONGUEUR
!                 RUGOSITE DYNAMIQUE DE LA BANQUISE
!               : RATIO OF THERMAL ROUGHNESS LENGTH ON DYNAMICAL 
!                 ROUGHNESS LENGTH OF SEA-ICE
!       RZHZ0M  : RAPPORT LONGUEUR DE RUGOSITE THERMIQUE SUR LONGUEUR
!                 RUGOSITE DYNAMIQUE DE LA MER
!               : RATIO OF THERMAL ROUGHNESS LENGTH ON DYNAMICAL 
!                 ROUGHNESS LENGTH OF SEA
!       SODELX(0:9): DISCRETISATION VERTICALE DU SOL (MAXI 10 COUCHES)
!                : SOIL VERTICAL DISCRETIZATION (MAX 10 LAYERS)
!       TMERGL  : TEMPERATURE DE FONTE DE LA GLACE DE MER.
!               : MELTING TEMPERATURE OF FLOATING ICE.
!       TOEXP   : TAUX DE DECROISSANCE EXPONENTIELLE DE L'ALBEDO ET
!                 ET DE LA DENSITE DE LA NEIGE EN PERIODE DE FONTE.
!               : RATE OF EXPONENTIAL DECREASE IN SNOW ALBEDO AND DENSITY
!                 DURING SNOW MELT.
!       TOLIN   : TAUX DE DECROISSANCE LINEAIRE DE L'ALBEDO DE LA NEIGE
!                 EN PERIODE D'ACCUMULATION.
!               : RATE OF LINEAR DECREASE IN SNOW ALBEDO
!                 DURING SNOW ACCUMULATION.
!       TREF4(18): TEMPERATURE SEUIL DE LA FONCTION F4 (SOL-VEGETATION)
!                : THRESHOLD TEMPERATURE IN F4 FUNCTION (SOIL-VEGETATION)
!       WCRIN   : QUANTITE CRITIQUE POUR LA NEIGE MI-COUVRANTE.
!               : CRITICAL TRANSITION VALUE FOR SNOW DEPTH (HALF-COVER).
!       WCRINC  : QUANTITE CRITIQUE POUR LA NEIGE MI-COUVRANTE.
!                 (CALCULS THERMIQUES)
!               : CRITICAL TRANSITION VALUE FOR SNOW DEPTH (HALF-COVER).
!                 (THERMIC CALCULATIONS)
!       WCRING  : QUANTITE CRITIQUE POUR LA NEIGE MI-COUVRANTE.
!                 (CALCULS RADIATIFS ET EVAPORATION)
!               : CRITICAL TRANSITION VALUE FOR SNOW DEPTH (HALF-COVER).
!                 (RADIATIVE CALCULATIONS AND EVAPORATION)
!       WNEW    : PRECIPITIONS DE NEIGE MINIMUM (MM) POUR RENOUVELER
!                 L'ALBEDO DE LA NEIGE.
!               : MINIMUM SNOWFALL (MM) TO RENEW THE SNOW ALBEDO.
!       WPMX    : VALEUR MAXIMUN POUR LE CONTENU EN EAU EN PROFONDEUR.
!               : MAXIMUM VALUE FOR DEEP SOIL WATER CONTENT.
!       WSMX    : VALEUR MAXIMUN POUR LE CONTENU EN EAU DE SURFACE.
!               : MAXIMUM VALUE FOR SURFACE SOIL WATER CONTENT.
!       XCRINR  : COEFFICIENT DANS LE FACTEUR ZNR DETERMINANT
!                 L'INFLUENCE DU RELIEF SOUS-MAILLE
!                 SUR LES FRACTIONS DE NEIGE
!               : COEFFICIENT IN THE FACTOR ZNR DETERMINING
!                 THE INFLUENCE OF SUBGRID OROGRAPHY
!                 ON THE SNOW COVER FRACTIONS
!       XCRINV  : COEFFICIENT DE LA FRACTION PNEIJV DE NEIGE RECOUVRANT
!                 LA VEGETATION.
!               : COEFFICIENT FOR THE FRACTION PNEIJV OF SNOW COVERING
!                 THE CANOPY.
!       LIMC    : BORNE SUPERIEURE POUR CT
!               : UPPER BOUND FOR CT
!       LIMW    : CONTROLE DE W/Wwilt POUR CG,C1,C2
!               : CHECKING W/Wwilt
!       LC1VAP  : PHASE VAPEUR POUR LE C1
!               : VAPOUR PHASE FOR C1

REAL(KIND=JPRB) :: GF3(18)
REAL(KIND=JPRB) :: GF4(18)
REAL(KIND=JPRB) :: TREF4(18)
REAL(KIND=JPRB) :: RCTVEG(18)
REAL(KIND=JPRB) :: RGL(18)
REAL(KIND=JPRB) :: SODELX(0:9)
REAL(KIND=JPRB) :: GCZ0H(0:3,4)
REAL(KIND=JPRB) :: ALBGLA
REAL(KIND=JPRB) :: ALBMAX
REAL(KIND=JPRB) :: ALBMER
REAL(KIND=JPRB) :: ALBMED
REAL(KIND=JPRB) :: ALBMIN
REAL(KIND=JPRB) :: ALCRIN
REAL(KIND=JPRB) :: ALRCN1
REAL(KIND=JPRB) :: ALRCN2
REAL(KIND=JPRB) :: EA
REAL(KIND=JPRB) :: EC2REF
REAL(KIND=JPRB) :: EMCRIN
REAL(KIND=JPRB) :: EMMGLA
REAL(KIND=JPRB) :: EMMMER
REAL(KIND=JPRB) :: EWFC
REAL(KIND=JPRB) :: EWWILT
REAL(KIND=JPRB) :: GA
REAL(KIND=JPRB) :: GC1
REAL(KIND=JPRB) :: GC1S1
REAL(KIND=JPRB) :: GC1S2
REAL(KIND=JPRB) :: GC1S3
REAL(KIND=JPRB) :: GC1S4
REAL(KIND=JPRB) :: GC1Y1
REAL(KIND=JPRB) :: GTSVAP
REAL(KIND=JPRB) :: GVEGMX
REAL(KIND=JPRB) :: GLAIMX
REAL(KIND=JPRB) :: GNEIMX
REAL(KIND=JPRB) :: GWPIMX
REAL(KIND=JPRB) :: GCGEL
REAL(KIND=JPRB) :: GC2
REAL(KIND=JPRB) :: GC2REF
REAL(KIND=JPRB) :: GC3
REAL(KIND=JPRB) :: GC31
REAL(KIND=JPRB) :: GC32
REAL(KIND=JPRB) :: GCONV
REAL(KIND=JPRB) :: GF1
REAL(KIND=JPRB) :: GWFC
REAL(KIND=JPRB) :: GWLEX
REAL(KIND=JPRB) :: GWLMX
REAL(KIND=JPRB) :: GWWILT
REAL(KIND=JPRB) :: G1B
REAL(KIND=JPRB) :: G1CGSAT
REAL(KIND=JPRB) :: G1C1SAT
REAL(KIND=JPRB) :: G1P
REAL(KIND=JPRB) :: G1WSAT
REAL(KIND=JPRB) :: G2B
REAL(KIND=JPRB) :: G2CGSAT
REAL(KIND=JPRB) :: G2C1SAT
REAL(KIND=JPRB) :: G2P
REAL(KIND=JPRB) :: G2WSAT
REAL(KIND=JPRB) :: G3CGSAT
REAL(KIND=JPRB) :: GSNC1
REAL(KIND=JPRB) :: GSNC2
REAL(KIND=JPRB) :: HSOL
REAL(KIND=JPRB) :: HSOLIWR
REAL(KIND=JPRB) :: HSOLIT0
REAL(KIND=JPRB) :: OMTPRO
REAL(KIND=JPRB) :: OMWPRO
REAL(KIND=JPRB) :: RC1MAX
REAL(KIND=JPRB) :: RCTGLA
REAL(KIND=JPRB) :: RCGMAX
REAL(KIND=JPRB) :: RD1
REAL(KIND=JPRB) :: RD2GLA
REAL(KIND=JPRB) :: RD2MER
REAL(KIND=JPRB) :: RHOMAX
REAL(KIND=JPRB) :: RHOMIN
REAL(KIND=JPRB) :: RSMAX
REAL(KIND=JPRB) :: RTINER
REAL(KIND=JPRB) :: RZ0GLA
REAL(KIND=JPRB) :: RZ0MER
REAL(KIND=JPRB) :: RZHZ0G
REAL(KIND=JPRB) :: RZHZ0M
REAL(KIND=JPRB) :: RZHGLA
REAL(KIND=JPRB) :: RZHMER
REAL(KIND=JPRB) :: TMERGL
REAL(KIND=JPRB) :: TOEXP
REAL(KIND=JPRB) :: TOLIN
REAL(KIND=JPRB) :: WCRIN
REAL(KIND=JPRB) :: WCRINC
REAL(KIND=JPRB) :: WCRING
REAL(KIND=JPRB) :: WNEW
REAL(KIND=JPRB) :: WPMX
REAL(KIND=JPRB) :: WSMX
REAL(KIND=JPRB) :: XCRINR
REAL(KIND=JPRB) :: XCRINV
LOGICAL :: LIMC
LOGICAL :: LIMW
LOGICAL :: LC1VAP
INTEGER(KIND=JPIM) :: NTVGLA
INTEGER(KIND=JPIM) :: NTVMER
REAL(KIND=JPRB) :: GCGELS
REAL(KIND=JPRB) :: GVEGMXS
REAL(KIND=JPRB) :: GLAIMXS
REAL(KIND=JPRB) :: GNEIMXS
REAL(KIND=JPRB) :: ALB1
REAL(KIND=JPRB) :: ALB2
REAL(KIND=JPRB) :: RLAIMX
REAL(KIND=JPRB) :: RLAI
INTEGER(KIND=JPIM) :: NCHSP
!     ------------------------------------------------------------------
!$OMP THREADPRIVATE(alb1,alb2,albgla,albmax,albmed,albmer,albmin,alcrin,alrcn1,alrcn2,ea,ec2ref,emcrin,emmgla)
!$OMP THREADPRIVATE(emmmer,ewfc,ewwilt,g1b,g1c1sat,g1cgsat,g1p,g1wsat,g2b,g2c1sat,g2cgsat,g2p,g2wsat,g3cgsat)
!$OMP THREADPRIVATE(ga,gc1,gc1s1,gc1s2,gc1s3,gc1s4,gc1y1,gc2,gc2ref,gc3,gc31,gc32,gcgel,gcgels,gconv,gcz0h,gf1)
!$OMP THREADPRIVATE(gf3,gf4,glaimx,glaimxs,gneimx,gneimxs,gsnc1,gsnc2,gtsvap,gvegmx,gvegmxs,gwfc,gwlex,gwlmx)
!$OMP THREADPRIVATE(gwpimx,gwwilt,hsol,hsolit0,hsoliwr,lc1vap,limc,limw,nchsp,ntvgla,ntvmer,omtpro,omwpro,rc1max)
!$OMP THREADPRIVATE(rcgmax,rctgla,rctveg,rd1,rd2gla,rd2mer,rgl,rhomax,rhomin,rlai,rlaimx,rsmax,rtiner,rz0gla)
!$OMP THREADPRIVATE(rz0mer,rzhgla,rzhmer,rzhz0g,rzhz0m,sodelx,tmergl,toexp,tolin,tref4,wcrin,wcrinc,wcring)
!$OMP THREADPRIVATE(wnew,wpmx,wsmx,xcrinr,xcrinv)
END MODULE YOMPHY1
