MODULE YOMSW15

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOMSW15* - COEFFICIENTS FOR SHORTWAVE RADIATION TRANSFER
!*                         FROZEN VERSION (CYCLE 15) OF YOESW
!     ------------------------------------------------------------------

REAL(KIND=JPRB) :: APAD15(2,3,7)
REAL(KIND=JPRB) :: BPAD15(2,3,7)
REAL(KIND=JPRB) :: RRAY15(2,6)
REAL(KIND=JPRB) :: RSUN15(2)
REAL(KIND=JPRB) :: RPDH115
REAL(KIND=JPRB) :: RPDU115
REAL(KIND=JPRB) :: RPNH15
REAL(KIND=JPRB) :: RPNU15
REAL(KIND=JPRB) :: RSWCE15
REAL(KIND=JPRB) :: RSWCP15
REAL(KIND=JPRB) :: RTDH2O15
REAL(KIND=JPRB) :: RTDUMG15
REAL(KIND=JPRB) :: RTH2O15
REAL(KIND=JPRB) :: RTUMG15
REAL(KIND=JPRB) :: D15(2,3)

!        * E.C.M.W.F. PHYSICS PACKAGE *

!        96-11: Ph. Dandin. Meteo-France
!     ORIGINAL BY J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME       TYPE     PURPOSE
!  ----    :  ----   : -------------------------------------------------
!  APAD15  :  REAL     PADE APPROXIMANTS NUMERATOR
!  BPAD15  :  REAL     PADE APPROXIMANTS DENOMINATOR
!  D15     :  REAL     TRANSMISSION LIMIT FOR INFINITE ABSORBER AMOUNT
!  RRAY15  :  REAL     RAYLEIGH SCATTERING COEFFICIENTS
!  RSUN15  :  REAL     SOLAR FRACTION IN SPECTRAL INTERVALS
!  RPDH115 :  1 + EXPONENT PRESSURE DEPENDENCE H2O
!  RPDU115 :  1 + EXPONENT PRESSURE DEPENDENCE UNIFORMLY MIXED GASES
!  RPNH15  :  REFERENCE PRESSURE FACTOR FOR H2O
!  RPNU15  :  REFERENCE PRESSURE FACTOR FOR UNIFORMLY MIXED GASES
!  RSWCE15 :  E-TYPE, H2O CONTINUUM ABSORP. COEFFICIENT OVER 0.68-4 MU
!  RSWCP15 :  P-TYPE, H2O CONTINUUM ABSORP. COEFFICIENT OVER 0.68-4 MU
!  RTDH2O15:  EXPONENT TEMPERATURE DEPENDENCE H2O
!  RTDUMG15:  EXPONENT TEMPERATURE DEPENDENCE UNIFORMLY MIXED GASES
!  RTH2O15 :  REFERENCE TEMPERATURE H2O
!  RTUMG15 :  REFERENCE TEMPERATURE UNIFORMLY MIXED GASES
!     -----------------------------------------------------------------
!$OMP THREADPRIVATE(apad15,bpad15,d15,rpdh115,rpdu115,rpnh15,rpnu15,rray15,rsun15,rswce15,rswcp15)
!$OMP THREADPRIVATE(rtdh2o15,rtdumg15,rth2o15,rtumg15)
END MODULE YOMSW15
