MODULE YOEPHY

USE PARKIND1  ,ONLY : JPRB, JPIM

IMPLICIT NONE

SAVE

!     -----------------------------------------------------------------
!*    ** *YOEPHY* - SWITCHES RELATED TO DIABATIC PROCESSES
!     -----------------------------------------------------------------

!        * E.C.M.W.F. PHYSICS PACKAGE *

LOGICAL :: LEPHYS
LOGICAL :: LECOND
LOGICAL :: LECUMF
LOGICAL :: LEDCLD
LOGICAL :: LEEVAP
LOGICAL :: LEGWDG
LOGICAL :: LEOZOC
LOGICAL :: LEQNGT
LOGICAL :: LERADI
LOGICAL :: LERADS
LOGICAL :: LESHCV
LOGICAL :: LESICE
LOGICAL :: LESURF
LOGICAL :: LEVDIF
LOGICAL :: LAGPHY
LOGICAL :: LEPCLD
LOGICAL :: LEO3CH
LOGICAL :: LECO2DIU
LOGICAL :: LBUD23
LOGICAL :: LEMETHOX
LOGICAL :: LERA40
LOGICAL :: LECURR
LOGICAL :: LVDFTRAC
LOGICAL :: LMFTRAC
LOGICAL :: LERAIN
LOGICAL :: LE4ALB
LOGICAL :: LEMWAVE
LOGICAL :: LEOCWA
LOGICAL :: LEOCCO
LOGICAL :: LEOCSA
REAL(KIND=JPRB) :: RTHRFRTI
INTEGER(KIND=JPIM) :: NPHYINT
INTEGER(KIND=JPIM) :: NPHPROMA
INTEGER (KIND=JPIM) :: NEPHYS_PCFULL

!     REFERENCE.
!     ----------

!     J.-J. MORCRETTE       E.C.M.W.F.      91/07/14

!     MODIFICATIONS
!     -------------

!     P. Viterbo   ECMWF   03-12-2004  Include user-defined RTHRFRTI
!     ------------------------------------------------------------------

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
! LEPHYS : LOGICAL : SWITCH THE FULL E.C.M.W.F. PHYSICS PACKAGE ON
! LAGPHY : LOGICAL : IF TRUE, PHYSICS PACKAGE CALLED IN LAGGED MODE
! LECOND : LOGICAL : TURN THE LARGE-SCALE CONDENSATION ON
! LECUMF : LOGICAL : TURN THE MASS-FLUX CUMULUS CONVECTION SCHEME ON
! LEDCLD : LOGICAL : TURN THE DIAGNOSTIC CLOUD SCHEME ON
! LEPCLD : LOGICAL : TURN THE PROGNOSTIC CLOUD SCHEME ON
! LEEVAP : LOGICAL : TURN THE EVAPORATION OF PRECIPITATION ON
! LEGWDG : LOGICAL : TURN THE GRAVITY WAVE DRAG ON
! LEOZOC : LOGICAL : TURN THE CLIMATOLOGICAL OZONE ON
! LEQNGT : LOGICAL : TURN THE NEGATIVE HUMIDITY FIXER ON
! LERADI : LOGICAL : TURN THE RADIATION SCHEME ON
! LERADS : LOGICAL : TURN THE INTERACTIVE SURFACE RADIATIVE PROPERTIESON
! LESHCV : LOGICAL : TURN THE SHALLOW CONV. IN THE MASS-FLUX SCHEME ON
! LESICE : LOGICAL : TURN THE INTERACTIVE SEA ICE PROCESSES ON
! LESURF : LOGICAL : TURN THE INTERACTIVE SURFACE PROCESSES ON
! LEVDIF : LOGICAL : TURN THE VERTICAL DIFFUSION ON
! LEO3CH : LOGICAL : TURN THE O3 CHEMISTRY ON (for EC prog. ozone)
! LECO2DIU: LOGICAL: UPDATE THE NBF CO2 FLUXES CLIMATOLOGY DURING THE RUN OF THE MODEL (introduce a diurnal cycle)
! LBUD23 : LOGICAL : SWITCH FOR 3 AND 2 DIMENSIONAL BUDGETS 
! LEMETHOX: LOGICAL: TURN THE METHANE OXIDATION ON
! LERA40 : LOGICAL : EXTRA PHYSICS DIAGNOSTICS FOR ERA40
! LECURR : LOGICAL : IF TRUE, OCEAN CURRENT BOUNDARY CONDITION IS USED
! LVDFTRAC: LOGICAL: TURN TRACER TRANSPORT BY VERTICAL DIFFUSION ON 
! LMFTRAC: LOGICAL : TURN TRACER TRANSPORT BY MASS FLUX CONVECTION ON
! LERAIN : LOGICAL : RAIN ASSIMILATION
! LE4ALB : LOGICAL : MODIS ALBEDO ON (DIRECT+DIFFUSE)*(UVIS+NIR) 
! LEOCWA : LOGICAL : WARM OCEAN LAYER PARAMETRIZATION
! LEOCCO : LOGICAL : COOL OCEAN SKIN PARAMETRIZATION
! LEOCSA : LOGICAL : SALINTY EFFECT ON SATURATION AT OCEAN SURFACE
! RTHRFRTI : INTEGER : MINIMUM FRACTION FOR ALL SURFACE TILES
! LE4ALB : LOGICAL  : MODIS ALBEDO (UV-Vis+NIR)x(direct+diffuse) 
!     -----------------------------------------------------------------

!$OMP THREADPRIVATE(lagphy,lbud23,le4alb,leco2diu,lecond,lecumf,lecurr,ledcld)
!$OMP THREADPRIVATE(leevap,legwdg,lemethox,lemwave,leo3ch,leocco,leocsa,leocwa)
!$OMP THREADPRIVATE(leozoc,lepcld,lephys,leqngt,lera40,leradi,lerads,lerain)
!$OMP THREADPRIVATE(leshcv,lesice,lesurf,levdif,lmftrac,lvdftrac,nephys_pcfull)
!$OMP THREADPRIVATE(nphproma,nphyint,rthrfrti)

END MODULE YOEPHY
