SUBROUTINE RRTM_KGB6

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 6:  820-980 cm-1 (low - H2O; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.
!     G.Mozdzynski March 2011 read constants from files
!     ABozzo 201306 updated to rrtmg v4.85
!     T. Wilhelmsson and K. Yessad (Oct 2013) Geometry and setup refactoring.
!      F. Vana  05-Mar-2015  Support for single precision
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK, JPHOOK
USE YOMLUN    ,ONLY : NULRAD
USE MPL_MODULE,ONLY : MPL_BROADCAST
USE YOMTAG    ,ONLY : MTAGRAD

USE YOERRTO6 , ONLY : KAO     ,KAO_MCO2, SELFREFO, FORREFO ,FRACREFAO ,CFC11ADJO ,&
 & CFC12O, KAO_D 
USE YOMMP0    , ONLY : NPROC, MYPROC

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPHOOK) :: ZHOOK_HANDLE

#include "abor1.intfb.h"

IF (LHOOK) CALL DR_HOOK('RRTM_KGB6',0,ZHOOK_HANDLE)

IF( MYPROC==1 )THEN
  READ(NULRAD,ERR=1001) KAO_D
  KAO = REAL(KAO_D,JPRB)
ENDIF
IF( NPROC>1 )THEN
  CALL MPL_BROADCAST (KAO,MTAGRAD,1,CDSTRING='RRTM_KGB6:')
ENDIF


! Planck fraction mapping level : P = 473.4280 mb, T = 259.83 K
FRACREFAO(:) = (/ &
  &   1.4353E-01_JPRB,1.4774E-01_JPRB,1.4467E-01_JPRB,1.3785E-01_JPRB,1.2376E-01_JPRB,1.0214E-01_JPRB, &
  &   8.1984E-02_JPRB,6.1152E-02_JPRB,4.0987E-02_JPRB,4.5067E-03_JPRB,4.0020E-03_JPRB,3.1772E-03_JPRB, &
  &   2.3458E-03_JPRB,1.5025E-03_JPRB,5.7415E-04_JPRB,8.2970E-05_JPRB/)

! Minor gas mapping level:
!     lower - co2, p = 706.2720 mb, t = 294.2 k
!     upper - cfc11, cfc12


!     CFC11 is multiplied by 1.385 to account for the 1060-1107 cm-1 band.
CFC11ADJO( :) = (/&
 & 0.0_JPRB,      0.0_JPRB, 36.7627_JPRB, 150.757_JPRB,    &
 & 81.4109_JPRB, 74.9112_JPRB, 56.9325_JPRB, 49.3226_JPRB,  &
 & 57.1074_JPRB, 66.1202_JPRB, 109.557_JPRB, 89.0562_JPRB,  &
 & 149.865_JPRB, 196.140_JPRB, 258.393_JPRB, 80.9923_JPRB/)  

CFC12O( :) = (/&
 & 62.8368_JPRB, 43.2626_JPRB, 26.7549_JPRB, 22.2487_JPRB,&
 & 23.5029_JPRB, 34.8323_JPRB, 26.2335_JPRB, 23.2306_JPRB,&
 & 18.4062_JPRB, 13.9534_JPRB, 22.6268_JPRB, 24.2604_JPRB,&
 & 30.0088_JPRB, 26.3634_JPRB, 15.8237_JPRB, 57.5050_JPRB/)  


!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.


!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      KAO_MCO2(:, 1) = (/ &
     & 1.45661E-05_JPRB, 1.73337E-05_JPRB, 2.06273E-05_JPRB, 2.45466E-05_JPRB, 2.92105E-05_JPRB, &
     & 3.47607E-05_JPRB, 4.13654E-05_JPRB, 4.92251E-05_JPRB, 5.85781E-05_JPRB, 6.97083E-05_JPRB, &
     & 8.29533E-05_JPRB, 9.87149E-05_JPRB, 1.17471E-04_JPRB, 1.39792E-04_JPRB, 1.66353E-04_JPRB, &
     & 1.97961E-04_JPRB, 2.35574E-04_JPRB, 2.80335E-04_JPRB, 3.33600E-04_JPRB/)
      KAO_MCO2(:, 2) = (/ &
     & 9.96332E-06_JPRB, 1.21229E-05_JPRB, 1.47506E-05_JPRB, 1.79478E-05_JPRB, 2.18381E-05_JPRB, &
     & 2.65716E-05_JPRB, 3.23310E-05_JPRB, 3.93389E-05_JPRB, 4.78658E-05_JPRB, 5.82408E-05_JPRB, &
     & 7.08647E-05_JPRB, 8.62250E-05_JPRB, 1.04914E-04_JPRB, 1.27655E-04_JPRB, 1.55325E-04_JPRB, &
     & 1.88992E-04_JPRB, 2.29957E-04_JPRB, 2.79801E-04_JPRB, 3.40448E-04_JPRB/)
      KAO_MCO2(:, 3) = (/ &
     & 1.14968E-05_JPRB, 1.39890E-05_JPRB, 1.70215E-05_JPRB, 2.07115E-05_JPRB, 2.52013E-05_JPRB, &
     & 3.06644E-05_JPRB, 3.73118E-05_JPRB, 4.54002E-05_JPRB, 5.52420E-05_JPRB, 6.72173E-05_JPRB, &
     & 8.17887E-05_JPRB, 9.95188E-05_JPRB, 1.21092E-04_JPRB, 1.47343E-04_JPRB, 1.79283E-04_JPRB, &
     & 2.18148E-04_JPRB, 2.65438E-04_JPRB, 3.22980E-04_JPRB, 3.92995E-04_JPRB/)
      KAO_MCO2(:, 4) = (/ &
     & 1.02186E-05_JPRB, 1.23232E-05_JPRB, 1.48613E-05_JPRB, 1.79222E-05_JPRB, 2.16134E-05_JPRB, &
     & 2.60649E-05_JPRB, 3.14332E-05_JPRB, 3.79071E-05_JPRB, 4.57145E-05_JPRB, 5.51297E-05_JPRB, &
     & 6.64843E-05_JPRB, 8.01773E-05_JPRB, 9.66905E-05_JPRB, 1.16605E-04_JPRB, 1.40621E-04_JPRB, &
     & 1.69583E-04_JPRB, 2.04510E-04_JPRB, 2.46631E-04_JPRB, 2.97426E-04_JPRB/)
      KAO_MCO2(:, 5) = (/ &
     & 1.03469E-05_JPRB, 1.24680E-05_JPRB, 1.50239E-05_JPRB, 1.81037E-05_JPRB, 2.18149E-05_JPRB, &
     & 2.62869E-05_JPRB, 3.16756E-05_JPRB, 3.81690E-05_JPRB, 4.59935E-05_JPRB, 5.54220E-05_JPRB, &
     & 6.67833E-05_JPRB, 8.04737E-05_JPRB, 9.69704E-05_JPRB, 1.16849E-04_JPRB, 1.40803E-04_JPRB, &
     & 1.69667E-04_JPRB, 2.04448E-04_JPRB, 2.46359E-04_JPRB, 2.96861E-04_JPRB/)
      KAO_MCO2(:, 6) = (/ &
     & 1.71660E-05_JPRB, 2.07334E-05_JPRB, 2.50420E-05_JPRB, 3.02461E-05_JPRB, 3.65317E-05_JPRB, &
     & 4.41235E-05_JPRB, 5.32930E-05_JPRB, 6.43680E-05_JPRB, 7.77446E-05_JPRB, 9.39010E-05_JPRB, &
     & 1.13415E-04_JPRB, 1.36984E-04_JPRB, 1.65451E-04_JPRB, 1.99835E-04_JPRB, 2.41363E-04_JPRB, &
     & 2.91522E-04_JPRB, 3.52104E-04_JPRB, 4.25276E-04_JPRB, 5.13654E-04_JPRB/)
      KAO_MCO2(:, 7) = (/ &
     & 4.78803E-05_JPRB, 5.79395E-05_JPRB, 7.01119E-05_JPRB, 8.48418E-05_JPRB, 1.02666E-04_JPRB, &
     & 1.24235E-04_JPRB, 1.50336E-04_JPRB, 1.81920E-04_JPRB, 2.20139E-04_JPRB, 2.66388E-04_JPRB, &
     & 3.22354E-04_JPRB, 3.90077E-04_JPRB, 4.72028E-04_JPRB, 5.71197E-04_JPRB, 6.91199E-04_JPRB, &
     & 8.36413E-04_JPRB, 1.01214E-03_JPRB, 1.22477E-03_JPRB, 1.48209E-03_JPRB/)
      KAO_MCO2(:, 8) = (/ &
     & 1.27954E-04_JPRB, 1.55281E-04_JPRB, 1.88445E-04_JPRB, 2.28692E-04_JPRB, 2.77534E-04_JPRB, &
     & 3.36808E-04_JPRB, 4.08741E-04_JPRB, 4.96037E-04_JPRB, 6.01977E-04_JPRB, 7.30542E-04_JPRB, &
     & 8.86566E-04_JPRB, 1.07591E-03_JPRB, 1.30570E-03_JPRB, 1.58456E-03_JPRB, 1.92298E-03_JPRB, &
     & 2.33367E-03_JPRB, 2.83208E-03_JPRB, 3.43694E-03_JPRB, 4.17097E-03_JPRB/)
      KAO_MCO2(:, 9) = (/ &
     & 2.93792E-05_JPRB, 3.55109E-05_JPRB, 4.29223E-05_JPRB, 5.18805E-05_JPRB, 6.27083E-05_JPRB, &
     & 7.57960E-05_JPRB, 9.16151E-05_JPRB, 1.10736E-04_JPRB, 1.33847E-04_JPRB, 1.61782E-04_JPRB, &
     & 1.95547E-04_JPRB, 2.36359E-04_JPRB, 2.85689E-04_JPRB, 3.45315E-04_JPRB, 4.17384E-04_JPRB, &
     & 5.04495E-04_JPRB, 6.09787E-04_JPRB, 7.37054E-04_JPRB, 8.90882E-04_JPRB/)
      KAO_MCO2(:,10) = (/ &
     & 5.08569E-05_JPRB, 6.24700E-05_JPRB, 7.67350E-05_JPRB, 9.42574E-05_JPRB, 1.15781E-04_JPRB, &
     & 1.42220E-04_JPRB, 1.74695E-04_JPRB, 2.14587E-04_JPRB, 2.63588E-04_JPRB, 3.23778E-04_JPRB, &
     & 3.97712E-04_JPRB, 4.88530E-04_JPRB, 6.00085E-04_JPRB, 7.37114E-04_JPRB, 9.05433E-04_JPRB, &
     & 1.11219E-03_JPRB, 1.36616E-03_JPRB, 1.67812E-03_JPRB, 2.06131E-03_JPRB/)
      KAO_MCO2(:,11) = (/ &
     & 4.82546E-06_JPRB, 6.21462E-06_JPRB, 8.00369E-06_JPRB, 1.03078E-05_JPRB, 1.32752E-05_JPRB, &
     & 1.70969E-05_JPRB, 2.20188E-05_JPRB, 2.83575E-05_JPRB, 3.65211E-05_JPRB, 4.70348E-05_JPRB, &
     & 6.05753E-05_JPRB, 7.80138E-05_JPRB, 1.00472E-04_JPRB, 1.29397E-04_JPRB, 1.66647E-04_JPRB, &
     & 2.14622E-04_JPRB, 2.76407E-04_JPRB, 3.55980E-04_JPRB, 4.58459E-04_JPRB/)
      KAO_MCO2(:,12) = (/ &
     & 2.41346E-06_JPRB, 2.96282E-06_JPRB, 3.63723E-06_JPRB, 4.46516E-06_JPRB, 5.48153E-06_JPRB, &
     & 6.72926E-06_JPRB, 8.26100E-06_JPRB, 1.01414E-05_JPRB, 1.24498E-05_JPRB, 1.52837E-05_JPRB, &
     & 1.87627E-05_JPRB, 2.30335E-05_JPRB, 2.82765E-05_JPRB, 3.47129E-05_JPRB, 4.26144E-05_JPRB, &
     & 5.23144E-05_JPRB, 6.42225E-05_JPRB, 7.88410E-05_JPRB, 9.67871E-05_JPRB/)
      KAO_MCO2(:,13) = (/ &
     & 2.76412E-06_JPRB, 3.46195E-06_JPRB, 4.33596E-06_JPRB, 5.43062E-06_JPRB, 6.80164E-06_JPRB, &
     & 8.51879E-06_JPRB, 1.06695E-05_JPRB, 1.33631E-05_JPRB, 1.67367E-05_JPRB, 2.09621E-05_JPRB, &
     & 2.62542E-05_JPRB, 3.28824E-05_JPRB, 4.11839E-05_JPRB, 5.15813E-05_JPRB, 6.46035E-05_JPRB, &
     & 8.09134E-05_JPRB, 1.01341E-04_JPRB, 1.26925E-04_JPRB, 1.58969E-04_JPRB/)
      KAO_MCO2(:,14) = (/ &
     & 1.25126E-06_JPRB, 1.54971E-06_JPRB, 1.91935E-06_JPRB, 2.37715E-06_JPRB, 2.94416E-06_JPRB, &
     & 3.64640E-06_JPRB, 4.51615E-06_JPRB, 5.59335E-06_JPRB, 6.92749E-06_JPRB, 8.57985E-06_JPRB, &
     & 1.06263E-05_JPRB, 1.31610E-05_JPRB, 1.63001E-05_JPRB, 2.01881E-05_JPRB, 2.50034E-05_JPRB, &
     & 3.09672E-05_JPRB, 3.83536E-05_JPRB, 4.75018E-05_JPRB, 5.88319E-05_JPRB/)
      KAO_MCO2(:,15) = (/ &
     & 1.59748E-06_JPRB, 2.08378E-06_JPRB, 2.71812E-06_JPRB, 3.54557E-06_JPRB, 4.62491E-06_JPRB, &
     & 6.03282E-06_JPRB, 7.86932E-06_JPRB, 1.02649E-05_JPRB, 1.33897E-05_JPRB, 1.74658E-05_JPRB, &
     & 2.27827E-05_JPRB, 2.97182E-05_JPRB, 3.87649E-05_JPRB, 5.05657E-05_JPRB, 6.59589E-05_JPRB, &
     & 8.60380E-05_JPRB, 1.12230E-04_JPRB, 1.46394E-04_JPRB, 1.90959E-04_JPRB/)
      KAO_MCO2(:,16) = (/ &
     & 1.68148E-06_JPRB, 2.17133E-06_JPRB, 2.80388E-06_JPRB, 3.62071E-06_JPRB, 4.67549E-06_JPRB, &
     & 6.03756E-06_JPRB, 7.79642E-06_JPRB, 1.00677E-05_JPRB, 1.30006E-05_JPRB, 1.67879E-05_JPRB, &
     & 2.16786E-05_JPRB, 2.79941E-05_JPRB, 3.61493E-05_JPRB, 4.66803E-05_JPRB, 6.02792E-05_JPRB, &
     & 7.78398E-05_JPRB, 1.00516E-04_JPRB, 1.29799E-04_JPRB, 1.67612E-04_JPRB/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      FORREFO(1,:) = (/ &
     &3.2710E-07_JPRB,5.2119E-07_JPRB,8.4740E-07_JPRB,1.6908E-06_JPRB,2.3433E-06_JPRB,4.4129E-06_JPRB, &
     &3.8930E-06_JPRB,2.3338E-06_JPRB,2.4115E-06_JPRB,2.4271E-06_JPRB,2.4836E-06_JPRB,2.6470E-06_JPRB, &
     &2.9559E-06_JPRB,2.3940E-06_JPRB,2.9711E-06_JPRB,2.9511E-06_JPRB/)
      FORREFO(2,:) = (/ &
     &6.5125E-07_JPRB,1.2128E-06_JPRB,1.7249E-06_JPRB,2.7126E-06_JPRB,3.1780E-06_JPRB,2.1444E-06_JPRB, &
     &1.8265E-06_JPRB,1.7385E-06_JPRB,1.4574E-06_JPRB,1.6135E-06_JPRB,2.4966E-06_JPRB,2.8127E-06_JPRB, &
     &2.5229E-06_JPRB,2.3251E-06_JPRB,2.5353E-06_JPRB,3.0200E-06_JPRB/)
      FORREFO(3,:) = (/ &
     &1.4969E-06_JPRB,1.8516E-06_JPRB,2.5791E-06_JPRB,2.7846E-06_JPRB,1.9789E-06_JPRB,1.6688E-06_JPRB, &
     &1.1037E-06_JPRB,9.9065E-07_JPRB,1.1557E-06_JPRB,7.0847E-07_JPRB,5.7758E-07_JPRB,4.0425E-07_JPRB, &
     &3.2427E-07_JPRB,3.2267E-07_JPRB,3.1444E-07_JPRB,2.6046E-07_JPRB/)
      FORREFO(4,:) = (/ &
     &1.7567E-06_JPRB,1.6891E-06_JPRB,2.1003E-06_JPRB,2.0957E-06_JPRB,2.3664E-06_JPRB,2.1538E-06_JPRB, &
     &1.5275E-06_JPRB,1.0487E-06_JPRB,8.7390E-07_JPRB,7.9360E-07_JPRB,7.7778E-07_JPRB,8.1445E-07_JPRB, &
     &8.2121E-07_JPRB,5.4395E-07_JPRB,3.1273E-07_JPRB,3.1848E-07_JPRB/)


!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      SELFREFO(:, 1) = (/ &
     & 7.73921E-02_JPRB, 6.45225E-02_JPRB, 5.37930E-02_JPRB, 4.48477E-02_JPRB, 3.73900E-02_JPRB, &
     & 3.11723E-02_JPRB, 2.59887E-02_JPRB, 2.16670E-02_JPRB, 1.80640E-02_JPRB, 1.50601E-02_JPRB/)
      SELFREFO(:, 2) = (/ &
     & 8.47756E-02_JPRB, 7.10616E-02_JPRB, 5.95660E-02_JPRB, 4.99301E-02_JPRB, 4.18529E-02_JPRB, &
     & 3.50824E-02_JPRB, 2.94072E-02_JPRB, 2.46500E-02_JPRB, 2.06624E-02_JPRB, 1.73199E-02_JPRB/)
      SELFREFO(:, 3) = (/ &
     & 8.84829E-02_JPRB, 7.46093E-02_JPRB, 6.29110E-02_JPRB, 5.30469E-02_JPRB, 4.47295E-02_JPRB, &
     & 3.77161E-02_JPRB, 3.18025E-02_JPRB, 2.68160E-02_JPRB, 2.26114E-02_JPRB, 1.90661E-02_JPRB/)
      SELFREFO(:, 4) = (/ &
     & 9.27003E-02_JPRB, 7.88864E-02_JPRB, 6.71310E-02_JPRB, 5.71273E-02_JPRB, 4.86144E-02_JPRB, &
     & 4.13700E-02_JPRB, 3.52052E-02_JPRB, 2.99590E-02_JPRB, 2.54946E-02_JPRB, 2.16955E-02_JPRB/)
      SELFREFO(:, 5) = (/ &
     & 9.14315E-02_JPRB, 7.85661E-02_JPRB, 6.75110E-02_JPRB, 5.80115E-02_JPRB, 4.98487E-02_JPRB, &
     & 4.28344E-02_JPRB, 3.68072E-02_JPRB, 3.16280E-02_JPRB, 2.71776E-02_JPRB, 2.33534E-02_JPRB/)
      SELFREFO(:, 6) = (/ &
     & 7.72984E-02_JPRB, 6.91044E-02_JPRB, 6.17790E-02_JPRB, 5.52301E-02_JPRB, 4.93755E-02_JPRB, &
     & 4.41414E-02_JPRB, 3.94622E-02_JPRB, 3.52790E-02_JPRB, 3.15392E-02_JPRB, 2.81959E-02_JPRB/)
      SELFREFO(:, 7) = (/ &
     & 7.46998E-02_JPRB, 6.66597E-02_JPRB, 5.94850E-02_JPRB, 5.30825E-02_JPRB, 4.73691E-02_JPRB, &
     & 4.22707E-02_JPRB, 3.77210E-02_JPRB, 3.36610E-02_JPRB, 3.00380E-02_JPRB, 2.68049E-02_JPRB/)
      SELFREFO(:, 8) = (/ &
     & 7.59386E-02_JPRB, 6.66263E-02_JPRB, 5.84560E-02_JPRB, 5.12876E-02_JPRB, 4.49982E-02_JPRB, &
     & 3.94801E-02_JPRB, 3.46387E-02_JPRB, 3.03910E-02_JPRB, 2.66642E-02_JPRB, 2.33944E-02_JPRB/)
      SELFREFO(:, 9) = (/ &
     & 7.26921E-02_JPRB, 6.43261E-02_JPRB, 5.69230E-02_JPRB, 5.03719E-02_JPRB, 4.45747E-02_JPRB, &
     & 3.94447E-02_JPRB, 3.49051E-02_JPRB, 3.08880E-02_JPRB, 2.73332E-02_JPRB, 2.41875E-02_JPRB/)
      SELFREFO(:,10) = (/ &
     & 7.43684E-02_JPRB, 6.58735E-02_JPRB, 5.83490E-02_JPRB, 5.16840E-02_JPRB, 4.57803E-02_JPRB, &
     & 4.05509E-02_JPRB, 3.59189E-02_JPRB, 3.18160E-02_JPRB, 2.81818E-02_JPRB, 2.49626E-02_JPRB/)
      SELFREFO(:,11) = (/ &
     & 8.97599E-02_JPRB, 7.73727E-02_JPRB, 6.66950E-02_JPRB, 5.74908E-02_JPRB, 4.95569E-02_JPRB, &
     & 4.27179E-02_JPRB, 3.68227E-02_JPRB, 3.17410E-02_JPRB, 2.73606E-02_JPRB, 2.35848E-02_JPRB/)
      SELFREFO(:,12) = (/ &
     & 9.12262E-02_JPRB, 7.84848E-02_JPRB, 6.75230E-02_JPRB, 5.80922E-02_JPRB, 4.99786E-02_JPRB, &
     & 4.29982E-02_JPRB, 3.69927E-02_JPRB, 3.18260E-02_JPRB, 2.73809E-02_JPRB, 2.35567E-02_JPRB/)
      SELFREFO(:,13) = (/ &
     & 9.03254E-02_JPRB, 7.83291E-02_JPRB, 6.79260E-02_JPRB, 5.89046E-02_JPRB, 5.10813E-02_JPRB, &
     & 4.42970E-02_JPRB, 3.84139E-02_JPRB, 3.33120E-02_JPRB, 2.88877E-02_JPRB, 2.50511E-02_JPRB/)
      SELFREFO(:,14) = (/ &
     & 9.22803E-02_JPRB, 7.94172E-02_JPRB, 6.83470E-02_JPRB, 5.88199E-02_JPRB, 5.06209E-02_JPRB, &
     & 4.35647E-02_JPRB, 3.74921E-02_JPRB, 3.22660E-02_JPRB, 2.77684E-02_JPRB, 2.38977E-02_JPRB/)
      SELFREFO(:,15) = (/ &
     & 9.36819E-02_JPRB, 8.10810E-02_JPRB, 7.01750E-02_JPRB, 6.07359E-02_JPRB, 5.25665E-02_JPRB, &
     & 4.54959E-02_JPRB, 3.93764E-02_JPRB, 3.40800E-02_JPRB, 2.94960E-02_JPRB, 2.55286E-02_JPRB/)
      SELFREFO(:,16) = (/ &
     & 1.00195E-01_JPRB, 8.58713E-02_JPRB, 7.35950E-02_JPRB, 6.30737E-02_JPRB, 5.40566E-02_JPRB, &
     & 4.63286E-02_JPRB, 3.97054E-02_JPRB, 3.40290E-02_JPRB, 2.91641E-02_JPRB, 2.49948E-02_JPRB/)

IF (LHOOK) CALL DR_HOOK('RRTM_KGB6',1,ZHOOK_HANDLE)

RETURN

1001 CONTINUE
CALL ABOR1("RRTM_KGB6:ERROR READING FILE RADRRTM")

END SUBROUTINE RRTM_KGB6
