MODULE SET_RESOL_MOD
CONTAINS
SUBROUTINE SET_RESOL(KRESOL)
USE PARKIND1  ,ONLY : JPIM     ,JPRB

USE TPM_GEN
USE TPM_DIM
USE TPM_TRANS
USE TPM_DISTR
USE TPM_GEOMETRY
USE TPM_FIELDS
USE TPM_FFT
USE ABORT_TRANS_MOD

IMPLICIT NONE

! Declaration of arguments

INTEGER(KIND=JPIM) ,OPTIONAL, INTENT(IN) :: KRESOL

! Local varaibles
INTEGER(KIND=JPIM) :: IRESOL

!     ------------------------------------------------------------------

IRESOL = 1
IF(PRESENT(KRESOL)) THEN
  IF(KRESOL < 1 .OR. KRESOL > NMAX_RESOL) THEN
    WRITE(NOUT,*)'SET_RESOL: UNKNOWN RESOLUTION ',KRESOL,NMAX_RESOL
    CALL ABORT_TRANS('SET_RESOL:KRESOL < 1 .OR. KRESOL > NMAX_RESOL')
  ENDIF
  IRESOL = KRESOL
ENDIF
IF(IRESOL /= NCUR_RESOL) THEN
  NCUR_RESOL = IRESOL 
  R => DIM_RESOL(NCUR_RESOL)
  F => FIELDS_RESOL(NCUR_RESOL)
  G => GEOM_RESOL(NCUR_RESOL)
  D => DISTR_RESOL(NCUR_RESOL)
  T => FFT_RESOL(NCUR_RESOL)
ENDIF

END SUBROUTINE SET_RESOL
END MODULE SET_RESOL_MOD
