SUBROUTINE RRTM_KGB3

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 3:  500-630 cm-1 (low - H2O,CO2; high - H2O,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.
!     G.Mozdzynski March 2011 read constants from files
!     ABozzo 201305 updated to rrtmg_lw_v4.85:
!     band 3:  500-630 cm-1 (low key - h2o,co2; low minor - n2o)
!                           (high key - h2o,co2; high minor - n2o)     
!     T. Wilhelmsson and K. Yessad (Oct 2013) Geometry and setup refactoring.
!      F. Vana  05-Mar-2015  Support for single precision
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK, JPHOOK
USE YOMLUN    ,ONLY : NULRAD
USE MPL_MODULE,ONLY : MPL_BROADCAST
USE YOMTAG    ,ONLY : MTAGRAD
USE YOMMP0    , ONLY : NPROC, MYPROC

USE YOERRTO3 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
 & FRACREFBO  ,FORREFO    ,KAO_MN2O,KBO_MN2O, KAO_D, KBO_D
!USE YOERRTA3 , ONLY :    ETAREF    ,H2OREF     ,&
! & N2OREF     ,CO2REF     ,STRRAT  

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPHOOK) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_KGB3',0,ZHOOK_HANDLE)

IF( MYPROC==1 )THEN
  READ(NULRAD)  KAO_D, KBO_D
  KAO = REAL(KAO_D,JPRB)
  KBO = REAL(KBO_D,JPRB)
ENDIF
IF( NPROC>1 )THEN
  CALL MPL_BROADCAST (KAO,MTAGRAD,1,CDSTRING='RRTM_KGB3:')
  CALL MPL_BROADCAST (KBO,MTAGRAD,1,CDSTRING='RRTM_KGB3:')
ENDIF


! Planck fraction mapping level: P=212.7250 mbar, T = 223.06 K
      FRACREFAO(:, 1) = (/ &
     &   1.6251E-01_JPRB,1.5572E-01_JPRB,1.4557E-01_JPRB,1.3208E-01_JPRB,1.1582E-01_JPRB,9.6895E-02_JPRB, &
     &   7.8720E-02_JPRB,5.8462E-02_JPRB,3.9631E-02_JPRB,4.3001E-03_JPRB,3.5555E-03_JPRB,2.8101E-03_JPRB, &
     &   2.0547E-03_JPRB,1.3109E-03_JPRB,4.9403E-04_JPRB,6.9515E-05_JPRB/)
      FRACREFAO(:, 2) = (/ &
     &   1.6006E-01_JPRB,1.5576E-01_JPRB,1.4609E-01_JPRB,1.3276E-01_JPRB,1.1594E-01_JPRB,9.7336E-02_JPRB, &
     &   7.9035E-02_JPRB,5.8696E-02_JPRB,3.9723E-02_JPRB,4.3001E-03_JPRB,3.5555E-03_JPRB,2.8101E-03_JPRB, &
     &   2.0547E-03_JPRB,1.3109E-03_JPRB,4.9403E-04_JPRB,6.9515E-05_JPRB/)
      FRACREFAO(:, 3) = (/ &
     &   1.5952E-01_JPRB,1.5566E-01_JPRB,1.4590E-01_JPRB,1.3294E-01_JPRB,1.1599E-01_JPRB,9.7511E-02_JPRB, &
     &   7.9127E-02_JPRB,5.8888E-02_JPRB,3.9874E-02_JPRB,4.3001E-03_JPRB,3.5555E-03_JPRB,2.8102E-03_JPRB, &
     &   2.0547E-03_JPRB,1.3109E-03_JPRB,4.9403E-04_JPRB,6.9515E-05_JPRB/)
      FRACREFAO(:, 4) = (/ &
     &   1.5907E-01_JPRB,1.5541E-01_JPRB,1.4585E-01_JPRB,1.3316E-01_JPRB,1.1596E-01_JPRB,9.7647E-02_JPRB, &
     &   7.9243E-02_JPRB,5.9024E-02_JPRB,4.0028E-02_JPRB,4.3112E-03_JPRB,3.5555E-03_JPRB,2.8102E-03_JPRB, &
     &   2.0547E-03_JPRB,1.3109E-03_JPRB,4.9403E-04_JPRB,6.9515E-05_JPRB/)
      FRACREFAO(:, 5) = (/ &
     &   1.5862E-01_JPRB,1.5517E-01_JPRB,1.4588E-01_JPRB,1.3328E-01_JPRB,1.1585E-01_JPRB,9.7840E-02_JPRB, &
     &   7.9364E-02_JPRB,5.9174E-02_JPRB,4.0160E-02_JPRB,4.3403E-03_JPRB,3.5900E-03_JPRB,2.8102E-03_JPRB, &
     &   2.0547E-03_JPRB,1.3109E-03_JPRB,4.9403E-04_JPRB,6.9515E-05_JPRB/)
      FRACREFAO(:, 6) = (/ &
     &   1.5830E-01_JPRB,1.5490E-01_JPRB,1.4582E-01_JPRB,1.3331E-01_JPRB,1.1567E-01_JPRB,9.8079E-02_JPRB, &
     &   7.9510E-02_JPRB,5.9369E-02_JPRB,4.0326E-02_JPRB,4.3343E-03_JPRB,3.5908E-03_JPRB,2.8527E-03_JPRB, &
     &   2.0655E-03_JPRB,1.3109E-03_JPRB,4.9403E-04_JPRB,6.9515E-05_JPRB/)
      FRACREFAO(:, 7) = (/ &
     &   1.5789E-01_JPRB,1.5435E-01_JPRB,1.4595E-01_JPRB,1.3304E-01_JPRB,1.1566E-01_JPRB,9.8426E-02_JPRB, &
     &   7.9704E-02_JPRB,5.9618E-02_JPRB,4.0520E-02_JPRB,4.3812E-03_JPRB,3.6147E-03_JPRB,2.8395E-03_JPRB, &
     &   2.1301E-03_JPRB,1.3145E-03_JPRB,4.9403E-04_JPRB,6.9515E-05_JPRB/)
      FRACREFAO(:, 8) = (/ &
     &   1.5704E-01_JPRB,1.5398E-01_JPRB,1.4564E-01_JPRB,1.3222E-01_JPRB,1.1586E-01_JPRB,9.9230E-02_JPRB, &
     &   8.0011E-02_JPRB,6.0149E-02_JPRB,4.0790E-02_JPRB,4.4253E-03_JPRB,3.6534E-03_JPRB,2.9191E-03_JPRB, &
     &   2.1373E-03_JPRB,1.3558E-03_JPRB,5.1631E-04_JPRB,7.8794E-05_JPRB/)
      FRACREFAO(:, 9) = (/ &
     &   1.5270E-01_JPRB,1.5126E-01_JPRB,1.4264E-01_JPRB,1.3106E-01_JPRB,1.1740E-01_JPRB,1.0137E-01_JPRB, &
     &   8.3057E-02_JPRB,6.2282E-02_JPRB,4.2301E-02_JPRB,4.6486E-03_JPRB,3.8159E-03_JPRB,3.0472E-03_JPRB, &
     &   2.2870E-03_JPRB,1.4818E-03_JPRB,5.6773E-04_JPRB,7.8794E-05_JPRB/)

! Planck fraction mapping level: p = 95.8 mbar, t = 215.7 k
      FRACREFBO(:, 1) = (/ &
     &   1.6413E-01_JPRB,1.5665E-01_JPRB,1.4606E-01_JPRB,1.3184E-01_JPRB,1.1517E-01_JPRB,9.6243E-02_JPRB, &
     &   7.7982E-02_JPRB,5.8165E-02_JPRB,3.9311E-02_JPRB,4.2586E-03_JPRB,3.5189E-03_JPRB,2.7793E-03_JPRB, &
     &   2.0376E-03_JPRB,1.2938E-03_JPRB,4.8853E-04_JPRB,6.8745E-05_JPRB/)
      FRACREFBO(:, 2) = (/ &
     &   1.6254E-01_JPRB,1.5674E-01_JPRB,1.4652E-01_JPRB,1.3221E-01_JPRB,1.1535E-01_JPRB,9.6439E-02_JPRB, &
     &   7.8155E-02_JPRB,5.8254E-02_JPRB,3.9343E-02_JPRB,4.2586E-03_JPRB,3.5189E-03_JPRB,2.7793E-03_JPRB, &
     &   2.0376E-03_JPRB,1.2938E-03_JPRB,4.8853E-04_JPRB,6.8745E-05_JPRB/)
      FRACREFBO(:, 3) = (/ &
     &   1.6177E-01_JPRB,1.5664E-01_JPRB,1.4669E-01_JPRB,1.3242E-01_JPRB,1.1541E-01_JPRB,9.6536E-02_JPRB, &
     &   7.8257E-02_JPRB,5.8387E-02_JPRB,3.9431E-02_JPRB,4.2587E-03_JPRB,3.5189E-03_JPRB,2.7793E-03_JPRB, &
     &   2.0376E-03_JPRB,1.2938E-03_JPRB,4.8853E-04_JPRB,6.8745E-05_JPRB/)
      FRACREFBO(:, 4) = (/ &
     &   1.6077E-01_JPRB,1.5679E-01_JPRB,1.4648E-01_JPRB,1.3273E-01_JPRB,1.1546E-01_JPRB,9.6779E-02_JPRB, &
     &   7.8371E-02_JPRB,5.8546E-02_JPRB,3.9611E-02_JPRB,4.2772E-03_JPRB,3.5190E-03_JPRB,2.7793E-03_JPRB, &
     &   2.0376E-03_JPRB,1.2938E-03_JPRB,4.8853E-04_JPRB,6.8745E-05_JPRB/)
      FRACREFBO(:, 5) = (/ &
     &   1.6067E-01_JPRB,1.5608E-01_JPRB,1.4247E-01_JPRB,1.2881E-01_JPRB,1.1449E-01_JPRB,9.8802E-02_JPRB, &
     &   8.0828E-02_JPRB,6.0977E-02_JPRB,4.1494E-02_JPRB,4.5116E-03_JPRB,3.7290E-03_JPRB,2.9460E-03_JPRB, &
     &   2.1948E-03_JPRB,1.3778E-03_JPRB,5.4552E-04_JPRB,7.9969E-05_JPRB/)




!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 10 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.



!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of H2O to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different H2O to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = H2O/(H2O+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of H2O.  For instance, JS=1 refers to no H2O, 
!     JS = 2 corresponds to eta = 0.25, etc.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.


!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      KAO_MN2O( 1, :, 1) = (/ &
     & 1.28178E-05_JPRB, 1.55472E-05_JPRB, 1.88578E-05_JPRB, 2.28735E-05_JPRB, 2.77442E-05_JPRB, &
     & 3.36520E-05_JPRB, 4.08179E-05_JPRB, 4.95098E-05_JPRB, 6.00525E-05_JPRB, 7.28401E-05_JPRB, &
     & 8.83508E-05_JPRB, 1.07164E-04_JPRB, 1.29984E-04_JPRB, 1.57663E-04_JPRB, 1.91236E-04_JPRB, &
     & 2.31958E-04_JPRB, 2.81352E-04_JPRB, 3.41263E-04_JPRB, 4.13932E-04_JPRB/)
      KAO_MN2O( 2, :, 1) = (/ &
     & 1.00725E-01_JPRB, 1.04470E-01_JPRB, 1.08355E-01_JPRB, 1.12384E-01_JPRB, 1.16563E-01_JPRB, &
     & 1.20898E-01_JPRB, 1.25394E-01_JPRB, 1.30057E-01_JPRB, 1.34893E-01_JPRB, 1.39909E-01_JPRB, &
     & 1.45112E-01_JPRB, 1.50508E-01_JPRB, 1.56104E-01_JPRB, 1.61909E-01_JPRB, 1.67930E-01_JPRB, &
     & 1.74175E-01_JPRB, 1.80652E-01_JPRB, 1.87369E-01_JPRB, 1.94337E-01_JPRB/)
      KAO_MN2O( 3, :, 1) = (/ &
     & 1.94143E-01_JPRB, 1.97380E-01_JPRB, 2.00670E-01_JPRB, 2.04016E-01_JPRB, 2.07417E-01_JPRB, &
     & 2.10875E-01_JPRB, 2.14390E-01_JPRB, 2.17964E-01_JPRB, 2.21598E-01_JPRB, 2.25292E-01_JPRB, &
     & 2.29048E-01_JPRB, 2.32867E-01_JPRB, 2.36749E-01_JPRB, 2.40696E-01_JPRB, 2.44708E-01_JPRB, &
     & 2.48788E-01_JPRB, 2.52936E-01_JPRB, 2.57152E-01_JPRB, 2.61439E-01_JPRB/)
      KAO_MN2O( 4, :, 1) = (/ &
     & 2.98127E-01_JPRB, 3.00016E-01_JPRB, 3.01916E-01_JPRB, 3.03829E-01_JPRB, 3.05754E-01_JPRB, &
     & 3.07691E-01_JPRB, 3.09640E-01_JPRB, 3.11601E-01_JPRB, 3.13575E-01_JPRB, 3.15562E-01_JPRB, &
     & 3.17561E-01_JPRB, 3.19572E-01_JPRB, 3.21597E-01_JPRB, 3.23634E-01_JPRB, 3.25684E-01_JPRB, &
     & 3.27748E-01_JPRB, 3.29824E-01_JPRB, 3.31913E-01_JPRB, 3.34016E-01_JPRB/)
      KAO_MN2O( 5, :, 1) = (/ &
     & 4.45029E-01_JPRB, 4.45243E-01_JPRB, 4.45458E-01_JPRB, 4.45673E-01_JPRB, 4.45889E-01_JPRB, &
     & 4.46104E-01_JPRB, 4.46319E-01_JPRB, 4.46535E-01_JPRB, 4.46750E-01_JPRB, 4.46966E-01_JPRB, &
     & 4.47182E-01_JPRB, 4.47398E-01_JPRB, 4.47614E-01_JPRB, 4.47830E-01_JPRB, 4.48046E-01_JPRB, &
     & 4.48262E-01_JPRB, 4.48479E-01_JPRB, 4.48695E-01_JPRB, 4.48912E-01_JPRB/)
      KAO_MN2O( 6, :, 1) = (/ &
     & 7.15677E-01_JPRB, 7.14564E-01_JPRB, 7.13452E-01_JPRB, 7.12342E-01_JPRB, 7.11234E-01_JPRB, &
     & 7.10127E-01_JPRB, 7.09022E-01_JPRB, 7.07919E-01_JPRB, 7.06818E-01_JPRB, 7.05718E-01_JPRB, &
     & 7.04620E-01_JPRB, 7.03524E-01_JPRB, 7.02429E-01_JPRB, 7.01336E-01_JPRB, 7.00245E-01_JPRB, &
     & 6.99156E-01_JPRB, 6.98068E-01_JPRB, 6.96982E-01_JPRB, 6.95898E-01_JPRB/)
      KAO_MN2O( 7, :, 1) = (/ &
     & 9.89605E-01_JPRB, 9.85128E-01_JPRB, 9.80671E-01_JPRB, 9.76234E-01_JPRB, 9.71817E-01_JPRB, &
     & 9.67421E-01_JPRB, 9.63044E-01_JPRB, 9.58687E-01_JPRB, 9.54350E-01_JPRB, 9.50032E-01_JPRB, &
     & 9.45734E-01_JPRB, 9.41455E-01_JPRB, 9.37196E-01_JPRB, 9.32956E-01_JPRB, 9.28735E-01_JPRB, &
     & 9.24533E-01_JPRB, 9.20350E-01_JPRB, 9.16187E-01_JPRB, 9.12042E-01_JPRB/)
      KAO_MN2O( 8, :, 1) = (/ &
     & 1.12229E+00_JPRB, 1.11502E+00_JPRB, 1.10779E+00_JPRB, 1.10061E+00_JPRB, 1.09348E+00_JPRB, &
     & 1.08639E+00_JPRB, 1.07935E+00_JPRB, 1.07235E+00_JPRB, 1.06540E+00_JPRB, 1.05850E+00_JPRB, &
     & 1.05164E+00_JPRB, 1.04482E+00_JPRB, 1.03805E+00_JPRB, 1.03132E+00_JPRB, 1.02464E+00_JPRB, &
     & 1.01799E+00_JPRB, 1.01140E+00_JPRB, 1.00484E+00_JPRB, 9.98328E-01_JPRB/)
      KAO_MN2O( 9, :, 1) = (/ &
     & 7.20959E-01_JPRB, 7.22839E-01_JPRB, 7.24723E-01_JPRB, 7.26612E-01_JPRB, 7.28506E-01_JPRB, &
     & 7.30405E-01_JPRB, 7.32309E-01_JPRB, 7.34218E-01_JPRB, 7.36132E-01_JPRB, 7.38051E-01_JPRB, &
     & 7.39975E-01_JPRB, 7.41904E-01_JPRB, 7.43838E-01_JPRB, 7.45777E-01_JPRB, 7.47721E-01_JPRB, &
     & 7.49670E-01_JPRB, 7.51624E-01_JPRB, 7.53584E-01_JPRB, 7.55548E-01_JPRB/)
      KAO_MN2O( 1, :, 2) = (/ &
     & 1.62152E-03_JPRB, 1.81627E-03_JPRB, 2.03443E-03_JPRB, 2.27878E-03_JPRB, 2.55248E-03_JPRB, &
     & 2.85906E-03_JPRB, 3.20245E-03_JPRB, 3.58710E-03_JPRB, 4.01794E-03_JPRB, 4.50053E-03_JPRB, &
     & 5.04109E-03_JPRB, 5.64657E-03_JPRB, 6.32477E-03_JPRB, 7.08444E-03_JPRB, 7.93534E-03_JPRB, &
     & 8.88845E-03_JPRB, 9.95603E-03_JPRB, 1.11518E-02_JPRB, 1.24913E-02_JPRB/)
      KAO_MN2O( 2, :, 2) = (/ &
     & 3.73716E-01_JPRB, 3.72491E-01_JPRB, 3.71271E-01_JPRB, 3.70054E-01_JPRB, 3.68841E-01_JPRB, &
     & 3.67633E-01_JPRB, 3.66428E-01_JPRB, 3.65227E-01_JPRB, 3.64031E-01_JPRB, 3.62838E-01_JPRB, &
     & 3.61649E-01_JPRB, 3.60464E-01_JPRB, 3.59283E-01_JPRB, 3.58106E-01_JPRB, 3.56932E-01_JPRB, &
     & 3.55763E-01_JPRB, 3.54597E-01_JPRB, 3.53435E-01_JPRB, 3.52277E-01_JPRB/)
      KAO_MN2O( 3, :, 2) = (/ &
     & 5.46240E-01_JPRB, 5.42972E-01_JPRB, 5.39724E-01_JPRB, 5.36495E-01_JPRB, 5.33285E-01_JPRB, &
     & 5.30095E-01_JPRB, 5.26923E-01_JPRB, 5.23771E-01_JPRB, 5.20637E-01_JPRB, 5.17523E-01_JPRB, &
     & 5.14426E-01_JPRB, 5.11349E-01_JPRB, 5.08290E-01_JPRB, 5.05249E-01_JPRB, 5.02226E-01_JPRB, &
     & 4.99221E-01_JPRB, 4.96235E-01_JPRB, 4.93266E-01_JPRB, 4.90315E-01_JPRB/)
      KAO_MN2O( 4, :, 2) = (/ &
     & 8.35399E-01_JPRB, 8.36766E-01_JPRB, 8.38135E-01_JPRB, 8.39507E-01_JPRB, 8.40880E-01_JPRB, &
     & 8.42256E-01_JPRB, 8.43635E-01_JPRB, 8.45015E-01_JPRB, 8.46398E-01_JPRB, 8.47783E-01_JPRB, &
     & 8.49170E-01_JPRB, 8.50559E-01_JPRB, 8.51951E-01_JPRB, 8.53345E-01_JPRB, 8.54742E-01_JPRB, &
     & 8.56140E-01_JPRB, 8.57541E-01_JPRB, 8.58944E-01_JPRB, 8.60350E-01_JPRB/)
      KAO_MN2O( 5, :, 2) = (/ &
     & 1.04433E+00_JPRB, 1.04864E+00_JPRB, 1.05297E+00_JPRB, 1.05731E+00_JPRB, 1.06168E+00_JPRB, &
     & 1.06606E+00_JPRB, 1.07046E+00_JPRB, 1.07488E+00_JPRB, 1.07932E+00_JPRB, 1.08377E+00_JPRB, &
     & 1.08824E+00_JPRB, 1.09274E+00_JPRB, 1.09725E+00_JPRB, 1.10178E+00_JPRB, 1.10632E+00_JPRB, &
     & 1.11089E+00_JPRB, 1.11547E+00_JPRB, 1.12008E+00_JPRB, 1.12470E+00_JPRB/)
      KAO_MN2O( 6, :, 2) = (/ &
     & 1.22341E+00_JPRB, 1.22885E+00_JPRB, 1.23431E+00_JPRB, 1.23980E+00_JPRB, 1.24531E+00_JPRB, &
     & 1.25084E+00_JPRB, 1.25640E+00_JPRB, 1.26199E+00_JPRB, 1.26760E+00_JPRB, 1.27323E+00_JPRB, &
     & 1.27889E+00_JPRB, 1.28458E+00_JPRB, 1.29029E+00_JPRB, 1.29602E+00_JPRB, 1.30178E+00_JPRB, &
     & 1.30757E+00_JPRB, 1.31338E+00_JPRB, 1.31922E+00_JPRB, 1.32508E+00_JPRB/)
      KAO_MN2O( 7, :, 2) = (/ &
     & 1.67595E+00_JPRB, 1.68296E+00_JPRB, 1.69000E+00_JPRB, 1.69707E+00_JPRB, 1.70417E+00_JPRB, &
     & 1.71130E+00_JPRB, 1.71846E+00_JPRB, 1.72565E+00_JPRB, 1.73287E+00_JPRB, 1.74012E+00_JPRB, &
     & 1.74740E+00_JPRB, 1.75471E+00_JPRB, 1.76206E+00_JPRB, 1.76943E+00_JPRB, 1.77683E+00_JPRB, &
     & 1.78426E+00_JPRB, 1.79173E+00_JPRB, 1.79922E+00_JPRB, 1.80675E+00_JPRB/)
      KAO_MN2O( 8, :, 2) = (/ &
     & 2.76890E+00_JPRB, 2.76981E+00_JPRB, 2.77072E+00_JPRB, 2.77163E+00_JPRB, 2.77254E+00_JPRB, &
     & 2.77345E+00_JPRB, 2.77436E+00_JPRB, 2.77527E+00_JPRB, 2.77618E+00_JPRB, 2.77709E+00_JPRB, &
     & 2.77800E+00_JPRB, 2.77891E+00_JPRB, 2.77982E+00_JPRB, 2.78074E+00_JPRB, 2.78165E+00_JPRB, &
     & 2.78256E+00_JPRB, 2.78348E+00_JPRB, 2.78439E+00_JPRB, 2.78530E+00_JPRB/)
      KAO_MN2O( 9, :, 2) = (/ &
     & 8.00944E-01_JPRB, 7.95531E-01_JPRB, 7.90155E-01_JPRB, 7.84815E-01_JPRB, 7.79511E-01_JPRB, &
     & 7.74243E-01_JPRB, 7.69011E-01_JPRB, 7.63813E-01_JPRB, 7.58652E-01_JPRB, 7.53525E-01_JPRB, &
     & 7.48432E-01_JPRB, 7.43374E-01_JPRB, 7.38350E-01_JPRB, 7.33360E-01_JPRB, 7.28404E-01_JPRB, &
     & 7.23482E-01_JPRB, 7.18592E-01_JPRB, 7.13736E-01_JPRB, 7.08912E-01_JPRB/)
      KAO_MN2O( 1, :, 3) = (/ &
     & 5.26578E-02_JPRB, 5.59000E-02_JPRB, 5.93419E-02_JPRB, 6.29957E-02_JPRB, 6.68744E-02_JPRB, &
     & 7.09920E-02_JPRB, 7.53631E-02_JPRB, 8.00034E-02_JPRB, 8.49294E-02_JPRB, 9.01586E-02_JPRB, &
     & 9.57099E-02_JPRB, 1.01603E-01_JPRB, 1.07859E-01_JPRB, 1.14500E-01_JPRB, 1.21550E-01_JPRB, &
     & 1.29034E-01_JPRB, 1.36979E-01_JPRB, 1.45413E-01_JPRB, 1.54366E-01_JPRB/)
      KAO_MN2O( 2, :, 3) = (/ &
     & 8.18393E-01_JPRB, 8.20623E-01_JPRB, 8.22860E-01_JPRB, 8.25103E-01_JPRB, 8.27352E-01_JPRB, &
     & 8.29608E-01_JPRB, 8.31869E-01_JPRB, 8.34137E-01_JPRB, 8.36410E-01_JPRB, 8.38690E-01_JPRB, &
     & 8.40976E-01_JPRB, 8.43269E-01_JPRB, 8.45567E-01_JPRB, 8.47872E-01_JPRB, 8.50183E-01_JPRB, &
     & 8.52501E-01_JPRB, 8.54825E-01_JPRB, 8.57155E-01_JPRB, 8.59491E-01_JPRB/)
      KAO_MN2O( 3, :, 3) = (/ &
     & 1.02454E+00_JPRB, 1.03210E+00_JPRB, 1.03972E+00_JPRB, 1.04740E+00_JPRB, 1.05514E+00_JPRB, &
     & 1.06293E+00_JPRB, 1.07077E+00_JPRB, 1.07868E+00_JPRB, 1.08665E+00_JPRB, 1.09467E+00_JPRB, &
     & 1.10275E+00_JPRB, 1.11089E+00_JPRB, 1.11910E+00_JPRB, 1.12736E+00_JPRB, 1.13568E+00_JPRB, &
     & 1.14407E+00_JPRB, 1.15252E+00_JPRB, 1.16103E+00_JPRB, 1.16960E+00_JPRB/)
      KAO_MN2O( 4, :, 3) = (/ &
     & 1.11755E+00_JPRB, 1.12348E+00_JPRB, 1.12944E+00_JPRB, 1.13543E+00_JPRB, 1.14146E+00_JPRB, &
     & 1.14752E+00_JPRB, 1.15360E+00_JPRB, 1.15972E+00_JPRB, 1.16588E+00_JPRB, 1.17206E+00_JPRB, &
     & 1.17828E+00_JPRB, 1.18453E+00_JPRB, 1.19082E+00_JPRB, 1.19714E+00_JPRB, 1.20349E+00_JPRB, &
     & 1.20988E+00_JPRB, 1.21630E+00_JPRB, 1.22275E+00_JPRB, 1.22924E+00_JPRB/)
      KAO_MN2O( 5, :, 3) = (/ &
     & 1.41993E+00_JPRB, 1.42353E+00_JPRB, 1.42713E+00_JPRB, 1.43074E+00_JPRB, 1.43436E+00_JPRB, &
     & 1.43799E+00_JPRB, 1.44163E+00_JPRB, 1.44528E+00_JPRB, 1.44894E+00_JPRB, 1.45261E+00_JPRB, &
     & 1.45628E+00_JPRB, 1.45997E+00_JPRB, 1.46367E+00_JPRB, 1.46737E+00_JPRB, 1.47108E+00_JPRB, &
     & 1.47481E+00_JPRB, 1.47854E+00_JPRB, 1.48228E+00_JPRB, 1.48603E+00_JPRB/)
      KAO_MN2O( 6, :, 3) = (/ &
     & 1.37725E+00_JPRB, 1.38029E+00_JPRB, 1.38334E+00_JPRB, 1.38640E+00_JPRB, 1.38947E+00_JPRB, &
     & 1.39254E+00_JPRB, 1.39562E+00_JPRB, 1.39870E+00_JPRB, 1.40179E+00_JPRB, 1.40489E+00_JPRB, &
     & 1.40800E+00_JPRB, 1.41111E+00_JPRB, 1.41423E+00_JPRB, 1.41736E+00_JPRB, 1.42049E+00_JPRB, &
     & 1.42363E+00_JPRB, 1.42678E+00_JPRB, 1.42993E+00_JPRB, 1.43309E+00_JPRB/)
      KAO_MN2O( 7, :, 3) = (/ &
     & 1.34579E+00_JPRB, 1.34584E+00_JPRB, 1.34589E+00_JPRB, 1.34594E+00_JPRB, 1.34599E+00_JPRB, &
     & 1.34603E+00_JPRB, 1.34608E+00_JPRB, 1.34613E+00_JPRB, 1.34618E+00_JPRB, 1.34623E+00_JPRB, &
     & 1.34627E+00_JPRB, 1.34632E+00_JPRB, 1.34637E+00_JPRB, 1.34642E+00_JPRB, 1.34647E+00_JPRB, &
     & 1.34651E+00_JPRB, 1.34656E+00_JPRB, 1.34661E+00_JPRB, 1.34666E+00_JPRB/)
      KAO_MN2O( 8, :, 3) = (/ &
     & 9.15268E-01_JPRB, 9.12779E-01_JPRB, 9.10298E-01_JPRB, 9.07823E-01_JPRB, 9.05355E-01_JPRB, &
     & 9.02893E-01_JPRB, 9.00438E-01_JPRB, 8.97990E-01_JPRB, 8.95549E-01_JPRB, 8.93114E-01_JPRB, &
     & 8.90686E-01_JPRB, 8.88264E-01_JPRB, 8.85849E-01_JPRB, 8.83441E-01_JPRB, 8.81039E-01_JPRB, &
     & 8.78644E-01_JPRB, 8.76255E-01_JPRB, 8.73873E-01_JPRB, 8.71497E-01_JPRB/)
      KAO_MN2O( 9, :, 3) = (/ &
     & 1.12514E+00_JPRB, 1.13523E+00_JPRB, 1.14541E+00_JPRB, 1.15568E+00_JPRB, 1.16604E+00_JPRB, &
     & 1.17649E+00_JPRB, 1.18704E+00_JPRB, 1.19768E+00_JPRB, 1.20841E+00_JPRB, 1.21925E+00_JPRB, &
     & 1.23018E+00_JPRB, 1.24121E+00_JPRB, 1.25233E+00_JPRB, 1.26356E+00_JPRB, 1.27489E+00_JPRB, &
     & 1.28632E+00_JPRB, 1.29785E+00_JPRB, 1.30948E+00_JPRB, 1.32122E+00_JPRB/)
      KAO_MN2O( 1, :, 4) = (/ &
     & 4.65135E-01_JPRB, 4.69677E-01_JPRB, 4.74264E-01_JPRB, 4.78895E-01_JPRB, 4.83572E-01_JPRB, &
     & 4.88294E-01_JPRB, 4.93063E-01_JPRB, 4.97878E-01_JPRB, 5.02740E-01_JPRB, 5.07649E-01_JPRB, &
     & 5.12607E-01_JPRB, 5.17613E-01_JPRB, 5.22667E-01_JPRB, 5.27771E-01_JPRB, 5.32925E-01_JPRB, &
     & 5.38130E-01_JPRB, 5.43385E-01_JPRB, 5.48691E-01_JPRB, 5.54049E-01_JPRB/)
      KAO_MN2O( 2, :, 4) = (/ &
     & 9.71592E-01_JPRB, 9.74472E-01_JPRB, 9.77360E-01_JPRB, 9.80257E-01_JPRB, 9.83163E-01_JPRB, &
     & 9.86077E-01_JPRB, 9.89000E-01_JPRB, 9.91931E-01_JPRB, 9.94871E-01_JPRB, 9.97820E-01_JPRB, &
     & 1.00078E+00_JPRB, 1.00374E+00_JPRB, 1.00672E+00_JPRB, 1.00970E+00_JPRB, 1.01270E+00_JPRB, &
     & 1.01570E+00_JPRB, 1.01871E+00_JPRB, 1.02173E+00_JPRB, 1.02476E+00_JPRB/)
      KAO_MN2O( 3, :, 4) = (/ &
     & 1.48090E+00_JPRB, 1.48238E+00_JPRB, 1.48385E+00_JPRB, 1.48532E+00_JPRB, 1.48680E+00_JPRB, &
     & 1.48828E+00_JPRB, 1.48976E+00_JPRB, 1.49124E+00_JPRB, 1.49272E+00_JPRB, 1.49420E+00_JPRB, &
     & 1.49569E+00_JPRB, 1.49717E+00_JPRB, 1.49866E+00_JPRB, 1.50015E+00_JPRB, 1.50164E+00_JPRB, &
     & 1.50313E+00_JPRB, 1.50463E+00_JPRB, 1.50612E+00_JPRB, 1.50762E+00_JPRB/)
      KAO_MN2O( 4, :, 4) = (/ &
     & 1.50599E+00_JPRB, 1.50541E+00_JPRB, 1.50483E+00_JPRB, 1.50426E+00_JPRB, 1.50368E+00_JPRB, &
     & 1.50310E+00_JPRB, 1.50252E+00_JPRB, 1.50195E+00_JPRB, 1.50137E+00_JPRB, 1.50079E+00_JPRB, &
     & 1.50022E+00_JPRB, 1.49964E+00_JPRB, 1.49906E+00_JPRB, 1.49849E+00_JPRB, 1.49791E+00_JPRB, &
     & 1.49734E+00_JPRB, 1.49676E+00_JPRB, 1.49619E+00_JPRB, 1.49561E+00_JPRB/)
      KAO_MN2O( 5, :, 4) = (/ &
     & 1.25396E+00_JPRB, 1.25230E+00_JPRB, 1.25065E+00_JPRB, 1.24900E+00_JPRB, 1.24735E+00_JPRB, &
     & 1.24570E+00_JPRB, 1.24405E+00_JPRB, 1.24241E+00_JPRB, 1.24077E+00_JPRB, 1.23913E+00_JPRB, &
     & 1.23749E+00_JPRB, 1.23586E+00_JPRB, 1.23423E+00_JPRB, 1.23260E+00_JPRB, 1.23097E+00_JPRB, &
     & 1.22934E+00_JPRB, 1.22772E+00_JPRB, 1.22610E+00_JPRB, 1.22448E+00_JPRB/)
      KAO_MN2O( 6, :, 4) = (/ &
     & 1.27104E+00_JPRB, 1.26416E+00_JPRB, 1.25731E+00_JPRB, 1.25050E+00_JPRB, 1.24373E+00_JPRB, &
     & 1.23700E+00_JPRB, 1.23030E+00_JPRB, 1.22364E+00_JPRB, 1.21701E+00_JPRB, 1.21043E+00_JPRB, &
     & 1.20387E+00_JPRB, 1.19735E+00_JPRB, 1.19087E+00_JPRB, 1.18442E+00_JPRB, 1.17801E+00_JPRB, &
     & 1.17163E+00_JPRB, 1.16529E+00_JPRB, 1.15898E+00_JPRB, 1.15270E+00_JPRB/)
      KAO_MN2O( 7, :, 4) = (/ &
     & 9.57877E-01_JPRB, 9.49712E-01_JPRB, 9.41617E-01_JPRB, 9.33591E-01_JPRB, 9.25633E-01_JPRB, &
     & 9.17743E-01_JPRB, 9.09920E-01_JPRB, 9.02164E-01_JPRB, 8.94473E-01_JPRB, 8.86849E-01_JPRB, &
     & 8.79289E-01_JPRB, 8.71794E-01_JPRB, 8.64363E-01_JPRB, 8.56995E-01_JPRB, 8.49690E-01_JPRB, &
     & 8.42447E-01_JPRB, 8.35266E-01_JPRB, 8.28147E-01_JPRB, 8.21087E-01_JPRB/)
      KAO_MN2O( 8, :, 4) = (/ &
     & 4.75787E-01_JPRB, 4.77208E-01_JPRB, 4.78633E-01_JPRB, 4.80063E-01_JPRB, 4.81496E-01_JPRB, &
     & 4.82934E-01_JPRB, 4.84377E-01_JPRB, 4.85823E-01_JPRB, 4.87274E-01_JPRB, 4.88730E-01_JPRB, &
     & 4.90189E-01_JPRB, 4.91653E-01_JPRB, 4.93122E-01_JPRB, 4.94595E-01_JPRB, 4.96072E-01_JPRB, &
     & 4.97553E-01_JPRB, 4.99039E-01_JPRB, 5.00530E-01_JPRB, 5.02025E-01_JPRB/)
      KAO_MN2O( 9, :, 4) = (/ &
     & 2.42533E+00_JPRB, 2.41357E+00_JPRB, 2.40188E+00_JPRB, 2.39024E+00_JPRB, 2.37866E+00_JPRB, &
     & 2.36713E+00_JPRB, 2.35566E+00_JPRB, 2.34425E+00_JPRB, 2.33289E+00_JPRB, 2.32158E+00_JPRB, &
     & 2.31033E+00_JPRB, 2.29914E+00_JPRB, 2.28800E+00_JPRB, 2.27691E+00_JPRB, 2.26588E+00_JPRB, &
     & 2.25490E+00_JPRB, 2.24397E+00_JPRB, 2.23310E+00_JPRB, 2.22228E+00_JPRB/)
      KAO_MN2O( 1, :, 5) = (/ &
     & 1.53885E+00_JPRB, 1.53590E+00_JPRB, 1.53297E+00_JPRB, 1.53004E+00_JPRB, 1.52711E+00_JPRB, &
     & 1.52419E+00_JPRB, 1.52128E+00_JPRB, 1.51837E+00_JPRB, 1.51547E+00_JPRB, 1.51257E+00_JPRB, &
     & 1.50968E+00_JPRB, 1.50679E+00_JPRB, 1.50391E+00_JPRB, 1.50104E+00_JPRB, 1.49817E+00_JPRB, &
     & 1.49530E+00_JPRB, 1.49245E+00_JPRB, 1.48959E+00_JPRB, 1.48675E+00_JPRB/)
      KAO_MN2O( 2, :, 5) = (/ &
     & 1.83368E+00_JPRB, 1.83530E+00_JPRB, 1.83692E+00_JPRB, 1.83854E+00_JPRB, 1.84016E+00_JPRB, &
     & 1.84178E+00_JPRB, 1.84340E+00_JPRB, 1.84503E+00_JPRB, 1.84665E+00_JPRB, 1.84828E+00_JPRB, &
     & 1.84991E+00_JPRB, 1.85154E+00_JPRB, 1.85317E+00_JPRB, 1.85480E+00_JPRB, 1.85644E+00_JPRB, &
     & 1.85807E+00_JPRB, 1.85971E+00_JPRB, 1.86135E+00_JPRB, 1.86299E+00_JPRB/)
      KAO_MN2O( 3, :, 5) = (/ &
     & 1.49593E+00_JPRB, 1.49279E+00_JPRB, 1.48965E+00_JPRB, 1.48652E+00_JPRB, 1.48340E+00_JPRB, &
     & 1.48028E+00_JPRB, 1.47717E+00_JPRB, 1.47406E+00_JPRB, 1.47096E+00_JPRB, 1.46787E+00_JPRB, &
     & 1.46479E+00_JPRB, 1.46171E+00_JPRB, 1.45863E+00_JPRB, 1.45557E+00_JPRB, 1.45251E+00_JPRB, &
     & 1.44946E+00_JPRB, 1.44641E+00_JPRB, 1.44337E+00_JPRB, 1.44033E+00_JPRB/)
      KAO_MN2O( 4, :, 5) = (/ &
     & 1.40048E+00_JPRB, 1.39228E+00_JPRB, 1.38413E+00_JPRB, 1.37603E+00_JPRB, 1.36798E+00_JPRB, &
     & 1.35997E+00_JPRB, 1.35201E+00_JPRB, 1.34410E+00_JPRB, 1.33623E+00_JPRB, 1.32841E+00_JPRB, &
     & 1.32064E+00_JPRB, 1.31291E+00_JPRB, 1.30522E+00_JPRB, 1.29758E+00_JPRB, 1.28999E+00_JPRB, &
     & 1.28244E+00_JPRB, 1.27493E+00_JPRB, 1.26747E+00_JPRB, 1.26005E+00_JPRB/)
      KAO_MN2O( 5, :, 5) = (/ &
     & 1.22253E+00_JPRB, 1.21202E+00_JPRB, 1.20160E+00_JPRB, 1.19126E+00_JPRB, 1.18102E+00_JPRB, &
     & 1.17087E+00_JPRB, 1.16080E+00_JPRB, 1.15082E+00_JPRB, 1.14092E+00_JPRB, 1.13111E+00_JPRB, &
     & 1.12139E+00_JPRB, 1.11174E+00_JPRB, 1.10219E+00_JPRB, 1.09271E+00_JPRB, 1.08331E+00_JPRB, &
     & 1.07400E+00_JPRB, 1.06476E+00_JPRB, 1.05561E+00_JPRB, 1.04653E+00_JPRB/)
      KAO_MN2O( 6, :, 5) = (/ &
     & 1.07930E+00_JPRB, 1.06998E+00_JPRB, 1.06075E+00_JPRB, 1.05159E+00_JPRB, 1.04251E+00_JPRB, &
     & 1.03352E+00_JPRB, 1.02459E+00_JPRB, 1.01575E+00_JPRB, 1.00698E+00_JPRB, 9.98291E-01_JPRB, &
     & 9.89674E-01_JPRB, 9.81131E-01_JPRB, 9.72663E-01_JPRB, 9.64267E-01_JPRB, 9.55944E-01_JPRB, &
     & 9.47692E-01_JPRB, 9.39512E-01_JPRB, 9.31402E-01_JPRB, 9.23363E-01_JPRB/)
      KAO_MN2O( 7, :, 5) = (/ &
     & 7.87066E-01_JPRB, 7.82767E-01_JPRB, 7.78490E-01_JPRB, 7.74237E-01_JPRB, 7.70008E-01_JPRB, &
     & 7.65801E-01_JPRB, 7.61617E-01_JPRB, 7.57457E-01_JPRB, 7.53319E-01_JPRB, 7.49203E-01_JPRB, &
     & 7.45110E-01_JPRB, 7.41040E-01_JPRB, 7.36991E-01_JPRB, 7.32965E-01_JPRB, 7.28961E-01_JPRB, &
     & 7.24979E-01_JPRB, 7.21018E-01_JPRB, 7.17079E-01_JPRB, 7.13161E-01_JPRB/)
      KAO_MN2O( 8, :, 5) = (/ &
     & 3.83362E-01_JPRB, 3.84405E-01_JPRB, 3.85452E-01_JPRB, 3.86501E-01_JPRB, 3.87552E-01_JPRB, &
     & 3.88607E-01_JPRB, 3.89665E-01_JPRB, 3.90725E-01_JPRB, 3.91788E-01_JPRB, 3.92855E-01_JPRB, &
     & 3.93924E-01_JPRB, 3.94996E-01_JPRB, 3.96071E-01_JPRB, 3.97149E-01_JPRB, 3.98229E-01_JPRB, &
     & 3.99313E-01_JPRB, 4.00400E-01_JPRB, 4.01489E-01_JPRB, 4.02582E-01_JPRB/)
      KAO_MN2O( 9, :, 5) = (/ &
     & 8.97278E-01_JPRB, 8.92873E-01_JPRB, 8.88490E-01_JPRB, 8.84128E-01_JPRB, 8.79787E-01_JPRB, &
     & 8.75468E-01_JPRB, 8.71170E-01_JPRB, 8.66893E-01_JPRB, 8.62637E-01_JPRB, 8.58402E-01_JPRB, &
     & 8.54187E-01_JPRB, 8.49994E-01_JPRB, 8.45821E-01_JPRB, 8.41668E-01_JPRB, 8.37536E-01_JPRB, &
     & 8.33424E-01_JPRB, 8.29333E-01_JPRB, 8.25261E-01_JPRB, 8.21209E-01_JPRB/)
      KAO_MN2O( 1, :, 6) = (/ &
     & 1.83809E+00_JPRB, 1.84036E+00_JPRB, 1.84264E+00_JPRB, 1.84491E+00_JPRB, 1.84720E+00_JPRB, &
     & 1.84948E+00_JPRB, 1.85177E+00_JPRB, 1.85406E+00_JPRB, 1.85635E+00_JPRB, 1.85864E+00_JPRB, &
     & 1.86094E+00_JPRB, 1.86324E+00_JPRB, 1.86555E+00_JPRB, 1.86785E+00_JPRB, 1.87016E+00_JPRB, &
     & 1.87247E+00_JPRB, 1.87479E+00_JPRB, 1.87711E+00_JPRB, 1.87943E+00_JPRB/)
      KAO_MN2O( 2, :, 6) = (/ &
     & 1.82624E+00_JPRB, 1.81564E+00_JPRB, 1.80510E+00_JPRB, 1.79463E+00_JPRB, 1.78421E+00_JPRB, &
     & 1.77386E+00_JPRB, 1.76356E+00_JPRB, 1.75333E+00_JPRB, 1.74315E+00_JPRB, 1.73304E+00_JPRB, &
     & 1.72298E+00_JPRB, 1.71298E+00_JPRB, 1.70304E+00_JPRB, 1.69316E+00_JPRB, 1.68333E+00_JPRB, &
     & 1.67356E+00_JPRB, 1.66385E+00_JPRB, 1.65419E+00_JPRB, 1.64459E+00_JPRB/)
      KAO_MN2O( 3, :, 6) = (/ &
     & 1.35442E+00_JPRB, 1.34174E+00_JPRB, 1.32918E+00_JPRB, 1.31673E+00_JPRB, 1.30440E+00_JPRB, &
     & 1.29219E+00_JPRB, 1.28010E+00_JPRB, 1.26811E+00_JPRB, 1.25624E+00_JPRB, 1.24448E+00_JPRB, &
     & 1.23283E+00_JPRB, 1.22129E+00_JPRB, 1.20985E+00_JPRB, 1.19853E+00_JPRB, 1.18731E+00_JPRB, &
     & 1.17619E+00_JPRB, 1.16518E+00_JPRB, 1.15427E+00_JPRB, 1.14347E+00_JPRB/)
      KAO_MN2O( 4, :, 6) = (/ &
     & 1.10510E+00_JPRB, 1.09473E+00_JPRB, 1.08446E+00_JPRB, 1.07429E+00_JPRB, 1.06420E+00_JPRB, &
     & 1.05422E+00_JPRB, 1.04433E+00_JPRB, 1.03453E+00_JPRB, 1.02482E+00_JPRB, 1.01520E+00_JPRB, &
     & 1.00568E+00_JPRB, 9.96238E-01_JPRB, 9.86890E-01_JPRB, 9.77629E-01_JPRB, 9.68455E-01_JPRB, &
     & 9.59367E-01_JPRB, 9.50365E-01_JPRB, 9.41447E-01_JPRB, 9.32612E-01_JPRB/)
      KAO_MN2O( 5, :, 6) = (/ &
     & 1.01083E+00_JPRB, 1.00221E+00_JPRB, 9.93656E-01_JPRB, 9.85178E-01_JPRB, 9.76772E-01_JPRB, &
     & 9.68437E-01_JPRB, 9.60174E-01_JPRB, 9.51981E-01_JPRB, 9.43859E-01_JPRB, 9.35805E-01_JPRB, &
     & 9.27821E-01_JPRB, 9.19904E-01_JPRB, 9.12055E-01_JPRB, 9.04273E-01_JPRB, 8.96557E-01_JPRB, &
     & 8.88907E-01_JPRB, 8.81323E-01_JPRB, 8.73803E-01_JPRB, 8.66347E-01_JPRB/)
      KAO_MN2O( 6, :, 6) = (/ &
     & 5.91415E-01_JPRB, 5.90427E-01_JPRB, 5.89441E-01_JPRB, 5.88457E-01_JPRB, 5.87474E-01_JPRB, &
     & 5.86493E-01_JPRB, 5.85514E-01_JPRB, 5.84536E-01_JPRB, 5.83559E-01_JPRB, 5.82585E-01_JPRB, &
     & 5.81612E-01_JPRB, 5.80640E-01_JPRB, 5.79671E-01_JPRB, 5.78703E-01_JPRB, 5.77736E-01_JPRB, &
     & 5.76771E-01_JPRB, 5.75808E-01_JPRB, 5.74846E-01_JPRB, 5.73886E-01_JPRB/)
      KAO_MN2O( 7, :, 6) = (/ &
     & 3.68189E-01_JPRB, 3.70029E-01_JPRB, 3.71877E-01_JPRB, 3.73735E-01_JPRB, 3.75603E-01_JPRB, &
     & 3.77479E-01_JPRB, 3.79365E-01_JPRB, 3.81260E-01_JPRB, 3.83165E-01_JPRB, 3.85079E-01_JPRB, &
     & 3.87003E-01_JPRB, 3.88937E-01_JPRB, 3.90880E-01_JPRB, 3.92833E-01_JPRB, 3.94795E-01_JPRB, &
     & 3.96768E-01_JPRB, 3.98750E-01_JPRB, 4.00742E-01_JPRB, 4.02744E-01_JPRB/)
      KAO_MN2O( 8, :, 6) = (/ &
     & 2.98721E-01_JPRB, 2.99932E-01_JPRB, 3.01149E-01_JPRB, 3.02370E-01_JPRB, 3.03597E-01_JPRB, &
     & 3.04828E-01_JPRB, 3.06064E-01_JPRB, 3.07306E-01_JPRB, 3.08552E-01_JPRB, 3.09804E-01_JPRB, &
     & 3.11060E-01_JPRB, 3.12322E-01_JPRB, 3.13589E-01_JPRB, 3.14860E-01_JPRB, 3.16138E-01_JPRB, &
     & 3.17420E-01_JPRB, 3.18707E-01_JPRB, 3.20000E-01_JPRB, 3.21298E-01_JPRB/)
      KAO_MN2O( 9, :, 6) = (/ &
     & 3.76116E-01_JPRB, 3.77276E-01_JPRB, 3.78439E-01_JPRB, 3.79606E-01_JPRB, 3.80777E-01_JPRB, &
     & 3.81951E-01_JPRB, 3.83129E-01_JPRB, 3.84310E-01_JPRB, 3.85495E-01_JPRB, 3.86684E-01_JPRB, &
     & 3.87876E-01_JPRB, 3.89072E-01_JPRB, 3.90272E-01_JPRB, 3.91475E-01_JPRB, 3.92682E-01_JPRB, &
     & 3.93893E-01_JPRB, 3.95107E-01_JPRB, 3.96326E-01_JPRB, 3.97548E-01_JPRB/)
      KAO_MN2O( 1, :, 7) = (/ &
     & 3.22705E+00_JPRB, 3.21966E+00_JPRB, 3.21230E+00_JPRB, 3.20494E+00_JPRB, 3.19761E+00_JPRB, &
     & 3.19029E+00_JPRB, 3.18299E+00_JPRB, 3.17571E+00_JPRB, 3.16844E+00_JPRB, 3.16119E+00_JPRB, &
     & 3.15395E+00_JPRB, 3.14673E+00_JPRB, 3.13953E+00_JPRB, 3.13235E+00_JPRB, 3.12518E+00_JPRB, &
     & 3.11803E+00_JPRB, 3.11089E+00_JPRB, 3.10377E+00_JPRB, 3.09667E+00_JPRB/)
      KAO_MN2O( 2, :, 7) = (/ &
     & 1.43811E+00_JPRB, 1.42367E+00_JPRB, 1.40938E+00_JPRB, 1.39522E+00_JPRB, 1.38121E+00_JPRB, &
     & 1.36735E+00_JPRB, 1.35362E+00_JPRB, 1.34002E+00_JPRB, 1.32657E+00_JPRB, 1.31325E+00_JPRB, &
     & 1.30006E+00_JPRB, 1.28701E+00_JPRB, 1.27408E+00_JPRB, 1.26129E+00_JPRB, 1.24862E+00_JPRB, &
     & 1.23609E+00_JPRB, 1.22367E+00_JPRB, 1.21139E+00_JPRB, 1.19922E+00_JPRB/)
      KAO_MN2O( 3, :, 7) = (/ &
     & 1.22586E+00_JPRB, 1.21639E+00_JPRB, 1.20700E+00_JPRB, 1.19767E+00_JPRB, 1.18842E+00_JPRB, &
     & 1.17924E+00_JPRB, 1.17014E+00_JPRB, 1.16110E+00_JPRB, 1.15213E+00_JPRB, 1.14323E+00_JPRB, &
     & 1.13440E+00_JPRB, 1.12564E+00_JPRB, 1.11695E+00_JPRB, 1.10832E+00_JPRB, 1.09976E+00_JPRB, &
     & 1.09127E+00_JPRB, 1.08284E+00_JPRB, 1.07447E+00_JPRB, 1.06618E+00_JPRB/)
      KAO_MN2O( 4, :, 7) = (/ &
     & 7.94380E-01_JPRB, 7.92795E-01_JPRB, 7.91213E-01_JPRB, 7.89634E-01_JPRB, 7.88059E-01_JPRB, &
     & 7.86486E-01_JPRB, 7.84917E-01_JPRB, 7.83351E-01_JPRB, 7.81787E-01_JPRB, 7.80227E-01_JPRB, &
     & 7.78671E-01_JPRB, 7.77117E-01_JPRB, 7.75566E-01_JPRB, 7.74019E-01_JPRB, 7.72474E-01_JPRB, &
     & 7.70933E-01_JPRB, 7.69394E-01_JPRB, 7.67859E-01_JPRB, 7.66327E-01_JPRB/)
      KAO_MN2O( 5, :, 7) = (/ &
     & 4.46935E-01_JPRB, 4.49760E-01_JPRB, 4.52602E-01_JPRB, 4.55462E-01_JPRB, 4.58340E-01_JPRB, &
     & 4.61237E-01_JPRB, 4.64152E-01_JPRB, 4.67085E-01_JPRB, 4.70037E-01_JPRB, 4.73007E-01_JPRB, &
     & 4.75996E-01_JPRB, 4.79004E-01_JPRB, 4.82031E-01_JPRB, 4.85078E-01_JPRB, 4.88143E-01_JPRB, &
     & 4.91228E-01_JPRB, 4.94332E-01_JPRB, 4.97456E-01_JPRB, 5.00600E-01_JPRB/)
      KAO_MN2O( 6, :, 7) = (/ &
     & 4.20211E-01_JPRB, 4.21711E-01_JPRB, 4.23216E-01_JPRB, 4.24726E-01_JPRB, 4.26242E-01_JPRB, &
     & 4.27763E-01_JPRB, 4.29290E-01_JPRB, 4.30822E-01_JPRB, 4.32359E-01_JPRB, 4.33902E-01_JPRB, &
     & 4.35450E-01_JPRB, 4.37004E-01_JPRB, 4.38564E-01_JPRB, 4.40129E-01_JPRB, 4.41700E-01_JPRB, &
     & 4.43276E-01_JPRB, 4.44858E-01_JPRB, 4.46445E-01_JPRB, 4.48038E-01_JPRB/)
      KAO_MN2O( 7, :, 7) = (/ &
     & 3.42094E-01_JPRB, 3.43589E-01_JPRB, 3.45091E-01_JPRB, 3.46600E-01_JPRB, 3.48115E-01_JPRB, &
     & 3.49637E-01_JPRB, 3.51165E-01_JPRB, 3.52700E-01_JPRB, 3.54242E-01_JPRB, 3.55791E-01_JPRB, &
     & 3.57346E-01_JPRB, 3.58908E-01_JPRB, 3.60477E-01_JPRB, 3.62053E-01_JPRB, 3.63636E-01_JPRB, &
     & 3.65225E-01_JPRB, 3.66822E-01_JPRB, 3.68426E-01_JPRB, 3.70036E-01_JPRB/)
      KAO_MN2O( 8, :, 7) = (/ &
     & 2.94919E-01_JPRB, 2.97460E-01_JPRB, 3.00022E-01_JPRB, 3.02606E-01_JPRB, 3.05212E-01_JPRB, &
     & 3.07841E-01_JPRB, 3.10492E-01_JPRB, 3.13167E-01_JPRB, 3.15864E-01_JPRB, 3.18584E-01_JPRB, &
     & 3.21328E-01_JPRB, 3.24096E-01_JPRB, 3.26887E-01_JPRB, 3.29703E-01_JPRB, 3.32543E-01_JPRB, &
     & 3.35407E-01_JPRB, 3.38296E-01_JPRB, 3.41210E-01_JPRB, 3.44148E-01_JPRB/)
      KAO_MN2O( 9, :, 7) = (/ &
     & 2.97441E-01_JPRB, 2.99207E-01_JPRB, 3.00984E-01_JPRB, 3.02772E-01_JPRB, 3.04570E-01_JPRB, &
     & 3.06379E-01_JPRB, 3.08199E-01_JPRB, 3.10029E-01_JPRB, 3.11870E-01_JPRB, 3.13723E-01_JPRB, &
     & 3.15586E-01_JPRB, 3.17460E-01_JPRB, 3.19345E-01_JPRB, 3.21242E-01_JPRB, 3.23150E-01_JPRB, &
     & 3.25069E-01_JPRB, 3.27000E-01_JPRB, 3.28942E-01_JPRB, 3.30895E-01_JPRB/)
      KAO_MN2O( 1, :, 8) = (/ &
     & 2.14641E+00_JPRB, 2.12585E+00_JPRB, 2.10549E+00_JPRB, 2.08532E+00_JPRB, 2.06534E+00_JPRB, &
     & 2.04556E+00_JPRB, 2.02596E+00_JPRB, 2.00656E+00_JPRB, 1.98733E+00_JPRB, 1.96830E+00_JPRB, &
     & 1.94944E+00_JPRB, 1.93077E+00_JPRB, 1.91227E+00_JPRB, 1.89395E+00_JPRB, 1.87581E+00_JPRB, &
     & 1.85784E+00_JPRB, 1.84004E+00_JPRB, 1.82242E+00_JPRB, 1.80496E+00_JPRB/)
      KAO_MN2O( 2, :, 8) = (/ &
     & 8.83687E-01_JPRB, 8.83170E-01_JPRB, 8.82654E-01_JPRB, 8.82137E-01_JPRB, 8.81621E-01_JPRB, &
     & 8.81106E-01_JPRB, 8.80590E-01_JPRB, 8.80075E-01_JPRB, 8.79560E-01_JPRB, 8.79046E-01_JPRB, &
     & 8.78531E-01_JPRB, 8.78017E-01_JPRB, 8.77504E-01_JPRB, 8.76990E-01_JPRB, 8.76477E-01_JPRB, &
     & 8.75965E-01_JPRB, 8.75452E-01_JPRB, 8.74940E-01_JPRB, 8.74428E-01_JPRB/)
      KAO_MN2O( 3, :, 8) = (/ &
     & 4.49840E-01_JPRB, 4.52683E-01_JPRB, 4.55543E-01_JPRB, 4.58421E-01_JPRB, 4.61318E-01_JPRB, &
     & 4.64233E-01_JPRB, 4.67166E-01_JPRB, 4.70118E-01_JPRB, 4.73088E-01_JPRB, 4.76078E-01_JPRB, &
     & 4.79086E-01_JPRB, 4.82113E-01_JPRB, 4.85159E-01_JPRB, 4.88225E-01_JPRB, 4.91310E-01_JPRB, &
     & 4.94414E-01_JPRB, 4.97538E-01_JPRB, 5.00682E-01_JPRB, 5.03845E-01_JPRB/)
      KAO_MN2O( 4, :, 8) = (/ &
     & 3.92292E-01_JPRB, 3.93574E-01_JPRB, 3.94861E-01_JPRB, 3.96151E-01_JPRB, 3.97446E-01_JPRB, &
     & 3.98746E-01_JPRB, 4.00049E-01_JPRB, 4.01357E-01_JPRB, 4.02669E-01_JPRB, 4.03985E-01_JPRB, &
     & 4.05306E-01_JPRB, 4.06630E-01_JPRB, 4.07960E-01_JPRB, 4.09293E-01_JPRB, 4.10631E-01_JPRB, &
     & 4.11973E-01_JPRB, 4.13320E-01_JPRB, 4.14671E-01_JPRB, 4.16027E-01_JPRB/)
      KAO_MN2O( 5, :, 8) = (/ &
     & 3.38920E-01_JPRB, 3.41151E-01_JPRB, 3.43397E-01_JPRB, 3.45658E-01_JPRB, 3.47934E-01_JPRB, &
     & 3.50225E-01_JPRB, 3.52531E-01_JPRB, 3.54852E-01_JPRB, 3.57189E-01_JPRB, 3.59541E-01_JPRB, &
     & 3.61908E-01_JPRB, 3.64291E-01_JPRB, 3.66689E-01_JPRB, 3.69104E-01_JPRB, 3.71534E-01_JPRB, &
     & 3.73980E-01_JPRB, 3.76443E-01_JPRB, 3.78921E-01_JPRB, 3.81416E-01_JPRB/)
      KAO_MN2O( 6, :, 8) = (/ &
     & 3.01673E-01_JPRB, 3.04752E-01_JPRB, 3.07863E-01_JPRB, 3.11005E-01_JPRB, 3.14180E-01_JPRB, &
     & 3.17387E-01_JPRB, 3.20626E-01_JPRB, 3.23899E-01_JPRB, 3.27205E-01_JPRB, 3.30545E-01_JPRB, &
     & 3.33919E-01_JPRB, 3.37328E-01_JPRB, 3.40771E-01_JPRB, 3.44249E-01_JPRB, 3.47763E-01_JPRB, &
     & 3.51313E-01_JPRB, 3.54899E-01_JPRB, 3.58521E-01_JPRB, 3.62181E-01_JPRB/)
      KAO_MN2O( 7, :, 8) = (/ &
     & 2.99381E-01_JPRB, 3.02431E-01_JPRB, 3.05512E-01_JPRB, 3.08624E-01_JPRB, 3.11768E-01_JPRB, &
     & 3.14945E-01_JPRB, 3.18153E-01_JPRB, 3.21394E-01_JPRB, 3.24668E-01_JPRB, 3.27976E-01_JPRB, &
     & 3.31317E-01_JPRB, 3.34693E-01_JPRB, 3.38102E-01_JPRB, 3.41547E-01_JPRB, 3.45026E-01_JPRB, &
     & 3.48541E-01_JPRB, 3.52092E-01_JPRB, 3.55679E-01_JPRB, 3.59302E-01_JPRB/)
      KAO_MN2O( 8, :, 8) = (/ &
     & 2.87559E-01_JPRB, 2.89153E-01_JPRB, 2.90756E-01_JPRB, 2.92367E-01_JPRB, 2.93987E-01_JPRB, &
     & 2.95617E-01_JPRB, 2.97255E-01_JPRB, 2.98902E-01_JPRB, 3.00559E-01_JPRB, 3.02225E-01_JPRB, &
     & 3.03899E-01_JPRB, 3.05584E-01_JPRB, 3.07277E-01_JPRB, 3.08980E-01_JPRB, 3.10693E-01_JPRB, &
     & 3.12414E-01_JPRB, 3.14146E-01_JPRB, 3.15887E-01_JPRB, 3.17638E-01_JPRB/)
      KAO_MN2O( 9, :, 8) = (/ &
     & 2.96238E-01_JPRB, 2.97588E-01_JPRB, 2.98945E-01_JPRB, 3.00309E-01_JPRB, 3.01678E-01_JPRB, &
     & 3.03054E-01_JPRB, 3.04436E-01_JPRB, 3.05824E-01_JPRB, 3.07219E-01_JPRB, 3.08620E-01_JPRB, &
     & 3.10027E-01_JPRB, 3.11441E-01_JPRB, 3.12861E-01_JPRB, 3.14288E-01_JPRB, 3.15721E-01_JPRB, &
     & 3.17161E-01_JPRB, 3.18607E-01_JPRB, 3.20060E-01_JPRB, 3.21520E-01_JPRB/)
      KAO_MN2O( 1, :, 9) = (/ &
     & 1.56483E+00_JPRB, 1.55792E+00_JPRB, 1.55105E+00_JPRB, 1.54420E+00_JPRB, 1.53739E+00_JPRB, &
     & 1.53060E+00_JPRB, 1.52384E+00_JPRB, 1.51712E+00_JPRB, 1.51042E+00_JPRB, 1.50376E+00_JPRB, &
     & 1.49712E+00_JPRB, 1.49051E+00_JPRB, 1.48393E+00_JPRB, 1.47738E+00_JPRB, 1.47086E+00_JPRB, &
     & 1.46437E+00_JPRB, 1.45791E+00_JPRB, 1.45147E+00_JPRB, 1.44507E+00_JPRB/)
      KAO_MN2O( 2, :, 9) = (/ &
     & 4.09526E-01_JPRB, 4.10301E-01_JPRB, 4.11078E-01_JPRB, 4.11857E-01_JPRB, 4.12637E-01_JPRB, &
     & 4.13418E-01_JPRB, 4.14201E-01_JPRB, 4.14986E-01_JPRB, 4.15771E-01_JPRB, 4.16559E-01_JPRB, &
     & 4.17348E-01_JPRB, 4.18138E-01_JPRB, 4.18930E-01_JPRB, 4.19723E-01_JPRB, 4.20518E-01_JPRB, &
     & 4.21315E-01_JPRB, 4.22112E-01_JPRB, 4.22912E-01_JPRB, 4.23713E-01_JPRB/)
      KAO_MN2O( 3, :, 9) = (/ &
     & 3.35672E-01_JPRB, 3.38982E-01_JPRB, 3.42326E-01_JPRB, 3.45702E-01_JPRB, 3.49111E-01_JPRB, &
     & 3.52554E-01_JPRB, 3.56031E-01_JPRB, 3.59543E-01_JPRB, 3.63089E-01_JPRB, 3.66670E-01_JPRB, &
     & 3.70286E-01_JPRB, 3.73938E-01_JPRB, 3.77626E-01_JPRB, 3.81350E-01_JPRB, 3.85111E-01_JPRB, &
     & 3.88909E-01_JPRB, 3.92745E-01_JPRB, 3.96618E-01_JPRB, 4.00530E-01_JPRB/)
      KAO_MN2O( 4, :, 9) = (/ &
     & 3.19130E-01_JPRB, 3.23028E-01_JPRB, 3.26973E-01_JPRB, 3.30966E-01_JPRB, 3.35008E-01_JPRB, &
     & 3.39100E-01_JPRB, 3.43241E-01_JPRB, 3.47433E-01_JPRB, 3.51676E-01_JPRB, 3.55971E-01_JPRB, &
     & 3.60319E-01_JPRB, 3.64719E-01_JPRB, 3.69173E-01_JPRB, 3.73682E-01_JPRB, 3.78246E-01_JPRB, &
     & 3.82865E-01_JPRB, 3.87541E-01_JPRB, 3.92274E-01_JPRB, 3.97065E-01_JPRB/)
      KAO_MN2O( 5, :, 9) = (/ &
     & 3.04385E-01_JPRB, 3.07155E-01_JPRB, 3.09949E-01_JPRB, 3.12770E-01_JPRB, 3.15616E-01_JPRB, &
     & 3.18488E-01_JPRB, 3.21386E-01_JPRB, 3.24310E-01_JPRB, 3.27261E-01_JPRB, 3.30239E-01_JPRB, &
     & 3.33244E-01_JPRB, 3.36276E-01_JPRB, 3.39336E-01_JPRB, 3.42424E-01_JPRB, 3.45540E-01_JPRB, &
     & 3.48684E-01_JPRB, 3.51857E-01_JPRB, 3.55059E-01_JPRB, 3.58289E-01_JPRB/)
      KAO_MN2O( 6, :, 9) = (/ &
     & 2.98789E-01_JPRB, 3.00996E-01_JPRB, 3.03220E-01_JPRB, 3.05460E-01_JPRB, 3.07717E-01_JPRB, &
     & 3.09990E-01_JPRB, 3.12281E-01_JPRB, 3.14588E-01_JPRB, 3.16912E-01_JPRB, 3.19253E-01_JPRB, &
     & 3.21612E-01_JPRB, 3.23988E-01_JPRB, 3.26382E-01_JPRB, 3.28793E-01_JPRB, 3.31222E-01_JPRB, &
     & 3.33669E-01_JPRB, 3.36134E-01_JPRB, 3.38618E-01_JPRB, 3.41119E-01_JPRB/)
      KAO_MN2O( 7, :, 9) = (/ &
     & 3.08712E-01_JPRB, 3.10491E-01_JPRB, 3.12281E-01_JPRB, 3.14080E-01_JPRB, 3.15890E-01_JPRB, &
     & 3.17710E-01_JPRB, 3.19541E-01_JPRB, 3.21382E-01_JPRB, 3.23234E-01_JPRB, 3.25097E-01_JPRB, &
     & 3.26970E-01_JPRB, 3.28854E-01_JPRB, 3.30749E-01_JPRB, 3.32655E-01_JPRB, 3.34572E-01_JPRB, &
     & 3.36500E-01_JPRB, 3.38439E-01_JPRB, 3.40390E-01_JPRB, 3.42351E-01_JPRB/)
      KAO_MN2O( 8, :, 9) = (/ &
     & 3.10571E-01_JPRB, 3.12262E-01_JPRB, 3.13961E-01_JPRB, 3.15670E-01_JPRB, 3.17388E-01_JPRB, &
     & 3.19115E-01_JPRB, 3.20852E-01_JPRB, 3.22598E-01_JPRB, 3.24354E-01_JPRB, 3.26120E-01_JPRB, &
     & 3.27895E-01_JPRB, 3.29679E-01_JPRB, 3.31474E-01_JPRB, 3.33278E-01_JPRB, 3.35092E-01_JPRB, &
     & 3.36915E-01_JPRB, 3.38749E-01_JPRB, 3.40593E-01_JPRB, 3.42447E-01_JPRB/)
      KAO_MN2O( 9, :, 9) = (/ &
     & 3.16436E-01_JPRB, 3.18200E-01_JPRB, 3.19974E-01_JPRB, 3.21759E-01_JPRB, 3.23553E-01_JPRB, &
     & 3.25357E-01_JPRB, 3.27172E-01_JPRB, 3.28996E-01_JPRB, 3.30831E-01_JPRB, 3.32675E-01_JPRB, &
     & 3.34530E-01_JPRB, 3.36396E-01_JPRB, 3.38272E-01_JPRB, 3.40158E-01_JPRB, 3.42055E-01_JPRB, &
     & 3.43962E-01_JPRB, 3.45880E-01_JPRB, 3.47809E-01_JPRB, 3.49749E-01_JPRB/)
      KAO_MN2O( 1, :,10) = (/ &
     & 7.68616E-01_JPRB, 7.63263E-01_JPRB, 7.57948E-01_JPRB, 7.52669E-01_JPRB, 7.47428E-01_JPRB, &
     & 7.42223E-01_JPRB, 7.37054E-01_JPRB, 7.31921E-01_JPRB, 7.26824E-01_JPRB, 7.21762E-01_JPRB, &
     & 7.16736E-01_JPRB, 7.11744E-01_JPRB, 7.06788E-01_JPRB, 7.01866E-01_JPRB, 6.96978E-01_JPRB, &
     & 6.92124E-01_JPRB, 6.87304E-01_JPRB, 6.82517E-01_JPRB, 6.77764E-01_JPRB/)
      KAO_MN2O( 2, :,10) = (/ &
     & 4.97271E-01_JPRB, 5.10054E-01_JPRB, 5.23165E-01_JPRB, 5.36614E-01_JPRB, 5.50408E-01_JPRB, &
     & 5.64556E-01_JPRB, 5.79069E-01_JPRB, 5.93954E-01_JPRB, 6.09222E-01_JPRB, 6.24883E-01_JPRB, &
     & 6.40946E-01_JPRB, 6.57422E-01_JPRB, 6.74321E-01_JPRB, 6.91655E-01_JPRB, 7.09435E-01_JPRB, &
     & 7.27671E-01_JPRB, 7.46377E-01_JPRB, 7.65563E-01_JPRB, 7.85242E-01_JPRB/)
      KAO_MN2O( 3, :,10) = (/ &
     & 2.44443E-01_JPRB, 2.47096E-01_JPRB, 2.49778E-01_JPRB, 2.52489E-01_JPRB, 2.55229E-01_JPRB, &
     & 2.57999E-01_JPRB, 2.60799E-01_JPRB, 2.63630E-01_JPRB, 2.66491E-01_JPRB, 2.69383E-01_JPRB, &
     & 2.72307E-01_JPRB, 2.75262E-01_JPRB, 2.78250E-01_JPRB, 2.81269E-01_JPRB, 2.84322E-01_JPRB, &
     & 2.87408E-01_JPRB, 2.90527E-01_JPRB, 2.93680E-01_JPRB, 2.96868E-01_JPRB/)
      KAO_MN2O( 4, :,10) = (/ &
     & 2.01964E-01_JPRB, 2.02869E-01_JPRB, 2.03777E-01_JPRB, 2.04690E-01_JPRB, 2.05606E-01_JPRB, &
     & 2.06527E-01_JPRB, 2.07452E-01_JPRB, 2.08381E-01_JPRB, 2.09314E-01_JPRB, 2.10251E-01_JPRB, &
     & 2.11193E-01_JPRB, 2.12139E-01_JPRB, 2.13089E-01_JPRB, 2.14043E-01_JPRB, 2.15002E-01_JPRB, &
     & 2.15964E-01_JPRB, 2.16932E-01_JPRB, 2.17903E-01_JPRB, 2.18879E-01_JPRB/)
      KAO_MN2O( 5, :,10) = (/ &
     & 2.56972E-01_JPRB, 2.56837E-01_JPRB, 2.56702E-01_JPRB, 2.56567E-01_JPRB, 2.56432E-01_JPRB, &
     & 2.56297E-01_JPRB, 2.56162E-01_JPRB, 2.56027E-01_JPRB, 2.55893E-01_JPRB, 2.55758E-01_JPRB, &
     & 2.55624E-01_JPRB, 2.55489E-01_JPRB, 2.55355E-01_JPRB, 2.55220E-01_JPRB, 2.55086E-01_JPRB, &
     & 2.54952E-01_JPRB, 2.54818E-01_JPRB, 2.54684E-01_JPRB, 2.54550E-01_JPRB/)
      KAO_MN2O( 6, :,10) = (/ &
     & 2.57322E-01_JPRB, 2.57187E-01_JPRB, 2.57052E-01_JPRB, 2.56917E-01_JPRB, 2.56782E-01_JPRB, &
     & 2.56647E-01_JPRB, 2.56512E-01_JPRB, 2.56377E-01_JPRB, 2.56243E-01_JPRB, 2.56108E-01_JPRB, &
     & 2.55974E-01_JPRB, 2.55839E-01_JPRB, 2.55705E-01_JPRB, 2.55570E-01_JPRB, 2.55436E-01_JPRB, &
     & 2.55302E-01_JPRB, 2.55168E-01_JPRB, 2.55034E-01_JPRB, 2.54900E-01_JPRB/)
      KAO_MN2O( 7, :,10) = (/ &
     & 2.56551E-01_JPRB, 2.56421E-01_JPRB, 2.56291E-01_JPRB, 2.56161E-01_JPRB, 2.56030E-01_JPRB, &
     & 2.55900E-01_JPRB, 2.55770E-01_JPRB, 2.55640E-01_JPRB, 2.55511E-01_JPRB, 2.55381E-01_JPRB, &
     & 2.55251E-01_JPRB, 2.55121E-01_JPRB, 2.54992E-01_JPRB, 2.54862E-01_JPRB, 2.54733E-01_JPRB, &
     & 2.54603E-01_JPRB, 2.54474E-01_JPRB, 2.54345E-01_JPRB, 2.54215E-01_JPRB/)
      KAO_MN2O( 8, :,10) = (/ &
     & 2.73629E-01_JPRB, 2.73460E-01_JPRB, 2.73291E-01_JPRB, 2.73122E-01_JPRB, 2.72953E-01_JPRB, &
     & 2.72784E-01_JPRB, 2.72615E-01_JPRB, 2.72447E-01_JPRB, 2.72279E-01_JPRB, 2.72110E-01_JPRB, &
     & 2.71942E-01_JPRB, 2.71774E-01_JPRB, 2.71606E-01_JPRB, 2.71438E-01_JPRB, 2.71270E-01_JPRB, &
     & 2.71102E-01_JPRB, 2.70935E-01_JPRB, 2.70767E-01_JPRB, 2.70600E-01_JPRB/)
      KAO_MN2O( 9, :,10) = (/ &
     & 2.57294E-01_JPRB, 2.57149E-01_JPRB, 2.57004E-01_JPRB, 2.56860E-01_JPRB, 2.56715E-01_JPRB, &
     & 2.56570E-01_JPRB, 2.56426E-01_JPRB, 2.56282E-01_JPRB, 2.56137E-01_JPRB, 2.55993E-01_JPRB, &
     & 2.55849E-01_JPRB, 2.55705E-01_JPRB, 2.55561E-01_JPRB, 2.55417E-01_JPRB, 2.55273E-01_JPRB, &
     & 2.55129E-01_JPRB, 2.54986E-01_JPRB, 2.54842E-01_JPRB, 2.54698E-01_JPRB/)
      KAO_MN2O( 1, :,11) = (/ &
     & 6.91062E-01_JPRB, 6.84151E-01_JPRB, 6.77309E-01_JPRB, 6.70535E-01_JPRB, 6.63829E-01_JPRB, &
     & 6.57190E-01_JPRB, 6.50617E-01_JPRB, 6.44111E-01_JPRB, 6.37669E-01_JPRB, 6.31292E-01_JPRB, &
     & 6.24978E-01_JPRB, 6.18728E-01_JPRB, 6.12540E-01_JPRB, 6.06414E-01_JPRB, 6.00349E-01_JPRB, &
     & 5.94345E-01_JPRB, 5.88401E-01_JPRB, 5.82517E-01_JPRB, 5.76691E-01_JPRB/)
      KAO_MN2O( 2, :,11) = (/ &
     & 1.98698E-01_JPRB, 2.01182E-01_JPRB, 2.03698E-01_JPRB, 2.06244E-01_JPRB, 2.08823E-01_JPRB, &
     & 2.11433E-01_JPRB, 2.14077E-01_JPRB, 2.16753E-01_JPRB, 2.19463E-01_JPRB, 2.22207E-01_JPRB, &
     & 2.24985E-01_JPRB, 2.27798E-01_JPRB, 2.30646E-01_JPRB, 2.33529E-01_JPRB, 2.36449E-01_JPRB, &
     & 2.39405E-01_JPRB, 2.42398E-01_JPRB, 2.45429E-01_JPRB, 2.48497E-01_JPRB/)
      KAO_MN2O( 3, :,11) = (/ &
     & 2.11950E-01_JPRB, 2.13560E-01_JPRB, 2.15184E-01_JPRB, 2.16819E-01_JPRB, 2.18467E-01_JPRB, &
     & 2.20127E-01_JPRB, 2.21800E-01_JPRB, 2.23486E-01_JPRB, 2.25185E-01_JPRB, 2.26896E-01_JPRB, &
     & 2.28621E-01_JPRB, 2.30358E-01_JPRB, 2.32109E-01_JPRB, 2.33873E-01_JPRB, 2.35651E-01_JPRB, &
     & 2.37442E-01_JPRB, 2.39247E-01_JPRB, 2.41065E-01_JPRB, 2.42897E-01_JPRB/)
      KAO_MN2O( 4, :,11) = (/ &
     & 3.14210E-01_JPRB, 3.13143E-01_JPRB, 3.12080E-01_JPRB, 3.11021E-01_JPRB, 3.09965E-01_JPRB, &
     & 3.08913E-01_JPRB, 3.07864E-01_JPRB, 3.06819E-01_JPRB, 3.05777E-01_JPRB, 3.04739E-01_JPRB, &
     & 3.03705E-01_JPRB, 3.02674E-01_JPRB, 3.01646E-01_JPRB, 3.00622E-01_JPRB, 2.99602E-01_JPRB, &
     & 2.98584E-01_JPRB, 2.97571E-01_JPRB, 2.96561E-01_JPRB, 2.95554E-01_JPRB/)
      KAO_MN2O( 5, :,11) = (/ &
     & 3.13536E-01_JPRB, 3.12459E-01_JPRB, 3.11386E-01_JPRB, 3.10316E-01_JPRB, 3.09250E-01_JPRB, &
     & 3.08188E-01_JPRB, 3.07129E-01_JPRB, 3.06074E-01_JPRB, 3.05022E-01_JPRB, 3.03974E-01_JPRB, &
     & 3.02930E-01_JPRB, 3.01889E-01_JPRB, 3.00852E-01_JPRB, 2.99819E-01_JPRB, 2.98789E-01_JPRB, &
     & 2.97762E-01_JPRB, 2.96739E-01_JPRB, 2.95720E-01_JPRB, 2.94704E-01_JPRB/)
      KAO_MN2O( 6, :,11) = (/ &
     & 3.13215E-01_JPRB, 3.12123E-01_JPRB, 3.11034E-01_JPRB, 3.09949E-01_JPRB, 3.08867E-01_JPRB, &
     & 3.07790E-01_JPRB, 3.06716E-01_JPRB, 3.05646E-01_JPRB, 3.04579E-01_JPRB, 3.03517E-01_JPRB, &
     & 3.02458E-01_JPRB, 3.01403E-01_JPRB, 3.00351E-01_JPRB, 2.99303E-01_JPRB, 2.98259E-01_JPRB, &
     & 2.97219E-01_JPRB, 2.96182E-01_JPRB, 2.95148E-01_JPRB, 2.94119E-01_JPRB/)
      KAO_MN2O( 7, :,11) = (/ &
     & 3.14236E-01_JPRB, 3.13123E-01_JPRB, 3.12014E-01_JPRB, 3.10908E-01_JPRB, 3.09806E-01_JPRB, &
     & 3.08709E-01_JPRB, 3.07615E-01_JPRB, 3.06525E-01_JPRB, 3.05439E-01_JPRB, 3.04357E-01_JPRB, &
     & 3.03278E-01_JPRB, 3.02204E-01_JPRB, 3.01133E-01_JPRB, 3.00066E-01_JPRB, 2.99003E-01_JPRB, &
     & 2.97944E-01_JPRB, 2.96888E-01_JPRB, 2.95836E-01_JPRB, 2.94788E-01_JPRB/)
      KAO_MN2O( 8, :,11) = (/ &
     & 2.97453E-01_JPRB, 2.96420E-01_JPRB, 2.95391E-01_JPRB, 2.94366E-01_JPRB, 2.93344E-01_JPRB, &
     & 2.92325E-01_JPRB, 2.91311E-01_JPRB, 2.90299E-01_JPRB, 2.89291E-01_JPRB, 2.88287E-01_JPRB, &
     & 2.87286E-01_JPRB, 2.86289E-01_JPRB, 2.85295E-01_JPRB, 2.84304E-01_JPRB, 2.83317E-01_JPRB, &
     & 2.82334E-01_JPRB, 2.81354E-01_JPRB, 2.80377E-01_JPRB, 2.79404E-01_JPRB/)
      KAO_MN2O( 9, :,11) = (/ &
     & 3.12694E-01_JPRB, 3.11622E-01_JPRB, 3.10554E-01_JPRB, 3.09489E-01_JPRB, 3.08428E-01_JPRB, &
     & 3.07370E-01_JPRB, 3.06316E-01_JPRB, 3.05266E-01_JPRB, 3.04220E-01_JPRB, 3.03177E-01_JPRB, &
     & 3.02137E-01_JPRB, 3.01101E-01_JPRB, 3.00069E-01_JPRB, 2.99040E-01_JPRB, 2.98015E-01_JPRB, &
     & 2.96993E-01_JPRB, 2.95975E-01_JPRB, 2.94960E-01_JPRB, 2.93949E-01_JPRB/)
      KAO_MN2O( 1, :,12) = (/ &
     & 5.30796E-01_JPRB, 5.50444E-01_JPRB, 5.70818E-01_JPRB, 5.91947E-01_JPRB, 6.13857E-01_JPRB, &
     & 6.36579E-01_JPRB, 6.60142E-01_JPRB, 6.84577E-01_JPRB, 7.09916E-01_JPRB, 7.36194E-01_JPRB, &
     & 7.63444E-01_JPRB, 7.91702E-01_JPRB, 8.21007E-01_JPRB, 8.51396E-01_JPRB, 8.82910E-01_JPRB, &
     & 9.15591E-01_JPRB, 9.49481E-01_JPRB, 9.84626E-01_JPRB, 1.02107E+00_JPRB/)
      KAO_MN2O( 2, :,12) = (/ &
     & 1.38469E-01_JPRB, 1.40959E-01_JPRB, 1.43493E-01_JPRB, 1.46073E-01_JPRB, 1.48699E-01_JPRB, &
     & 1.51373E-01_JPRB, 1.54094E-01_JPRB, 1.56865E-01_JPRB, 1.59685E-01_JPRB, 1.62556E-01_JPRB, &
     & 1.65478E-01_JPRB, 1.68454E-01_JPRB, 1.71482E-01_JPRB, 1.74565E-01_JPRB, 1.77704E-01_JPRB, &
     & 1.80899E-01_JPRB, 1.84151E-01_JPRB, 1.87462E-01_JPRB, 1.90833E-01_JPRB/)
      KAO_MN2O( 3, :,12) = (/ &
     & 1.50741E-01_JPRB, 1.50855E-01_JPRB, 1.50969E-01_JPRB, 1.51084E-01_JPRB, 1.51198E-01_JPRB, &
     & 1.51313E-01_JPRB, 1.51427E-01_JPRB, 1.51542E-01_JPRB, 1.51657E-01_JPRB, 1.51772E-01_JPRB, &
     & 1.51887E-01_JPRB, 1.52002E-01_JPRB, 1.52117E-01_JPRB, 1.52233E-01_JPRB, 1.52348E-01_JPRB, &
     & 1.52463E-01_JPRB, 1.52579E-01_JPRB, 1.52695E-01_JPRB, 1.52810E-01_JPRB/)
      KAO_MN2O( 4, :,12) = (/ &
     & 1.80444E-01_JPRB, 1.79944E-01_JPRB, 1.79445E-01_JPRB, 1.78948E-01_JPRB, 1.78452E-01_JPRB, &
     & 1.77958E-01_JPRB, 1.77465E-01_JPRB, 1.76973E-01_JPRB, 1.76483E-01_JPRB, 1.75994E-01_JPRB, &
     & 1.75506E-01_JPRB, 1.75020E-01_JPRB, 1.74535E-01_JPRB, 1.74051E-01_JPRB, 1.73569E-01_JPRB, &
     & 1.73088E-01_JPRB, 1.72609E-01_JPRB, 1.72131E-01_JPRB, 1.71654E-01_JPRB/)
      KAO_MN2O( 5, :,12) = (/ &
     & 1.80595E-01_JPRB, 1.80033E-01_JPRB, 1.79474E-01_JPRB, 1.78916E-01_JPRB, 1.78359E-01_JPRB, &
     & 1.77805E-01_JPRB, 1.77252E-01_JPRB, 1.76701E-01_JPRB, 1.76152E-01_JPRB, 1.75604E-01_JPRB, &
     & 1.75058E-01_JPRB, 1.74514E-01_JPRB, 1.73971E-01_JPRB, 1.73430E-01_JPRB, 1.72891E-01_JPRB, &
     & 1.72354E-01_JPRB, 1.71818E-01_JPRB, 1.71284E-01_JPRB, 1.70751E-01_JPRB/)
      KAO_MN2O( 6, :,12) = (/ &
     & 1.79904E-01_JPRB, 1.79254E-01_JPRB, 1.78607E-01_JPRB, 1.77962E-01_JPRB, 1.77320E-01_JPRB, &
     & 1.76680E-01_JPRB, 1.76042E-01_JPRB, 1.75406E-01_JPRB, 1.74773E-01_JPRB, 1.74142E-01_JPRB, &
     & 1.73513E-01_JPRB, 1.72887E-01_JPRB, 1.72262E-01_JPRB, 1.71640E-01_JPRB, 1.71021E-01_JPRB, &
     & 1.70403E-01_JPRB, 1.69788E-01_JPRB, 1.69175E-01_JPRB, 1.68564E-01_JPRB/)
      KAO_MN2O( 7, :,12) = (/ &
     & 1.78712E-01_JPRB, 1.77868E-01_JPRB, 1.77027E-01_JPRB, 1.76190E-01_JPRB, 1.75357E-01_JPRB, &
     & 1.74528E-01_JPRB, 1.73703E-01_JPRB, 1.72882E-01_JPRB, 1.72064E-01_JPRB, 1.71251E-01_JPRB, &
     & 1.70441E-01_JPRB, 1.69636E-01_JPRB, 1.68834E-01_JPRB, 1.68036E-01_JPRB, 1.67241E-01_JPRB, &
     & 1.66451E-01_JPRB, 1.65664E-01_JPRB, 1.64881E-01_JPRB, 1.64101E-01_JPRB/)
      KAO_MN2O( 8, :,12) = (/ &
     & 1.72346E-01_JPRB, 1.70873E-01_JPRB, 1.69413E-01_JPRB, 1.67965E-01_JPRB, 1.66530E-01_JPRB, &
     & 1.65107E-01_JPRB, 1.63696E-01_JPRB, 1.62297E-01_JPRB, 1.60910E-01_JPRB, 1.59535E-01_JPRB, &
     & 1.58171E-01_JPRB, 1.56819E-01_JPRB, 1.55479E-01_JPRB, 1.54150E-01_JPRB, 1.52833E-01_JPRB, &
     & 1.51527E-01_JPRB, 1.50232E-01_JPRB, 1.48948E-01_JPRB, 1.47675E-01_JPRB/)
      KAO_MN2O( 9, :,12) = (/ &
     & 1.80517E-01_JPRB, 1.79951E-01_JPRB, 1.79386E-01_JPRB, 1.78823E-01_JPRB, 1.78262E-01_JPRB, &
     & 1.77702E-01_JPRB, 1.77144E-01_JPRB, 1.76588E-01_JPRB, 1.76034E-01_JPRB, 1.75481E-01_JPRB, &
     & 1.74931E-01_JPRB, 1.74382E-01_JPRB, 1.73834E-01_JPRB, 1.73289E-01_JPRB, 1.72745E-01_JPRB, &
     & 1.72202E-01_JPRB, 1.71662E-01_JPRB, 1.71123E-01_JPRB, 1.70586E-01_JPRB/)
      KAO_MN2O( 1, :,13) = (/ &
     & 2.41966E-01_JPRB, 2.50534E-01_JPRB, 2.59406E-01_JPRB, 2.68591E-01_JPRB, 2.78102E-01_JPRB, &
     & 2.87950E-01_JPRB, 2.98146E-01_JPRB, 3.08704E-01_JPRB, 3.19635E-01_JPRB, 3.30953E-01_JPRB, &
     & 3.42672E-01_JPRB, 3.54806E-01_JPRB, 3.67370E-01_JPRB, 3.80379E-01_JPRB, 3.93848E-01_JPRB, &
     & 4.07794E-01_JPRB, 4.22234E-01_JPRB, 4.37186E-01_JPRB, 4.52667E-01_JPRB/)
      KAO_MN2O( 2, :,13) = (/ &
     & 1.54385E-01_JPRB, 1.54015E-01_JPRB, 1.53646E-01_JPRB, 1.53279E-01_JPRB, 1.52912E-01_JPRB, &
     & 1.52545E-01_JPRB, 1.52180E-01_JPRB, 1.51816E-01_JPRB, 1.51452E-01_JPRB, 1.51089E-01_JPRB, &
     & 1.50728E-01_JPRB, 1.50367E-01_JPRB, 1.50007E-01_JPRB, 1.49647E-01_JPRB, 1.49289E-01_JPRB, &
     & 1.48932E-01_JPRB, 1.48575E-01_JPRB, 1.48219E-01_JPRB, 1.47864E-01_JPRB/)
      KAO_MN2O( 3, :,13) = (/ &
     & 2.00518E-01_JPRB, 1.94901E-01_JPRB, 1.89442E-01_JPRB, 1.84136E-01_JPRB, 1.78978E-01_JPRB, &
     & 1.73965E-01_JPRB, 1.69092E-01_JPRB, 1.64356E-01_JPRB, 1.59752E-01_JPRB, 1.55278E-01_JPRB, &
     & 1.50928E-01_JPRB, 1.46701E-01_JPRB, 1.42592E-01_JPRB, 1.38598E-01_JPRB, 1.34715E-01_JPRB, &
     & 1.30942E-01_JPRB, 1.27274E-01_JPRB, 1.23709E-01_JPRB, 1.20244E-01_JPRB/)
      KAO_MN2O( 4, :,13) = (/ &
     & 2.03974E-01_JPRB, 1.98258E-01_JPRB, 1.92703E-01_JPRB, 1.87302E-01_JPRB, 1.82054E-01_JPRB, &
     & 1.76952E-01_JPRB, 1.71993E-01_JPRB, 1.67173E-01_JPRB, 1.62489E-01_JPRB, 1.57935E-01_JPRB, &
     & 1.53509E-01_JPRB, 1.49207E-01_JPRB, 1.45026E-01_JPRB, 1.40962E-01_JPRB, 1.37012E-01_JPRB, &
     & 1.33172E-01_JPRB, 1.29440E-01_JPRB, 1.25813E-01_JPRB, 1.22287E-01_JPRB/)
      KAO_MN2O( 5, :,13) = (/ &
     & 2.09410E-01_JPRB, 2.03543E-01_JPRB, 1.97841E-01_JPRB, 1.92298E-01_JPRB, 1.86911E-01_JPRB, &
     & 1.81674E-01_JPRB, 1.76585E-01_JPRB, 1.71637E-01_JPRB, 1.66829E-01_JPRB, 1.62155E-01_JPRB, &
     & 1.57612E-01_JPRB, 1.53196E-01_JPRB, 1.48904E-01_JPRB, 1.44733E-01_JPRB, 1.40678E-01_JPRB, &
     & 1.36736E-01_JPRB, 1.32906E-01_JPRB, 1.29182E-01_JPRB, 1.25563E-01_JPRB/)
      KAO_MN2O( 6, :,13) = (/ &
     & 2.19808E-01_JPRB, 2.13643E-01_JPRB, 2.07651E-01_JPRB, 2.01827E-01_JPRB, 1.96166E-01_JPRB, &
     & 1.90664E-01_JPRB, 1.85317E-01_JPRB, 1.80119E-01_JPRB, 1.75067E-01_JPRB, 1.70157E-01_JPRB, &
     & 1.65385E-01_JPRB, 1.60746E-01_JPRB, 1.56238E-01_JPRB, 1.51856E-01_JPRB, 1.47596E-01_JPRB, &
     & 1.43457E-01_JPRB, 1.39433E-01_JPRB, 1.35523E-01_JPRB, 1.31722E-01_JPRB/)
      KAO_MN2O( 7, :,13) = (/ &
     & 2.47074E-01_JPRB, 2.40127E-01_JPRB, 2.33375E-01_JPRB, 2.26813E-01_JPRB, 2.20436E-01_JPRB, &
     & 2.14238E-01_JPRB, 2.08215E-01_JPRB, 2.02360E-01_JPRB, 1.96671E-01_JPRB, 1.91141E-01_JPRB, &
     & 1.85767E-01_JPRB, 1.80544E-01_JPRB, 1.75467E-01_JPRB, 1.70534E-01_JPRB, 1.65739E-01_JPRB, &
     & 1.61079E-01_JPRB, 1.56550E-01_JPRB, 1.52148E-01_JPRB, 1.47870E-01_JPRB/)
      KAO_MN2O( 8, :,13) = (/ &
     & 2.55282E-01_JPRB, 2.48105E-01_JPRB, 2.41130E-01_JPRB, 2.34350E-01_JPRB, 2.27762E-01_JPRB, &
     & 2.21358E-01_JPRB, 2.15135E-01_JPRB, 2.09086E-01_JPRB, 2.03208E-01_JPRB, 1.97495E-01_JPRB, &
     & 1.91942E-01_JPRB, 1.86546E-01_JPRB, 1.81301E-01_JPRB, 1.76204E-01_JPRB, 1.71250E-01_JPRB, &
     & 1.66435E-01_JPRB, 1.61756E-01_JPRB, 1.57208E-01_JPRB, 1.52788E-01_JPRB/)
      KAO_MN2O( 9, :,13) = (/ &
     & 2.09991E-01_JPRB, 2.04103E-01_JPRB, 1.98380E-01_JPRB, 1.92818E-01_JPRB, 1.87411E-01_JPRB, &
     & 1.82156E-01_JPRB, 1.77048E-01_JPRB, 1.72084E-01_JPRB, 1.67259E-01_JPRB, 1.62569E-01_JPRB, &
     & 1.58010E-01_JPRB, 1.53580E-01_JPRB, 1.49273E-01_JPRB, 1.45087E-01_JPRB, 1.41019E-01_JPRB, &
     & 1.37065E-01_JPRB, 1.33222E-01_JPRB, 1.29486E-01_JPRB, 1.25855E-01_JPRB/)
      KAO_MN2O( 1, :,14) = (/ &
     & 9.08340E-02_JPRB, 9.50421E-02_JPRB, 9.94452E-02_JPRB, 1.04052E-01_JPRB, 1.08873E-01_JPRB, &
     & 1.13917E-01_JPRB, 1.19194E-01_JPRB, 1.24716E-01_JPRB, 1.30494E-01_JPRB, 1.36540E-01_JPRB, &
     & 1.42865E-01_JPRB, 1.49484E-01_JPRB, 1.56409E-01_JPRB, 1.63655E-01_JPRB, 1.71237E-01_JPRB, &
     & 1.79170E-01_JPRB, 1.87471E-01_JPRB, 1.96156E-01_JPRB, 2.05243E-01_JPRB/)
      KAO_MN2O( 2, :,14) = (/ &
     & 3.36945E-02_JPRB, 3.45144E-02_JPRB, 3.53542E-02_JPRB, 3.62144E-02_JPRB, 3.70956E-02_JPRB, &
     & 3.79982E-02_JPRB, 3.89228E-02_JPRB, 3.98698E-02_JPRB, 4.08399E-02_JPRB, 4.18336E-02_JPRB, &
     & 4.28515E-02_JPRB, 4.38942E-02_JPRB, 4.49622E-02_JPRB, 4.60562E-02_JPRB, 4.71769E-02_JPRB, &
     & 4.83248E-02_JPRB, 4.95006E-02_JPRB, 5.07051E-02_JPRB, 5.19388E-02_JPRB/)
      KAO_MN2O( 3, :,14) = (/ &
     & 9.11678E-02_JPRB, 8.85761E-02_JPRB, 8.60580E-02_JPRB, 8.36116E-02_JPRB, 8.12347E-02_JPRB, &
     & 7.89253E-02_JPRB, 7.66817E-02_JPRB, 7.45017E-02_JPRB, 7.23838E-02_JPRB, 7.03261E-02_JPRB, &
     & 6.83269E-02_JPRB, 6.63845E-02_JPRB, 6.44973E-02_JPRB, 6.26638E-02_JPRB, 6.08824E-02_JPRB, &
     & 5.91516E-02_JPRB, 5.74700E-02_JPRB, 5.58363E-02_JPRB, 5.42490E-02_JPRB/)
      KAO_MN2O( 4, :,14) = (/ &
     & 8.43999E-02_JPRB, 8.20004E-02_JPRB, 7.96692E-02_JPRB, 7.74042E-02_JPRB, 7.52037E-02_JPRB, &
     & 7.30656E-02_JPRB, 7.09884E-02_JPRB, 6.89702E-02_JPRB, 6.70094E-02_JPRB, 6.51044E-02_JPRB, &
     & 6.32535E-02_JPRB, 6.14552E-02_JPRB, 5.97081E-02_JPRB, 5.80106E-02_JPRB, 5.63614E-02_JPRB, &
     & 5.47590E-02_JPRB, 5.32022E-02_JPRB, 5.16897E-02_JPRB, 5.02202E-02_JPRB/)
      KAO_MN2O( 5, :,14) = (/ &
     & 7.41279E-02_JPRB, 7.20196E-02_JPRB, 6.99712E-02_JPRB, 6.79811E-02_JPRB, 6.60476E-02_JPRB, &
     & 6.41691E-02_JPRB, 6.23440E-02_JPRB, 6.05708E-02_JPRB, 5.88481E-02_JPRB, 5.71743E-02_JPRB, &
     & 5.55482E-02_JPRB, 5.39683E-02_JPRB, 5.24334E-02_JPRB, 5.09421E-02_JPRB, 4.94932E-02_JPRB, &
     & 4.80855E-02_JPRB, 4.67179E-02_JPRB, 4.53891E-02_JPRB, 4.40982E-02_JPRB/)
      KAO_MN2O( 6, :,14) = (/ &
     & 5.66805E-02_JPRB, 5.50676E-02_JPRB, 5.35006E-02_JPRB, 5.19782E-02_JPRB, 5.04991E-02_JPRB, &
     & 4.90621E-02_JPRB, 4.76659E-02_JPRB, 4.63096E-02_JPRB, 4.49918E-02_JPRB, 4.37115E-02_JPRB, &
     & 4.24676E-02_JPRB, 4.12592E-02_JPRB, 4.00851E-02_JPRB, 3.89444E-02_JPRB, 3.78362E-02_JPRB, &
     & 3.67595E-02_JPRB, 3.57135E-02_JPRB, 3.46972E-02_JPRB, 3.37099E-02_JPRB/)
      KAO_MN2O( 7, :,14) = (/ &
     & 1.23018E-02_JPRB, 1.19517E-02_JPRB, 1.16116E-02_JPRB, 1.12811E-02_JPRB, 1.09601E-02_JPRB, &
     & 1.06482E-02_JPRB, 1.03452E-02_JPRB, 1.00508E-02_JPRB, 9.76474E-03_JPRB, 9.48685E-03_JPRB, &
     & 9.21687E-03_JPRB, 8.95458E-03_JPRB, 8.69974E-03_JPRB, 8.45216E-03_JPRB, 8.21163E-03_JPRB, &
     & 7.97794E-03_JPRB, 7.75091E-03_JPRB, 7.53033E-03_JPRB, 7.31603E-03_JPRB/)
      KAO_MN2O( 8, :,14) = (/ &
     & 3.22403E-07_JPRB, 3.75986E-07_JPRB, 4.38475E-07_JPRB, 5.11349E-07_JPRB, 5.96335E-07_JPRB, &
     & 6.95446E-07_JPRB, 8.11028E-07_JPRB, 9.45821E-07_JPRB, 1.10302E-06_JPRB, 1.28634E-06_JPRB, &
     & 1.50012E-06_JPRB, 1.74944E-06_JPRB, 2.04020E-06_JPRB, 2.37928E-06_JPRB, 2.77472E-06_JPRB, &
     & 3.23587E-06_JPRB, 3.77367E-06_JPRB, 4.40085E-06_JPRB, 5.13227E-06_JPRB/)
      KAO_MN2O( 9, :,14) = (/ &
     & 7.33052E-02_JPRB, 7.12199E-02_JPRB, 6.91939E-02_JPRB, 6.72255E-02_JPRB, 6.53131E-02_JPRB, &
     & 6.34551E-02_JPRB, 6.16500E-02_JPRB, 5.98963E-02_JPRB, 5.81924E-02_JPRB, 5.65370E-02_JPRB, &
     & 5.49287E-02_JPRB, 5.33661E-02_JPRB, 5.18480E-02_JPRB, 5.03730E-02_JPRB, 4.89401E-02_JPRB, &
     & 4.75479E-02_JPRB, 4.61953E-02_JPRB, 4.48811E-02_JPRB, 4.36044E-02_JPRB/)
      KAO_MN2O( 1, :,15) = (/ &
     & 8.80247E-02_JPRB, 9.01793E-02_JPRB, 9.23868E-02_JPRB, 9.46482E-02_JPRB, 9.69650E-02_JPRB, &
     & 9.93385E-02_JPRB, 1.01770E-01_JPRB, 1.04261E-01_JPRB, 1.06813E-01_JPRB, 1.09428E-01_JPRB, &
     & 1.12107E-01_JPRB, 1.14851E-01_JPRB, 1.17662E-01_JPRB, 1.20542E-01_JPRB, 1.23493E-01_JPRB, &
     & 1.26516E-01_JPRB, 1.29613E-01_JPRB, 1.32785E-01_JPRB, 1.36036E-01_JPRB/)
      KAO_MN2O( 2, :,15) = (/ &
     & 3.89107E-07_JPRB, 4.53768E-07_JPRB, 5.29173E-07_JPRB, 6.17109E-07_JPRB, 7.19658E-07_JPRB, &
     & 8.39248E-07_JPRB, 9.78710E-07_JPRB, 1.14135E-06_JPRB, 1.33101E-06_JPRB, 1.55220E-06_JPRB, &
     & 1.81013E-06_JPRB, 2.11094E-06_JPRB, 2.46172E-06_JPRB, 2.87080E-06_JPRB, 3.34786E-06_JPRB, &
     & 3.90420E-06_JPRB, 4.55298E-06_JPRB, 5.30958E-06_JPRB, 6.19190E-06_JPRB/)
      KAO_MN2O( 3, :,15) = (/ &
     & 3.86537E-07_JPRB, 4.50763E-07_JPRB, 5.25662E-07_JPRB, 6.13006E-07_JPRB, 7.14863E-07_JPRB, &
     & 8.33644E-07_JPRB, 9.72162E-07_JPRB, 1.13370E-06_JPRB, 1.32207E-06_JPRB, 1.54175E-06_JPRB, &
     & 1.79792E-06_JPRB, 2.09666E-06_JPRB, 2.44504E-06_JPRB, 2.85131E-06_JPRB, 3.32508E-06_JPRB, &
     & 3.87758E-06_JPRB, 4.52188E-06_JPRB, 5.27323E-06_JPRB, 6.14943E-06_JPRB/)
      KAO_MN2O( 4, :,15) = (/ &
     & 3.81913E-07_JPRB, 4.45369E-07_JPRB, 5.19369E-07_JPRB, 6.05664E-07_JPRB, 7.06297E-07_JPRB, &
     & 8.23651E-07_JPRB, 9.60503E-07_JPRB, 1.12009E-06_JPRB, 1.30620E-06_JPRB, 1.52323E-06_JPRB, &
     & 1.77632E-06_JPRB, 2.07147E-06_JPRB, 2.41565E-06_JPRB, 2.81701E-06_JPRB, 3.28507E-06_JPRB, &
     & 3.83090E-06_JPRB, 4.46741E-06_JPRB, 5.20969E-06_JPRB, 6.07529E-06_JPRB/)
      KAO_MN2O( 5, :,15) = (/ &
     & 3.77265E-07_JPRB, 4.39951E-07_JPRB, 5.13053E-07_JPRB, 5.98303E-07_JPRB, 6.97717E-07_JPRB, &
     & 8.13650E-07_JPRB, 9.48846E-07_JPRB, 1.10651E-06_JPRB, 1.29036E-06_JPRB, 1.50477E-06_JPRB, &
     & 1.75480E-06_JPRB, 2.04638E-06_JPRB, 2.38641E-06_JPRB, 2.78294E-06_JPRB, 3.24535E-06_JPRB, &
     & 3.78460E-06_JPRB, 4.41345E-06_JPRB, 5.14679E-06_JPRB, 6.00198E-06_JPRB/)
      KAO_MN2O( 6, :,15) = (/ &
     & 3.77877E-07_JPRB, 4.40670E-07_JPRB, 5.13897E-07_JPRB, 5.99292E-07_JPRB, 6.98878E-07_JPRB, &
     & 8.15012E-07_JPRB, 9.50444E-07_JPRB, 1.10838E-06_JPRB, 1.29256E-06_JPRB, 1.50735E-06_JPRB, &
     & 1.75783E-06_JPRB, 2.04993E-06_JPRB, 2.39057E-06_JPRB, 2.78782E-06_JPRB, 3.25107E-06_JPRB, &
     & 3.79131E-06_JPRB, 4.42132E-06_JPRB, 5.15602E-06_JPRB, 6.01280E-06_JPRB/)
      KAO_MN2O( 7, :,15) = (/ &
     & 3.80495E-07_JPRB, 4.43726E-07_JPRB, 5.17465E-07_JPRB, 6.03458E-07_JPRB, 7.03741E-07_JPRB, &
     & 8.20689E-07_JPRB, 9.57072E-07_JPRB, 1.11612E-06_JPRB, 1.30160E-06_JPRB, 1.51790E-06_JPRB, &
     & 1.77014E-06_JPRB, 2.06430E-06_JPRB, 2.40735E-06_JPRB, 2.80741E-06_JPRB, 3.27394E-06_JPRB, &
     & 3.81801E-06_JPRB, 4.45249E-06_JPRB, 5.19241E-06_JPRB, 6.05528E-06_JPRB/)
      KAO_MN2O( 8, :,15) = (/ &
     & 3.87881E-07_JPRB, 4.52329E-07_JPRB, 5.27486E-07_JPRB, 6.15129E-07_JPRB, 7.17335E-07_JPRB, &
     & 8.36523E-07_JPRB, 9.75515E-07_JPRB, 1.13760E-06_JPRB, 1.32662E-06_JPRB, 1.54704E-06_JPRB, &
     & 1.80409E-06_JPRB, 2.10384E-06_JPRB, 2.45340E-06_JPRB, 2.86105E-06_JPRB, 3.33642E-06_JPRB, &
     & 3.89078E-06_JPRB, 4.53725E-06_JPRB, 5.29112E-06_JPRB, 6.17026E-06_JPRB/)
      KAO_MN2O( 9, :,15) = (/ &
     & 3.77265E-07_JPRB, 4.39951E-07_JPRB, 5.13053E-07_JPRB, 5.98303E-07_JPRB, 6.97717E-07_JPRB, &
     & 8.13650E-07_JPRB, 9.48846E-07_JPRB, 1.10651E-06_JPRB, 1.29036E-06_JPRB, 1.50477E-06_JPRB, &
     & 1.75480E-06_JPRB, 2.04638E-06_JPRB, 2.38641E-06_JPRB, 2.78294E-06_JPRB, 3.24535E-06_JPRB, &
     & 3.78460E-06_JPRB, 4.41345E-06_JPRB, 5.14679E-06_JPRB, 6.00198E-06_JPRB/)
      KAO_MN2O( 1, :,16) = (/ &
     & 8.84606E-02_JPRB, 9.05971E-02_JPRB, 9.27852E-02_JPRB, 9.50261E-02_JPRB, 9.73212E-02_JPRB, &
     & 9.96717E-02_JPRB, 1.02079E-01_JPRB, 1.04544E-01_JPRB, 1.07069E-01_JPRB, 1.09655E-01_JPRB, &
     & 1.12304E-01_JPRB, 1.15016E-01_JPRB, 1.17794E-01_JPRB, 1.20639E-01_JPRB, 1.23553E-01_JPRB, &
     & 1.26537E-01_JPRB, 1.29593E-01_JPRB, 1.32723E-01_JPRB, 1.35928E-01_JPRB/)
      KAO_MN2O( 2, :,16) = (/ &
     & 8.13898E-07_JPRB, 9.49130E-07_JPRB, 1.10683E-06_JPRB, 1.29073E-06_JPRB, 1.50519E-06_JPRB, &
     & 1.75528E-06_JPRB, 2.04693E-06_JPRB, 2.38703E-06_JPRB, 2.78364E-06_JPRB, 3.24615E-06_JPRB, &
     & 3.78551E-06_JPRB, 4.41449E-06_JPRB, 5.14796E-06_JPRB, 6.00331E-06_JPRB, 7.00078E-06_JPRB, &
     & 8.16398E-06_JPRB, 9.52045E-06_JPRB, 1.11023E-05_JPRB, 1.29470E-05_JPRB/)
      KAO_MN2O( 3, :,16) = (/ &
     & 8.32666E-07_JPRB, 9.71021E-07_JPRB, 1.13237E-06_JPRB, 1.32052E-06_JPRB, 1.53994E-06_JPRB, &
     & 1.79581E-06_JPRB, 2.09420E-06_JPRB, 2.44217E-06_JPRB, 2.84796E-06_JPRB, 3.32117E-06_JPRB, &
     & 3.87302E-06_JPRB, 4.51656E-06_JPRB, 5.26703E-06_JPRB, 6.14219E-06_JPRB, 7.16277E-06_JPRB, &
     & 8.35294E-06_JPRB, 9.74086E-06_JPRB, 1.13594E-05_JPRB, 1.32468E-05_JPRB/)
      KAO_MN2O( 4, :,16) = (/ &
     & 8.70348E-07_JPRB, 1.01496E-06_JPRB, 1.18360E-06_JPRB, 1.38026E-06_JPRB, 1.60959E-06_JPRB, &
     & 1.87703E-06_JPRB, 2.18890E-06_JPRB, 2.55259E-06_JPRB, 2.97671E-06_JPRB, 3.47130E-06_JPRB, &
     & 4.04807E-06_JPRB, 4.72067E-06_JPRB, 5.50502E-06_JPRB, 6.41970E-06_JPRB, 7.48635E-06_JPRB, &
     & 8.73023E-06_JPRB, 1.01808E-05_JPRB, 1.18724E-05_JPRB, 1.38450E-05_JPRB/)
      KAO_MN2O( 5, :,16) = (/ &
     & 9.07957E-07_JPRB, 1.05882E-06_JPRB, 1.23475E-06_JPRB, 1.43991E-06_JPRB, 1.67916E-06_JPRB, &
     & 1.95816E-06_JPRB, 2.28352E-06_JPRB, 2.66294E-06_JPRB, 3.10541E-06_JPRB, 3.62139E-06_JPRB, &
     & 4.22310E-06_JPRB, 4.92480E-06_JPRB, 5.74308E-06_JPRB, 6.69733E-06_JPRB, 7.81013E-06_JPRB, &
     & 9.10784E-06_JPRB, 1.06212E-05_JPRB, 1.23859E-05_JPRB, 1.44439E-05_JPRB/)
      KAO_MN2O( 6, :,16) = (/ &
     & 8.59072E-04_JPRB, 9.19773E-04_JPRB, 9.84764E-04_JPRB, 1.05435E-03_JPRB, 1.12885E-03_JPRB, &
     & 1.20861E-03_JPRB, 1.29401E-03_JPRB, 1.38544E-03_JPRB, 1.48334E-03_JPRB, 1.58815E-03_JPRB, &
     & 1.70037E-03_JPRB, 1.82052E-03_JPRB, 1.94915E-03_JPRB, 2.08688E-03_JPRB, 2.23434E-03_JPRB, &
     & 2.39222E-03_JPRB, 2.56125E-03_JPRB, 2.74223E-03_JPRB, 2.93599E-03_JPRB/)
      KAO_MN2O( 7, :,16) = (/ &
     & 9.17294E-07_JPRB, 1.06971E-06_JPRB, 1.24746E-06_JPRB, 1.45474E-06_JPRB, 1.69646E-06_JPRB, &
     & 1.97835E-06_JPRB, 2.30708E-06_JPRB, 2.69043E-06_JPRB, 3.13748E-06_JPRB, 3.65880E-06_JPRB, &
     & 4.26676E-06_JPRB, 4.97574E-06_JPRB, 5.80251E-06_JPRB, 6.76667E-06_JPRB, 7.89104E-06_JPRB, &
     & 9.20223E-06_JPRB, 1.07313E-05_JPRB, 1.25144E-05_JPRB, 1.45939E-05_JPRB/)
      KAO_MN2O( 8, :,16) = (/ &
     & 9.17341E-07_JPRB, 1.06977E-06_JPRB, 1.24752E-06_JPRB, 1.45480E-06_JPRB, 1.69653E-06_JPRB, &
     & 1.97843E-06_JPRB, 2.30716E-06_JPRB, 2.69051E-06_JPRB, 3.13757E-06_JPRB, 3.65890E-06_JPRB, &
     & 4.26686E-06_JPRB, 4.97584E-06_JPRB, 5.80261E-06_JPRB, 6.76677E-06_JPRB, 7.89113E-06_JPRB, &
     & 9.20231E-06_JPRB, 1.07314E-05_JPRB, 1.25145E-05_JPRB, 1.45939E-05_JPRB/)
      KAO_MN2O( 9, :,16) = (/ &
     & 9.07957E-07_JPRB, 1.05882E-06_JPRB, 1.23475E-06_JPRB, 1.43991E-06_JPRB, 1.67916E-06_JPRB, &
     & 1.95816E-06_JPRB, 2.28352E-06_JPRB, 2.66294E-06_JPRB, 3.10541E-06_JPRB, 3.62139E-06_JPRB, &
     & 4.22310E-06_JPRB, 4.92480E-06_JPRB, 5.74308E-06_JPRB, 6.69733E-06_JPRB, 7.81013E-06_JPRB, &
     & 9.10784E-06_JPRB, 1.06212E-05_JPRB, 1.23859E-05_JPRB, 1.44439E-05_JPRB/)

!     The array KBO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level above 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amounts ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 to 
!     that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      KBO_MN2O( 1, :, 1) = (/ &
     & 7.72009E-08_JPRB, 1.15883E-07_JPRB, 1.73947E-07_JPRB, 2.61104E-07_JPRB, 3.91932E-07_JPRB, &
     & 5.88311E-07_JPRB, 8.83088E-07_JPRB, 1.32556E-06_JPRB, 1.98975E-06_JPRB, 2.98672E-06_JPRB, &
     & 4.48324E-06_JPRB, 6.72960E-06_JPRB, 1.01015E-05_JPRB, 1.51629E-05_JPRB, 2.27604E-05_JPRB, &
     & 3.41646E-05_JPRB, 5.12831E-05_JPRB, 7.69787E-05_JPRB, 1.15549E-04_JPRB/)
      KBO_MN2O( 2, :, 1) = (/ &
     & 1.29932E-05_JPRB, 1.78207E-05_JPRB, 2.44419E-05_JPRB, 3.35232E-05_JPRB, 4.59786E-05_JPRB, &
     & 6.30617E-05_JPRB, 8.64920E-05_JPRB, 1.18628E-04_JPRB, 1.62703E-04_JPRB, 2.23155E-04_JPRB, &
     & 3.06067E-04_JPRB, 4.19784E-04_JPRB, 5.75753E-04_JPRB, 7.89671E-04_JPRB, 1.08307E-03_JPRB, &
     & 1.48548E-03_JPRB, 2.03740E-03_JPRB, 2.79439E-03_JPRB, 3.83262E-03_JPRB/)
      KBO_MN2O( 3, :, 1) = (/ &
     & 6.44518E-05_JPRB, 8.10996E-05_JPRB, 1.02047E-04_JPRB, 1.28406E-04_JPRB, 1.61573E-04_JPRB, &
     & 2.03307E-04_JPRB, 2.55821E-04_JPRB, 3.21899E-04_JPRB, 4.05045E-04_JPRB, 5.09667E-04_JPRB, &
     & 6.41313E-04_JPRB, 8.06964E-04_JPRB, 1.01540E-03_JPRB, 1.27768E-03_JPRB, 1.60770E-03_JPRB, &
     & 2.02296E-03_JPRB, 2.54549E-03_JPRB, 3.20298E-03_JPRB, 4.03031E-03_JPRB/)
      KBO_MN2O( 4, :, 1) = (/ &
     & 3.23454E-04_JPRB, 3.82112E-04_JPRB, 4.51408E-04_JPRB, 5.33270E-04_JPRB, 6.29978E-04_JPRB, &
     & 7.44223E-04_JPRB, 8.79187E-04_JPRB, 1.03863E-03_JPRB, 1.22698E-03_JPRB, 1.44949E-03_JPRB, &
     & 1.71235E-03_JPRB, 2.02289E-03_JPRB, 2.38974E-03_JPRB, 2.82311E-03_JPRB, 3.33508E-03_JPRB, &
     & 3.93989E-03_JPRB, 4.65439E-03_JPRB, 5.49845E-03_JPRB, 6.49558E-03_JPRB/)
      KBO_MN2O( 5, :, 1) = (/ &
     & 1.45978E-04_JPRB, 1.75646E-04_JPRB, 2.11344E-04_JPRB, 2.54296E-04_JPRB, 3.05978E-04_JPRB, &
     & 3.68163E-04_JPRB, 4.42986E-04_JPRB, 5.33017E-04_JPRB, 6.41344E-04_JPRB, 7.71687E-04_JPRB, &
     & 9.28522E-04_JPRB, 1.11723E-03_JPRB, 1.34429E-03_JPRB, 1.61750E-03_JPRB, 1.94623E-03_JPRB, &
     & 2.34177E-03_JPRB, 2.81770E-03_JPRB, 3.39035E-03_JPRB, 4.07939E-03_JPRB/)
      KBO_MN2O( 1, :, 2) = (/ &
     & 1.94527E-04_JPRB, 2.38609E-04_JPRB, 2.92680E-04_JPRB, 3.59005E-04_JPRB, 4.40360E-04_JPRB, &
     & 5.40150E-04_JPRB, 6.62554E-04_JPRB, 8.12697E-04_JPRB, 9.96864E-04_JPRB, 1.22276E-03_JPRB, &
     & 1.49986E-03_JPRB, 1.83974E-03_JPRB, 2.25665E-03_JPRB, 2.76803E-03_JPRB, 3.39530E-03_JPRB, &
     & 4.16472E-03_JPRB, 5.10849E-03_JPRB, 6.26613E-03_JPRB, 7.68611E-03_JPRB/)
      KBO_MN2O( 2, :, 2) = (/ &
     & 7.49615E-04_JPRB, 8.82716E-04_JPRB, 1.03945E-03_JPRB, 1.22401E-03_JPRB, 1.44135E-03_JPRB, &
     & 1.69727E-03_JPRB, 1.99863E-03_JPRB, 2.35351E-03_JPRB, 2.77139E-03_JPRB, 3.26347E-03_JPRB, &
     & 3.84293E-03_JPRB, 4.52528E-03_JPRB, 5.32878E-03_JPRB, 6.27495E-03_JPRB, 7.38911E-03_JPRB, &
     & 8.70111E-03_JPRB, 1.02461E-02_JPRB, 1.20653E-02_JPRB, 1.42076E-02_JPRB/)
      KBO_MN2O( 3, :, 2) = (/ &
     & 1.39162E-03_JPRB, 1.59859E-03_JPRB, 1.83634E-03_JPRB, 2.10946E-03_JPRB, 2.42319E-03_JPRB, &
     & 2.78358E-03_JPRB, 3.19758E-03_JPRB, 3.67314E-03_JPRB, 4.21944E-03_JPRB, 4.84698E-03_JPRB, &
     & 5.56786E-03_JPRB, 6.39595E-03_JPRB, 7.34720E-03_JPRB, 8.43992E-03_JPRB, 9.69516E-03_JPRB, &
     & 1.11371E-02_JPRB, 1.27935E-02_JPRB, 1.46962E-02_JPRB, 1.68819E-02_JPRB/)
      KBO_MN2O( 4, :, 2) = (/ &
     & 2.42354E-03_JPRB, 2.73623E-03_JPRB, 3.08926E-03_JPRB, 3.48783E-03_JPRB, 3.93783E-03_JPRB, &
     & 4.44589E-03_JPRB, 5.01950E-03_JPRB, 5.66712E-03_JPRB, 6.39829E-03_JPRB, 7.22379E-03_JPRB, &
     & 8.15581E-03_JPRB, 9.20807E-03_JPRB, 1.03961E-02_JPRB, 1.17374E-02_JPRB, 1.32517E-02_JPRB, &
     & 1.49615E-02_JPRB, 1.68918E-02_JPRB, 1.90712E-02_JPRB, 2.15318E-02_JPRB/)
      KBO_MN2O( 5, :, 2) = (/ &
     & 1.39908E-03_JPRB, 1.59133E-03_JPRB, 1.81000E-03_JPRB, 2.05872E-03_JPRB, 2.34161E-03_JPRB, &
     & 2.66338E-03_JPRB, 3.02937E-03_JPRB, 3.44564E-03_JPRB, 3.91912E-03_JPRB, 4.45766E-03_JPRB, &
     & 5.07021E-03_JPRB, 5.76693E-03_JPRB, 6.55938E-03_JPRB, 7.46073E-03_JPRB, 8.48594E-03_JPRB, &
     & 9.65202E-03_JPRB, 1.09783E-02_JPRB, 1.24869E-02_JPRB, 1.42028E-02_JPRB/)
      KBO_MN2O( 1, :, 3) = (/ &
     & 8.74797E-03_JPRB, 9.66828E-03_JPRB, 1.06854E-02_JPRB, 1.18095E-02_JPRB, 1.30519E-02_JPRB, &
     & 1.44250E-02_JPRB, 1.59426E-02_JPRB, 1.76198E-02_JPRB, 1.94735E-02_JPRB, 2.15221E-02_JPRB, &
     & 2.37863E-02_JPRB, 2.62887E-02_JPRB, 2.90544E-02_JPRB, 3.21110E-02_JPRB, 3.54891E-02_JPRB, &
     & 3.92227E-02_JPRB, 4.33491E-02_JPRB, 4.79095E-02_JPRB, 5.29497E-02_JPRB/)
      KBO_MN2O( 2, :, 3) = (/ &
     & 1.43974E-02_JPRB, 1.56118E-02_JPRB, 1.69286E-02_JPRB, 1.83564E-02_JPRB, 1.99047E-02_JPRB, &
     & 2.15836E-02_JPRB, 2.34041E-02_JPRB, 2.53781E-02_JPRB, 2.75187E-02_JPRB, 2.98397E-02_JPRB, &
     & 3.23566E-02_JPRB, 3.50857E-02_JPRB, 3.80451E-02_JPRB, 4.12540E-02_JPRB, 4.47336E-02_JPRB, &
     & 4.85067E-02_JPRB, 5.25980E-02_JPRB, 5.70344E-02_JPRB, 6.18450E-02_JPRB/)
      KBO_MN2O( 3, :, 3) = (/ &
     & 1.83051E-02_JPRB, 1.96851E-02_JPRB, 2.11692E-02_JPRB, 2.27651E-02_JPRB, 2.44813E-02_JPRB, &
     & 2.63270E-02_JPRB, 2.83117E-02_JPRB, 3.04461E-02_JPRB, 3.27414E-02_JPRB, 3.52097E-02_JPRB, &
     & 3.78642E-02_JPRB, 4.07187E-02_JPRB, 4.37884E-02_JPRB, 4.70896E-02_JPRB, 5.06396E-02_JPRB, &
     & 5.44573E-02_JPRB, 5.85628E-02_JPRB, 6.29777E-02_JPRB, 6.77256E-02_JPRB/)
      KBO_MN2O( 4, :, 3) = (/ &
     & 2.81258E-02_JPRB, 2.97806E-02_JPRB, 3.15328E-02_JPRB, 3.33880E-02_JPRB, 3.53524E-02_JPRB, &
     & 3.74324E-02_JPRB, 3.96348E-02_JPRB, 4.19667E-02_JPRB, 4.44358E-02_JPRB, 4.70502E-02_JPRB, &
     & 4.98185E-02_JPRB, 5.27496E-02_JPRB, 5.58531E-02_JPRB, 5.91393E-02_JPRB, 6.26187E-02_JPRB, &
     & 6.63030E-02_JPRB, 7.02039E-02_JPRB, 7.43344E-02_JPRB, 7.87079E-02_JPRB/)
      KBO_MN2O( 5, :, 3) = (/ &
     & 8.82958E-03_JPRB, 9.53842E-03_JPRB, 1.03042E-02_JPRB, 1.11314E-02_JPRB, 1.20250E-02_JPRB, &
     & 1.29904E-02_JPRB, 1.40333E-02_JPRB, 1.51599E-02_JPRB, 1.63769E-02_JPRB, 1.76917E-02_JPRB, &
     & 1.91120E-02_JPRB, 2.06463E-02_JPRB, 2.23038E-02_JPRB, 2.40944E-02_JPRB, 2.60287E-02_JPRB, &
     & 2.81183E-02_JPRB, 3.03757E-02_JPRB, 3.28142E-02_JPRB, 3.54486E-02_JPRB/)
      KBO_MN2O( 1, :, 4) = (/ &
     & 1.18673E-01_JPRB, 1.22983E-01_JPRB, 1.27449E-01_JPRB, 1.32077E-01_JPRB, 1.36874E-01_JPRB, &
     & 1.41845E-01_JPRB, 1.46996E-01_JPRB, 1.52334E-01_JPRB, 1.57866E-01_JPRB, 1.63599E-01_JPRB, &
     & 1.69541E-01_JPRB, 1.75698E-01_JPRB, 1.82078E-01_JPRB, 1.88691E-01_JPRB, 1.95543E-01_JPRB, &
     & 2.02645E-01_JPRB, 2.10004E-01_JPRB, 2.17631E-01_JPRB, 2.25534E-01_JPRB/)
      KBO_MN2O( 2, :, 4) = (/ &
     & 1.32161E-01_JPRB, 1.36550E-01_JPRB, 1.41084E-01_JPRB, 1.45769E-01_JPRB, 1.50610E-01_JPRB, &
     & 1.55611E-01_JPRB, 1.60779E-01_JPRB, 1.66118E-01_JPRB, 1.71634E-01_JPRB, 1.77334E-01_JPRB, &
     & 1.83223E-01_JPRB, 1.89307E-01_JPRB, 1.95594E-01_JPRB, 2.02089E-01_JPRB, 2.08800E-01_JPRB, &
     & 2.15734E-01_JPRB, 2.22898E-01_JPRB, 2.30300E-01_JPRB, 2.37947E-01_JPRB/)
      KBO_MN2O( 3, :, 4) = (/ &
     & 1.44384E-01_JPRB, 1.48820E-01_JPRB, 1.53392E-01_JPRB, 1.58104E-01_JPRB, 1.62962E-01_JPRB, &
     & 1.67968E-01_JPRB, 1.73128E-01_JPRB, 1.78447E-01_JPRB, 1.83929E-01_JPRB, 1.89580E-01_JPRB, &
     & 1.95404E-01_JPRB, 2.01407E-01_JPRB, 2.07594E-01_JPRB, 2.13972E-01_JPRB, 2.20546E-01_JPRB, &
     & 2.27321E-01_JPRB, 2.34305E-01_JPRB, 2.41503E-01_JPRB, 2.48922E-01_JPRB/)
      KBO_MN2O( 4, :, 4) = (/ &
     & 1.58026E-01_JPRB, 1.62626E-01_JPRB, 1.67360E-01_JPRB, 1.72232E-01_JPRB, 1.77245E-01_JPRB, &
     & 1.82405E-01_JPRB, 1.87714E-01_JPRB, 1.93179E-01_JPRB, 1.98802E-01_JPRB, 2.04589E-01_JPRB, &
     & 2.10544E-01_JPRB, 2.16673E-01_JPRB, 2.22980E-01_JPRB, 2.29471E-01_JPRB, 2.36151E-01_JPRB, &
     & 2.43025E-01_JPRB, 2.50100E-01_JPRB, 2.57380E-01_JPRB, 2.64872E-01_JPRB/)
      KBO_MN2O( 5, :, 4) = (/ &
     & 4.04885E-02_JPRB, 4.16064E-02_JPRB, 4.27551E-02_JPRB, 4.39355E-02_JPRB, 4.51485E-02_JPRB, &
     & 4.63950E-02_JPRB, 4.76759E-02_JPRB, 4.89921E-02_JPRB, 5.03448E-02_JPRB, 5.17347E-02_JPRB, &
     & 5.31630E-02_JPRB, 5.46308E-02_JPRB, 5.61391E-02_JPRB, 5.76890E-02_JPRB, 5.92817E-02_JPRB, &
     & 6.09184E-02_JPRB, 6.26003E-02_JPRB, 6.43286E-02_JPRB, 6.61047E-02_JPRB/)
      KBO_MN2O( 1, :, 5) = (/ &
     & 3.97757E-01_JPRB, 4.01082E-01_JPRB, 4.04434E-01_JPRB, 4.07814E-01_JPRB, 4.11223E-01_JPRB, &
     & 4.14659E-01_JPRB, 4.18125E-01_JPRB, 4.21620E-01_JPRB, 4.25144E-01_JPRB, 4.28697E-01_JPRB, &
     & 4.32280E-01_JPRB, 4.35893E-01_JPRB, 4.39536E-01_JPRB, 4.43209E-01_JPRB, 4.46913E-01_JPRB, &
     & 4.50649E-01_JPRB, 4.54415E-01_JPRB, 4.58213E-01_JPRB, 4.62043E-01_JPRB/)
      KBO_MN2O( 2, :, 5) = (/ &
     & 3.99425E-01_JPRB, 4.02035E-01_JPRB, 4.04662E-01_JPRB, 4.07306E-01_JPRB, 4.09968E-01_JPRB, &
     & 4.12647E-01_JPRB, 4.15343E-01_JPRB, 4.18057E-01_JPRB, 4.20789E-01_JPRB, 4.23539E-01_JPRB, &
     & 4.26307E-01_JPRB, 4.29092E-01_JPRB, 4.31896E-01_JPRB, 4.34719E-01_JPRB, 4.37559E-01_JPRB, &
     & 4.40419E-01_JPRB, 4.43296E-01_JPRB, 4.46193E-01_JPRB, 4.49109E-01_JPRB/)
      KBO_MN2O( 3, :, 5) = (/ &
     & 4.00527E-01_JPRB, 4.02848E-01_JPRB, 4.05182E-01_JPRB, 4.07530E-01_JPRB, 4.09892E-01_JPRB, &
     & 4.12267E-01_JPRB, 4.14656E-01_JPRB, 4.17058E-01_JPRB, 4.19475E-01_JPRB, 4.21906E-01_JPRB, &
     & 4.24351E-01_JPRB, 4.26809E-01_JPRB, 4.29283E-01_JPRB, 4.31770E-01_JPRB, 4.34272E-01_JPRB, &
     & 4.36788E-01_JPRB, 4.39319E-01_JPRB, 4.41865E-01_JPRB, 4.44426E-01_JPRB/)
      KBO_MN2O( 4, :, 5) = (/ &
     & 4.11455E-01_JPRB, 4.13077E-01_JPRB, 4.14705E-01_JPRB, 4.16340E-01_JPRB, 4.17981E-01_JPRB, &
     & 4.19629E-01_JPRB, 4.21283E-01_JPRB, 4.22944E-01_JPRB, 4.24611E-01_JPRB, 4.26285E-01_JPRB, &
     & 4.27966E-01_JPRB, 4.29653E-01_JPRB, 4.31346E-01_JPRB, 4.33047E-01_JPRB, 4.34754E-01_JPRB, &
     & 4.36468E-01_JPRB, 4.38188E-01_JPRB, 4.39916E-01_JPRB, 4.41650E-01_JPRB/)
      KBO_MN2O( 5, :, 5) = (/ &
     & 8.65576E-02_JPRB, 8.83622E-02_JPRB, 9.02044E-02_JPRB, 9.20850E-02_JPRB, 9.40049E-02_JPRB, &
     & 9.59647E-02_JPRB, 9.79655E-02_JPRB, 1.00008E-01_JPRB, 1.02093E-01_JPRB, 1.04221E-01_JPRB, &
     & 1.06394E-01_JPRB, 1.08612E-01_JPRB, 1.10877E-01_JPRB, 1.13188E-01_JPRB, 1.15548E-01_JPRB, &
     & 1.17957E-01_JPRB, 1.20417E-01_JPRB, 1.22927E-01_JPRB, 1.25490E-01_JPRB/)
      KBO_MN2O( 1, :, 6) = (/ &
     & 6.98675E-01_JPRB, 7.00999E-01_JPRB, 7.03331E-01_JPRB, 7.05671E-01_JPRB, 7.08019E-01_JPRB, &
     & 7.10375E-01_JPRB, 7.12738E-01_JPRB, 7.15110E-01_JPRB, 7.17489E-01_JPRB, 7.19876E-01_JPRB, &
     & 7.22271E-01_JPRB, 7.24674E-01_JPRB, 7.27085E-01_JPRB, 7.29504E-01_JPRB, 7.31931E-01_JPRB, &
     & 7.34366E-01_JPRB, 7.36809E-01_JPRB, 7.39261E-01_JPRB, 7.41720E-01_JPRB/)
      KBO_MN2O( 2, :, 6) = (/ &
     & 6.98858E-01_JPRB, 7.01424E-01_JPRB, 7.03999E-01_JPRB, 7.06583E-01_JPRB, 7.09177E-01_JPRB, &
     & 7.11780E-01_JPRB, 7.14393E-01_JPRB, 7.17016E-01_JPRB, 7.19648E-01_JPRB, 7.22289E-01_JPRB, &
     & 7.24941E-01_JPRB, 7.27602E-01_JPRB, 7.30273E-01_JPRB, 7.32954E-01_JPRB, 7.35644E-01_JPRB, &
     & 7.38345E-01_JPRB, 7.41055E-01_JPRB, 7.43775E-01_JPRB, 7.46506E-01_JPRB/)
      KBO_MN2O( 3, :, 6) = (/ &
     & 7.08151E-01_JPRB, 7.10727E-01_JPRB, 7.13311E-01_JPRB, 7.15905E-01_JPRB, 7.18508E-01_JPRB, &
     & 7.21121E-01_JPRB, 7.23743E-01_JPRB, 7.26375E-01_JPRB, 7.29017E-01_JPRB, 7.31668E-01_JPRB, &
     & 7.34329E-01_JPRB, 7.36999E-01_JPRB, 7.39679E-01_JPRB, 7.42369E-01_JPRB, 7.45068E-01_JPRB, &
     & 7.47778E-01_JPRB, 7.50497E-01_JPRB, 7.53226E-01_JPRB, 7.55965E-01_JPRB/)
      KBO_MN2O( 4, :, 6) = (/ &
     & 7.22269E-01_JPRB, 7.24981E-01_JPRB, 7.27704E-01_JPRB, 7.30437E-01_JPRB, 7.33180E-01_JPRB, &
     & 7.35933E-01_JPRB, 7.38697E-01_JPRB, 7.41471E-01_JPRB, 7.44256E-01_JPRB, 7.47051E-01_JPRB, &
     & 7.49856E-01_JPRB, 7.52672E-01_JPRB, 7.55499E-01_JPRB, 7.58336E-01_JPRB, 7.61184E-01_JPRB, &
     & 7.64043E-01_JPRB, 7.66912E-01_JPRB, 7.69792E-01_JPRB, 7.72683E-01_JPRB/)
      KBO_MN2O( 5, :, 6) = (/ &
     & 1.75877E-01_JPRB, 1.78578E-01_JPRB, 1.81321E-01_JPRB, 1.84107E-01_JPRB, 1.86935E-01_JPRB, &
     & 1.89806E-01_JPRB, 1.92722E-01_JPRB, 1.95682E-01_JPRB, 1.98688E-01_JPRB, 2.01740E-01_JPRB, &
     & 2.04839E-01_JPRB, 2.07986E-01_JPRB, 2.11181E-01_JPRB, 2.14425E-01_JPRB, 2.17719E-01_JPRB, &
     & 2.21063E-01_JPRB, 2.24459E-01_JPRB, 2.27907E-01_JPRB, 2.31408E-01_JPRB/)
      KBO_MN2O( 1, :, 7) = (/ &
     & 1.82985E+00_JPRB, 1.83684E+00_JPRB, 1.84386E+00_JPRB, 1.85091E+00_JPRB, 1.85798E+00_JPRB, &
     & 1.86508E+00_JPRB, 1.87221E+00_JPRB, 1.87937E+00_JPRB, 1.88655E+00_JPRB, 1.89376E+00_JPRB, &
     & 1.90100E+00_JPRB, 1.90827E+00_JPRB, 1.91556E+00_JPRB, 1.92288E+00_JPRB, 1.93023E+00_JPRB, &
     & 1.93761E+00_JPRB, 1.94502E+00_JPRB, 1.95245E+00_JPRB, 1.95991E+00_JPRB/)
      KBO_MN2O( 2, :, 7) = (/ &
     & 1.83229E+00_JPRB, 1.83943E+00_JPRB, 1.84659E+00_JPRB, 1.85379E+00_JPRB, 1.86100E+00_JPRB, &
     & 1.86825E+00_JPRB, 1.87553E+00_JPRB, 1.88283E+00_JPRB, 1.89016E+00_JPRB, 1.89753E+00_JPRB, &
     & 1.90492E+00_JPRB, 1.91233E+00_JPRB, 1.91978E+00_JPRB, 1.92726E+00_JPRB, 1.93476E+00_JPRB, &
     & 1.94230E+00_JPRB, 1.94986E+00_JPRB, 1.95746E+00_JPRB, 1.96508E+00_JPRB/)
      KBO_MN2O( 3, :, 7) = (/ &
     & 1.84946E+00_JPRB, 1.85707E+00_JPRB, 1.86471E+00_JPRB, 1.87238E+00_JPRB, 1.88008E+00_JPRB, &
     & 1.88781E+00_JPRB, 1.89558E+00_JPRB, 1.90338E+00_JPRB, 1.91120E+00_JPRB, 1.91907E+00_JPRB, &
     & 1.92696E+00_JPRB, 1.93489E+00_JPRB, 1.94285E+00_JPRB, 1.95084E+00_JPRB, 1.95886E+00_JPRB, &
     & 1.96692E+00_JPRB, 1.97501E+00_JPRB, 1.98313E+00_JPRB, 1.99129E+00_JPRB/)
      KBO_MN2O( 4, :, 7) = (/ &
     & 1.88354E+00_JPRB, 1.89167E+00_JPRB, 1.89983E+00_JPRB, 1.90803E+00_JPRB, 1.91626E+00_JPRB, &
     & 1.92453E+00_JPRB, 1.93283E+00_JPRB, 1.94117E+00_JPRB, 1.94955E+00_JPRB, 1.95796E+00_JPRB, &
     & 1.96641E+00_JPRB, 1.97489E+00_JPRB, 1.98341E+00_JPRB, 1.99197E+00_JPRB, 2.00056E+00_JPRB, &
     & 2.00920E+00_JPRB, 2.01787E+00_JPRB, 2.02657E+00_JPRB, 2.03532E+00_JPRB/)
      KBO_MN2O( 5, :, 7) = (/ &
     & 3.35154E-01_JPRB, 3.43258E-01_JPRB, 3.51557E-01_JPRB, 3.60058E-01_JPRB, 3.68764E-01_JPRB, &
     & 3.77680E-01_JPRB, 3.86812E-01_JPRB, 3.96164E-01_JPRB, 4.05743E-01_JPRB, 4.15553E-01_JPRB, &
     & 4.25601E-01_JPRB, 4.35892E-01_JPRB, 4.46431E-01_JPRB, 4.57225E-01_JPRB, 4.68280E-01_JPRB, &
     & 4.79603E-01_JPRB, 4.91199E-01_JPRB, 5.03075E-01_JPRB, 5.15239E-01_JPRB/)
      KBO_MN2O( 1, :, 8) = (/ &
     & 4.46843E+00_JPRB, 4.49793E+00_JPRB, 4.52763E+00_JPRB, 4.55752E+00_JPRB, 4.58761E+00_JPRB, &
     & 4.61790E+00_JPRB, 4.64839E+00_JPRB, 4.67908E+00_JPRB, 4.70997E+00_JPRB, 4.74106E+00_JPRB, &
     & 4.77236E+00_JPRB, 4.80387E+00_JPRB, 4.83559E+00_JPRB, 4.86751E+00_JPRB, 4.89965E+00_JPRB, &
     & 4.93200E+00_JPRB, 4.96456E+00_JPRB, 4.99733E+00_JPRB, 5.03033E+00_JPRB/)
      KBO_MN2O( 2, :, 8) = (/ &
     & 4.44347E+00_JPRB, 4.47278E+00_JPRB, 4.50228E+00_JPRB, 4.53198E+00_JPRB, 4.56188E+00_JPRB, &
     & 4.59197E+00_JPRB, 4.62227E+00_JPRB, 4.65276E+00_JPRB, 4.68345E+00_JPRB, 4.71435E+00_JPRB, &
     & 4.74544E+00_JPRB, 4.77675E+00_JPRB, 4.80826E+00_JPRB, 4.83998E+00_JPRB, 4.87191E+00_JPRB, &
     & 4.90405E+00_JPRB, 4.93640E+00_JPRB, 4.96896E+00_JPRB, 5.00174E+00_JPRB/)
      KBO_MN2O( 3, :, 8) = (/ &
     & 4.43138E+00_JPRB, 4.46017E+00_JPRB, 4.48916E+00_JPRB, 4.51834E+00_JPRB, 4.54770E+00_JPRB, &
     & 4.57725E+00_JPRB, 4.60700E+00_JPRB, 4.63694E+00_JPRB, 4.66708E+00_JPRB, 4.69741E+00_JPRB, &
     & 4.72793E+00_JPRB, 4.75866E+00_JPRB, 4.78958E+00_JPRB, 4.82071E+00_JPRB, 4.85204E+00_JPRB, &
     & 4.88357E+00_JPRB, 4.91531E+00_JPRB, 4.94725E+00_JPRB, 4.97941E+00_JPRB/)
      KBO_MN2O( 4, :, 8) = (/ &
     & 4.47437E+00_JPRB, 4.50396E+00_JPRB, 4.53375E+00_JPRB, 4.56374E+00_JPRB, 4.59392E+00_JPRB, &
     & 4.62431E+00_JPRB, 4.65490E+00_JPRB, 4.68569E+00_JPRB, 4.71668E+00_JPRB, 4.74788E+00_JPRB, &
     & 4.77928E+00_JPRB, 4.81089E+00_JPRB, 4.84271E+00_JPRB, 4.87474E+00_JPRB, 4.90698E+00_JPRB, &
     & 4.93944E+00_JPRB, 4.97211E+00_JPRB, 5.00500E+00_JPRB, 5.03810E+00_JPRB/)
      KBO_MN2O( 5, :, 8) = (/ &
     & 8.82838E-01_JPRB, 8.92257E-01_JPRB, 9.01777E-01_JPRB, 9.11398E-01_JPRB, 9.21122E-01_JPRB, &
     & 9.30950E-01_JPRB, 9.40883E-01_JPRB, 9.50921E-01_JPRB, 9.61067E-01_JPRB, 9.71321E-01_JPRB, &
     & 9.81685E-01_JPRB, 9.92159E-01_JPRB, 1.00274E+00_JPRB, 1.01344E+00_JPRB, 1.02426E+00_JPRB, &
     & 1.03518E+00_JPRB, 1.04623E+00_JPRB, 1.05739E+00_JPRB, 1.06867E+00_JPRB/)
      KBO_MN2O( 1, :, 9) = (/ &
     & 7.92826E+00_JPRB, 7.83168E+00_JPRB, 7.73628E+00_JPRB, 7.64204E+00_JPRB, 7.54895E+00_JPRB, &
     & 7.45699E+00_JPRB, 7.36616E+00_JPRB, 7.27643E+00_JPRB, 7.18779E+00_JPRB, 7.10023E+00_JPRB, &
     & 7.01374E+00_JPRB, 6.92831E+00_JPRB, 6.84391E+00_JPRB, 6.76054E+00_JPRB, 6.67819E+00_JPRB, &
     & 6.59684E+00_JPRB, 6.51648E+00_JPRB, 6.43710E+00_JPRB, 6.35869E+00_JPRB/)
      KBO_MN2O( 2, :, 9) = (/ &
     & 7.89244E+00_JPRB, 7.79570E+00_JPRB, 7.70014E+00_JPRB, 7.60576E+00_JPRB, 7.51253E+00_JPRB, &
     & 7.42045E+00_JPRB, 7.32949E+00_JPRB, 7.23965E+00_JPRB, 7.15091E+00_JPRB, 7.06325E+00_JPRB, &
     & 6.97668E+00_JPRB, 6.89116E+00_JPRB, 6.80669E+00_JPRB, 6.72326E+00_JPRB, 6.64085E+00_JPRB, &
     & 6.55945E+00_JPRB, 6.47904E+00_JPRB, 6.39963E+00_JPRB, 6.32118E+00_JPRB/)
      KBO_MN2O( 3, :, 9) = (/ &
     & 7.79799E+00_JPRB, 7.70076E+00_JPRB, 7.60474E+00_JPRB, 7.50991E+00_JPRB, 7.41627E+00_JPRB, &
     & 7.32379E+00_JPRB, 7.23247E+00_JPRB, 7.14229E+00_JPRB, 7.05323E+00_JPRB, 6.96528E+00_JPRB, &
     & 6.87843E+00_JPRB, 6.79266E+00_JPRB, 6.70797E+00_JPRB, 6.62432E+00_JPRB, 6.54172E+00_JPRB, &
     & 6.46015E+00_JPRB, 6.37960E+00_JPRB, 6.30005E+00_JPRB, 6.22150E+00_JPRB/)
      KBO_MN2O( 4, :, 9) = (/ &
     & 7.53750E+00_JPRB, 7.43715E+00_JPRB, 7.33814E+00_JPRB, 7.24045E+00_JPRB, 7.14406E+00_JPRB, &
     & 7.04895E+00_JPRB, 6.95510E+00_JPRB, 6.86251E+00_JPRB, 6.77115E+00_JPRB, 6.68101E+00_JPRB, &
     & 6.59206E+00_JPRB, 6.50430E+00_JPRB, 6.41771E+00_JPRB, 6.33227E+00_JPRB, 6.24797E+00_JPRB, &
     & 6.16479E+00_JPRB, 6.08272E+00_JPRB, 6.00174E+00_JPRB, 5.92184E+00_JPRB/)
      KBO_MN2O( 5, :, 9) = (/ &
     & 5.06319E+00_JPRB, 5.08595E+00_JPRB, 5.10881E+00_JPRB, 5.13177E+00_JPRB, 5.15483E+00_JPRB, &
     & 5.17800E+00_JPRB, 5.20127E+00_JPRB, 5.22464E+00_JPRB, 5.24813E+00_JPRB, 5.27171E+00_JPRB, &
     & 5.29540E+00_JPRB, 5.31920E+00_JPRB, 5.34311E+00_JPRB, 5.36712E+00_JPRB, 5.39124E+00_JPRB, &
     & 5.41547E+00_JPRB, 5.43981E+00_JPRB, 5.46426E+00_JPRB, 5.48882E+00_JPRB/)
      KBO_MN2O( 1, :,10) = (/ &
     & 1.05265E+00_JPRB, 1.03986E+00_JPRB, 1.02723E+00_JPRB, 1.01475E+00_JPRB, 1.00243E+00_JPRB, &
     & 9.90250E-01_JPRB, 9.78220E-01_JPRB, 9.66338E-01_JPRB, 9.54599E-01_JPRB, 9.43003E-01_JPRB, &
     & 9.31548E-01_JPRB, 9.20232E-01_JPRB, 9.09054E-01_JPRB, 8.98011E-01_JPRB, 8.87102E-01_JPRB, &
     & 8.76326E-01_JPRB, 8.65681E-01_JPRB, 8.55165E-01_JPRB, 8.44777E-01_JPRB/)
      KBO_MN2O( 2, :,10) = (/ &
     & 1.05246E+00_JPRB, 1.03973E+00_JPRB, 1.02714E+00_JPRB, 1.01471E+00_JPRB, 1.00243E+00_JPRB, &
     & 9.90303E-01_JPRB, 9.78319E-01_JPRB, 9.66480E-01_JPRB, 9.54784E-01_JPRB, 9.43230E-01_JPRB, &
     & 9.31815E-01_JPRB, 9.20539E-01_JPRB, 9.09399E-01_JPRB, 8.98394E-01_JPRB, 8.87522E-01_JPRB, &
     & 8.76782E-01_JPRB, 8.66171E-01_JPRB, 8.55690E-01_JPRB, 8.45335E-01_JPRB/)
      KBO_MN2O( 3, :,10) = (/ &
     & 1.05236E+00_JPRB, 1.03963E+00_JPRB, 1.02704E+00_JPRB, 1.01461E+00_JPRB, 1.00233E+00_JPRB, &
     & 9.90203E-01_JPRB, 9.78219E-01_JPRB, 9.66380E-01_JPRB, 9.54684E-01_JPRB, 9.43130E-01_JPRB, &
     & 9.31715E-01_JPRB, 9.20439E-01_JPRB, 9.09300E-01_JPRB, 8.98295E-01_JPRB, 8.87423E-01_JPRB, &
     & 8.76683E-01_JPRB, 8.66073E-01_JPRB, 8.55591E-01_JPRB, 8.45236E-01_JPRB/)
      KBO_MN2O( 4, :,10) = (/ &
     & 9.30836E-01_JPRB, 9.21099E-01_JPRB, 9.11464E-01_JPRB, 9.01930E-01_JPRB, 8.92495E-01_JPRB, &
     & 8.83159E-01_JPRB, 8.73921E-01_JPRB, 8.64779E-01_JPRB, 8.55733E-01_JPRB, 8.46781E-01_JPRB, &
     & 8.37923E-01_JPRB, 8.29158E-01_JPRB, 8.20485E-01_JPRB, 8.11902E-01_JPRB, 8.03409E-01_JPRB, &
     & 7.95005E-01_JPRB, 7.86689E-01_JPRB, 7.78460E-01_JPRB, 7.70316E-01_JPRB/)
      KBO_MN2O( 5, :,10) = (/ &
     & 1.65786E+01_JPRB, 1.66541E+01_JPRB, 1.67299E+01_JPRB, 1.68062E+01_JPRB, 1.68827E+01_JPRB, &
     & 1.69596E+01_JPRB, 1.70369E+01_JPRB, 1.71145E+01_JPRB, 1.71925E+01_JPRB, 1.72708E+01_JPRB, &
     & 1.73495E+01_JPRB, 1.74285E+01_JPRB, 1.75079E+01_JPRB, 1.75877E+01_JPRB, 1.76678E+01_JPRB, &
     & 1.77483E+01_JPRB, 1.78291E+01_JPRB, 1.79103E+01_JPRB, 1.79919E+01_JPRB/)
      KBO_MN2O( 1, :,11) = (/ &
     & 1.74239E-01_JPRB, 1.77873E-01_JPRB, 1.81583E-01_JPRB, 1.85370E-01_JPRB, 1.89236E-01_JPRB, &
     & 1.93182E-01_JPRB, 1.97211E-01_JPRB, 2.01324E-01_JPRB, 2.05523E-01_JPRB, 2.09809E-01_JPRB, &
     & 2.14185E-01_JPRB, 2.18652E-01_JPRB, 2.23212E-01_JPRB, 2.27867E-01_JPRB, 2.32620E-01_JPRB, &
     & 2.37471E-01_JPRB, 2.42424E-01_JPRB, 2.47479E-01_JPRB, 2.52641E-01_JPRB/)
      KBO_MN2O( 2, :,11) = (/ &
     & 1.74114E-01_JPRB, 1.77756E-01_JPRB, 1.81475E-01_JPRB, 1.85271E-01_JPRB, 1.89147E-01_JPRB, &
     & 1.93104E-01_JPRB, 1.97144E-01_JPRB, 2.01268E-01_JPRB, 2.05479E-01_JPRB, 2.09778E-01_JPRB, &
     & 2.14166E-01_JPRB, 2.18647E-01_JPRB, 2.23221E-01_JPRB, 2.27890E-01_JPRB, 2.32658E-01_JPRB, &
     & 2.37525E-01_JPRB, 2.42494E-01_JPRB, 2.47567E-01_JPRB, 2.52746E-01_JPRB/)
      KBO_MN2O( 3, :,11) = (/ &
     & 1.74142E-01_JPRB, 1.77780E-01_JPRB, 1.81494E-01_JPRB, 1.85286E-01_JPRB, 1.89157E-01_JPRB, &
     & 1.93108E-01_JPRB, 1.97143E-01_JPRB, 2.01261E-01_JPRB, 2.05466E-01_JPRB, 2.09759E-01_JPRB, &
     & 2.14141E-01_JPRB, 2.18615E-01_JPRB, 2.23182E-01_JPRB, 2.27845E-01_JPRB, 2.32605E-01_JPRB, &
     & 2.37464E-01_JPRB, 2.42425E-01_JPRB, 2.47490E-01_JPRB, 2.52661E-01_JPRB/)
      KBO_MN2O( 4, :,11) = (/ &
     & 1.74074E-01_JPRB, 1.77716E-01_JPRB, 1.81435E-01_JPRB, 1.85231E-01_JPRB, 1.89107E-01_JPRB, &
     & 1.93064E-01_JPRB, 1.97104E-01_JPRB, 2.01229E-01_JPRB, 2.05439E-01_JPRB, 2.09738E-01_JPRB, &
     & 2.14127E-01_JPRB, 2.18607E-01_JPRB, 2.23181E-01_JPRB, 2.27852E-01_JPRB, 2.32619E-01_JPRB, &
     & 2.37487E-01_JPRB, 2.42456E-01_JPRB, 2.47529E-01_JPRB, 2.52709E-01_JPRB/)
      KBO_MN2O( 5, :,11) = (/ &
     & 2.31905E+01_JPRB, 2.33011E+01_JPRB, 2.34123E+01_JPRB, 2.35240E+01_JPRB, 2.36362E+01_JPRB, &
     & 2.37489E+01_JPRB, 2.38622E+01_JPRB, 2.39760E+01_JPRB, 2.40904E+01_JPRB, 2.42053E+01_JPRB, &
     & 2.43208E+01_JPRB, 2.44368E+01_JPRB, 2.45533E+01_JPRB, 2.46705E+01_JPRB, 2.47881E+01_JPRB, &
     & 2.49064E+01_JPRB, 2.50252E+01_JPRB, 2.51446E+01_JPRB, 2.52645E+01_JPRB/)
      KBO_MN2O( 1, :,12) = (/ &
     & 1.60269E-01_JPRB, 1.62873E-01_JPRB, 1.65519E-01_JPRB, 1.68208E-01_JPRB, 1.70940E-01_JPRB, &
     & 1.73717E-01_JPRB, 1.76540E-01_JPRB, 1.79408E-01_JPRB, 1.82322E-01_JPRB, 1.85284E-01_JPRB, &
     & 1.88295E-01_JPRB, 1.91354E-01_JPRB, 1.94462E-01_JPRB, 1.97622E-01_JPRB, 2.00832E-01_JPRB, &
     & 2.04095E-01_JPRB, 2.07411E-01_JPRB, 2.10780E-01_JPRB, 2.14205E-01_JPRB/)
      KBO_MN2O( 2, :,12) = (/ &
     & 1.60497E-01_JPRB, 1.63096E-01_JPRB, 1.65738E-01_JPRB, 1.68422E-01_JPRB, 1.71150E-01_JPRB, &
     & 1.73922E-01_JPRB, 1.76738E-01_JPRB, 1.79601E-01_JPRB, 1.82510E-01_JPRB, 1.85466E-01_JPRB, &
     & 1.88469E-01_JPRB, 1.91522E-01_JPRB, 1.94624E-01_JPRB, 1.97776E-01_JPRB, 2.00979E-01_JPRB, &
     & 2.04234E-01_JPRB, 2.07542E-01_JPRB, 2.10903E-01_JPRB, 2.14319E-01_JPRB/)
      KBO_MN2O( 3, :,12) = (/ &
     & 1.60407E-01_JPRB, 1.63006E-01_JPRB, 1.65648E-01_JPRB, 1.68332E-01_JPRB, 1.71060E-01_JPRB, &
     & 1.73832E-01_JPRB, 1.76649E-01_JPRB, 1.79511E-01_JPRB, 1.82420E-01_JPRB, 1.85376E-01_JPRB, &
     & 1.88380E-01_JPRB, 1.91433E-01_JPRB, 1.94535E-01_JPRB, 1.97687E-01_JPRB, 2.00891E-01_JPRB, &
     & 2.04146E-01_JPRB, 2.07454E-01_JPRB, 2.10816E-01_JPRB, 2.14232E-01_JPRB/)
      KBO_MN2O( 4, :,12) = (/ &
     & 1.60475E-01_JPRB, 1.63070E-01_JPRB, 1.65706E-01_JPRB, 1.68386E-01_JPRB, 1.71109E-01_JPRB, &
     & 1.73876E-01_JPRB, 1.76687E-01_JPRB, 1.79544E-01_JPRB, 1.82448E-01_JPRB, 1.85398E-01_JPRB, &
     & 1.88396E-01_JPRB, 1.91442E-01_JPRB, 1.94538E-01_JPRB, 1.97684E-01_JPRB, 2.00881E-01_JPRB, &
     & 2.04129E-01_JPRB, 2.07430E-01_JPRB, 2.10784E-01_JPRB, 2.14192E-01_JPRB/)
      KBO_MN2O( 5, :,12) = (/ &
     & 3.25743E+01_JPRB, 3.27992E+01_JPRB, 3.30256E+01_JPRB, 3.32536E+01_JPRB, 3.34832E+01_JPRB, &
     & 3.37143E+01_JPRB, 3.39471E+01_JPRB, 3.41815E+01_JPRB, 3.44174E+01_JPRB, 3.46550E+01_JPRB, &
     & 3.48943E+01_JPRB, 3.51352E+01_JPRB, 3.53778E+01_JPRB, 3.56220E+01_JPRB, 3.58679E+01_JPRB, &
     & 3.61156E+01_JPRB, 3.63649E+01_JPRB, 3.66159E+01_JPRB, 3.68687E+01_JPRB/)
      KBO_MN2O( 1, :,13) = (/ &
     & 2.01846E-01_JPRB, 2.03110E-01_JPRB, 2.04381E-01_JPRB, 2.05660E-01_JPRB, 2.06947E-01_JPRB, &
     & 2.08242E-01_JPRB, 2.09546E-01_JPRB, 2.10857E-01_JPRB, 2.12177E-01_JPRB, 2.13505E-01_JPRB, &
     & 2.14841E-01_JPRB, 2.16186E-01_JPRB, 2.17539E-01_JPRB, 2.18900E-01_JPRB, 2.20270E-01_JPRB, &
     & 2.21649E-01_JPRB, 2.23036E-01_JPRB, 2.24432E-01_JPRB, 2.25837E-01_JPRB/)
      KBO_MN2O( 2, :,13) = (/ &
     & 2.01756E-01_JPRB, 2.03020E-01_JPRB, 2.04291E-01_JPRB, 2.05570E-01_JPRB, 2.06857E-01_JPRB, &
     & 2.08152E-01_JPRB, 2.09456E-01_JPRB, 2.10767E-01_JPRB, 2.12087E-01_JPRB, 2.13415E-01_JPRB, &
     & 2.14751E-01_JPRB, 2.16096E-01_JPRB, 2.17449E-01_JPRB, 2.18810E-01_JPRB, 2.20181E-01_JPRB, &
     & 2.21559E-01_JPRB, 2.22946E-01_JPRB, 2.24342E-01_JPRB, 2.25747E-01_JPRB/)
      KBO_MN2O( 3, :,13) = (/ &
     & 2.01836E-01_JPRB, 2.03100E-01_JPRB, 2.04371E-01_JPRB, 2.05650E-01_JPRB, 2.06937E-01_JPRB, &
     & 2.08232E-01_JPRB, 2.09536E-01_JPRB, 2.10847E-01_JPRB, 2.12167E-01_JPRB, 2.13495E-01_JPRB, &
     & 2.14831E-01_JPRB, 2.16176E-01_JPRB, 2.17529E-01_JPRB, 2.18890E-01_JPRB, 2.20260E-01_JPRB, &
     & 2.21639E-01_JPRB, 2.23026E-01_JPRB, 2.24422E-01_JPRB, 2.25827E-01_JPRB/)
      KBO_MN2O( 4, :,13) = (/ &
     & 2.01845E-01_JPRB, 2.03103E-01_JPRB, 2.04370E-01_JPRB, 2.05644E-01_JPRB, 2.06926E-01_JPRB, &
     & 2.08217E-01_JPRB, 2.09515E-01_JPRB, 2.10822E-01_JPRB, 2.12136E-01_JPRB, 2.13459E-01_JPRB, &
     & 2.14790E-01_JPRB, 2.16129E-01_JPRB, 2.17477E-01_JPRB, 2.18833E-01_JPRB, 2.20198E-01_JPRB, &
     & 2.21571E-01_JPRB, 2.22952E-01_JPRB, 2.24343E-01_JPRB, 2.25741E-01_JPRB/)
      KBO_MN2O( 5, :,13) = (/ &
     & 5.34154E+01_JPRB, 5.31954E+01_JPRB, 5.29763E+01_JPRB, 5.27582E+01_JPRB, 5.25409E+01_JPRB, &
     & 5.23245E+01_JPRB, 5.21090E+01_JPRB, 5.18943E+01_JPRB, 5.16806E+01_JPRB, 5.14677E+01_JPRB, &
     & 5.12558E+01_JPRB, 5.10446E+01_JPRB, 5.08344E+01_JPRB, 5.06250E+01_JPRB, 5.04165E+01_JPRB, &
     & 5.02089E+01_JPRB, 5.00021E+01_JPRB, 4.97961E+01_JPRB, 4.95910E+01_JPRB/)
      KBO_MN2O( 1, :,14) = (/ &
     & 2.87818E-02_JPRB, 3.17868E-02_JPRB, 3.51056E-02_JPRB, 3.87708E-02_JPRB, 4.28187E-02_JPRB, &
     & 4.72893E-02_JPRB, 5.22266E-02_JPRB, 5.76794E-02_JPRB, 6.37015E-02_JPRB, 7.03523E-02_JPRB, &
     & 7.76976E-02_JPRB, 8.58097E-02_JPRB, 9.47688E-02_JPRB, 1.04663E-01_JPRB, 1.15591E-01_JPRB, &
     & 1.27659E-01_JPRB, 1.40988E-01_JPRB, 1.55708E-01_JPRB, 1.71965E-01_JPRB/)
      KBO_MN2O( 2, :,14) = (/ &
     & 2.88500E-02_JPRB, 3.18494E-02_JPRB, 3.51606E-02_JPRB, 3.88161E-02_JPRB, 4.28517E-02_JPRB, &
     & 4.73068E-02_JPRB, 5.22251E-02_JPRB, 5.76547E-02_JPRB, 6.36488E-02_JPRB, 7.02661E-02_JPRB, &
     & 7.75714E-02_JPRB, 8.56362E-02_JPRB, 9.45395E-02_JPRB, 1.04368E-01_JPRB, 1.15219E-01_JPRB, &
     & 1.27198E-01_JPRB, 1.40422E-01_JPRB, 1.55021E-01_JPRB, 1.71138E-01_JPRB/)
      KBO_MN2O( 3, :,14) = (/ &
     & 2.88036E-02_JPRB, 3.18109E-02_JPRB, 3.51322E-02_JPRB, 3.88002E-02_JPRB, 4.28512E-02_JPRB, &
     & 4.73252E-02_JPRB, 5.22663E-02_JPRB, 5.77232E-02_JPRB, 6.37499E-02_JPRB, 7.04058E-02_JPRB, &
     & 7.77567E-02_JPRB, 8.58751E-02_JPRB, 9.48410E-02_JPRB, 1.04743E-01_JPRB, 1.15679E-01_JPRB, &
     & 1.27757E-01_JPRB, 1.41095E-01_JPRB, 1.55827E-01_JPRB, 1.72096E-01_JPRB/)
      KBO_MN2O( 4, :,14) = (/ &
     & 2.87750E-02_JPRB, 3.17783E-02_JPRB, 3.50951E-02_JPRB, 3.87580E-02_JPRB, 4.28033E-02_JPRB, &
     & 4.72708E-02_JPRB, 5.22046E-02_JPRB, 5.76533E-02_JPRB, 6.36707E-02_JPRB, 7.03162E-02_JPRB, &
     & 7.76553E-02_JPRB, 8.57604E-02_JPRB, 9.47114E-02_JPRB, 1.04597E-01_JPRB, 1.15514E-01_JPRB, &
     & 1.27570E-01_JPRB, 1.40885E-01_JPRB, 1.55589E-01_JPRB, 1.71829E-01_JPRB/)
      KBO_MN2O( 5, :,14) = (/ &
     & 1.11848E+02_JPRB, 1.09489E+02_JPRB, 1.07179E+02_JPRB, 1.04918E+02_JPRB, 1.02705E+02_JPRB, &
     & 1.00538E+02_JPRB, 9.84175E+01_JPRB, 9.63414E+01_JPRB, 9.43091E+01_JPRB, 9.23196E+01_JPRB, &
     & 9.03722E+01_JPRB, 8.84658E+01_JPRB, 8.65996E+01_JPRB, 8.47728E+01_JPRB, 8.29845E+01_JPRB, &
     & 8.12339E+01_JPRB, 7.95203E+01_JPRB, 7.78428E+01_JPRB, 7.62007E+01_JPRB/)
      KBO_MN2O( 1, :,15) = (/ &
     & 1.52234E-02_JPRB, 1.69256E-02_JPRB, 1.88181E-02_JPRB, 2.09222E-02_JPRB, 2.32617E-02_JPRB, &
     & 2.58626E-02_JPRB, 2.87545E-02_JPRB, 3.19696E-02_JPRB, 3.55443E-02_JPRB, 3.95187E-02_JPRB, &
     & 4.39374E-02_JPRB, 4.88503E-02_JPRB, 5.43124E-02_JPRB, 6.03854E-02_JPRB, 6.71373E-02_JPRB, &
     & 7.46443E-02_JPRB, 8.29906E-02_JPRB, 9.22701E-02_JPRB, 1.02587E-01_JPRB/)
      KBO_MN2O( 2, :,15) = (/ &
     & 1.52234E-02_JPRB, 1.69256E-02_JPRB, 1.88181E-02_JPRB, 2.09222E-02_JPRB, 2.32617E-02_JPRB, &
     & 2.58626E-02_JPRB, 2.87545E-02_JPRB, 3.19696E-02_JPRB, 3.55443E-02_JPRB, 3.95187E-02_JPRB, &
     & 4.39374E-02_JPRB, 4.88503E-02_JPRB, 5.43124E-02_JPRB, 6.03854E-02_JPRB, 6.71373E-02_JPRB, &
     & 7.46443E-02_JPRB, 8.29906E-02_JPRB, 9.22701E-02_JPRB, 1.02587E-01_JPRB/)
      KBO_MN2O( 3, :,15) = (/ &
     & 1.52076E-02_JPRB, 1.69049E-02_JPRB, 1.87916E-02_JPRB, 2.08890E-02_JPRB, 2.32203E-02_JPRB, &
     & 2.58119E-02_JPRB, 2.86928E-02_JPRB, 3.18951E-02_JPRB, 3.54549E-02_JPRB, 3.94120E-02_JPRB, &
     & 4.38107E-02_JPRB, 4.87003E-02_JPRB, 5.41357E-02_JPRB, 6.01777E-02_JPRB, 6.68940E-02_JPRB, &
     & 7.43600E-02_JPRB, 8.26593E-02_JPRB, 9.18847E-02_JPRB, 1.02140E-01_JPRB/)
      KBO_MN2O( 4, :,15) = (/ &
     & 1.52422E-02_JPRB, 1.69488E-02_JPRB, 1.88464E-02_JPRB, 2.09565E-02_JPRB, 2.33028E-02_JPRB, &
     & 2.59118E-02_JPRB, 2.88129E-02_JPRB, 3.20389E-02_JPRB, 3.56260E-02_JPRB, 3.96148E-02_JPRB, &
     & 4.40501E-02_JPRB, 4.89821E-02_JPRB, 5.44662E-02_JPRB, 6.05643E-02_JPRB, 6.73452E-02_JPRB, &
     & 7.48853E-02_JPRB, 8.32696E-02_JPRB, 9.25927E-02_JPRB, 1.02959E-01_JPRB/)
      KBO_MN2O( 5, :,15) = (/ &
     & 6.94782E+01_JPRB, 6.73469E+01_JPRB, 6.52810E+01_JPRB, 6.32785E+01_JPRB, 6.13373E+01_JPRB, &
     & 5.94558E+01_JPRB, 5.76319E+01_JPRB, 5.58640E+01_JPRB, 5.41503E+01_JPRB, 5.24892E+01_JPRB, &
     & 5.08791E+01_JPRB, 4.93183E+01_JPRB, 4.78055E+01_JPRB, 4.63390E+01_JPRB, 4.49175E+01_JPRB, &
     & 4.35396E+01_JPRB, 4.22040E+01_JPRB, 4.09094E+01_JPRB, 3.96544E+01_JPRB/)
      KBO_MN2O( 1, :,16) = (/ &
     & 1.08257E-02_JPRB, 1.15188E-02_JPRB, 1.22563E-02_JPRB, 1.30410E-02_JPRB, 1.38759E-02_JPRB, &
     & 1.47643E-02_JPRB, 1.57096E-02_JPRB, 1.67154E-02_JPRB, 1.77857E-02_JPRB, 1.89244E-02_JPRB, &
     & 2.01360E-02_JPRB, 2.14252E-02_JPRB, 2.27970E-02_JPRB, 2.42565E-02_JPRB, 2.58096E-02_JPRB, &
     & 2.74620E-02_JPRB, 2.92203E-02_JPRB, 3.10911E-02_JPRB, 3.30817E-02_JPRB/)
      KBO_MN2O( 2, :,16) = (/ &
     & 1.08257E-02_JPRB, 1.15188E-02_JPRB, 1.22563E-02_JPRB, 1.30410E-02_JPRB, 1.38759E-02_JPRB, &
     & 1.47643E-02_JPRB, 1.57096E-02_JPRB, 1.67154E-02_JPRB, 1.77857E-02_JPRB, 1.89244E-02_JPRB, &
     & 2.01360E-02_JPRB, 2.14252E-02_JPRB, 2.27970E-02_JPRB, 2.42565E-02_JPRB, 2.58096E-02_JPRB, &
     & 2.74620E-02_JPRB, 2.92203E-02_JPRB, 3.10911E-02_JPRB, 3.30817E-02_JPRB/)
      KBO_MN2O( 3, :,16) = (/ &
     & 1.08257E-02_JPRB, 1.15188E-02_JPRB, 1.22563E-02_JPRB, 1.30410E-02_JPRB, 1.38759E-02_JPRB, &
     & 1.47643E-02_JPRB, 1.57096E-02_JPRB, 1.67154E-02_JPRB, 1.77857E-02_JPRB, 1.89244E-02_JPRB, &
     & 2.01360E-02_JPRB, 2.14252E-02_JPRB, 2.27970E-02_JPRB, 2.42565E-02_JPRB, 2.58096E-02_JPRB, &
     & 2.74620E-02_JPRB, 2.92203E-02_JPRB, 3.10911E-02_JPRB, 3.30817E-02_JPRB/)
      KBO_MN2O( 4, :,16) = (/ &
     & 1.08263E-02_JPRB, 1.15191E-02_JPRB, 1.22562E-02_JPRB, 1.30404E-02_JPRB, 1.38749E-02_JPRB, &
     & 1.47627E-02_JPRB, 1.57073E-02_JPRB, 1.67124E-02_JPRB, 1.77818E-02_JPRB, 1.89196E-02_JPRB, &
     & 2.01302E-02_JPRB, 2.14183E-02_JPRB, 2.27888E-02_JPRB, 2.42470E-02_JPRB, 2.57986E-02_JPRB, &
     & 2.74494E-02_JPRB, 2.92058E-02_JPRB, 3.10746E-02_JPRB, 3.30630E-02_JPRB/)
      KBO_MN2O( 5, :,16) = (/ &
     & 4.53450E-08_JPRB, 5.75193E-08_JPRB, 7.29620E-08_JPRB, 9.25509E-08_JPRB, 1.17399E-07_JPRB, &
     & 1.48918E-07_JPRB, 1.88900E-07_JPRB, 2.39616E-07_JPRB, 3.03948E-07_JPRB, 3.85551E-07_JPRB, &
     & 4.89064E-07_JPRB, 6.20369E-07_JPRB, 7.86925E-07_JPRB, 9.98199E-07_JPRB, 1.26619E-06_JPRB, &
     & 1.60614E-06_JPRB, 2.03736E-06_JPRB, 2.58435E-06_JPRB, 3.27819E-06_JPRB/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      FORREFO(1,:) = (/ &
     &9.0039E-04_JPRB,1.1081E-03_JPRB,1.0732E-03_JPRB,1.1881E-03_JPRB,1.2488E-03_JPRB,1.3170E-03_JPRB, &
     &1.3317E-03_JPRB,1.3168E-03_JPRB,1.3369E-03_JPRB,1.4228E-03_JPRB,1.5385E-03_JPRB,1.7376E-03_JPRB, &
     &1.7122E-03_JPRB,1.9002E-03_JPRB,1.8881E-03_JPRB,2.1595E-03_JPRB/)
      FORREFO(2,:) = (/ &
     &1.2726E-03_JPRB,1.3680E-03_JPRB,1.2494E-03_JPRB,1.2049E-03_JPRB,1.2048E-03_JPRB,1.1256E-03_JPRB, &
     &1.1170E-03_JPRB,1.0697E-03_JPRB,1.1177E-03_JPRB,1.1883E-03_JPRB,1.2219E-03_JPRB,1.2179E-03_JPRB, &
     &1.5692E-03_JPRB,1.9103E-03_JPRB,2.0219E-03_JPRB,1.6937E-03_JPRB/)
      FORREFO(3,:) = (/ &
     &1.5527E-03_JPRB,1.6477E-03_JPRB,1.4973E-03_JPRB,1.3400E-03_JPRB,1.0820E-03_JPRB,9.3315E-04_JPRB, &
     &8.8132E-04_JPRB,8.1508E-04_JPRB,8.3559E-04_JPRB,7.6492E-04_JPRB,8.2343E-04_JPRB,7.1274E-04_JPRB, &
     &6.6011E-04_JPRB,6.7179E-04_JPRB,6.7039E-04_JPRB,6.7021E-04_JPRB/)
      FORREFO(4,:) = (/ &
     &1.6763E-03_JPRB,1.6066E-03_JPRB,1.3927E-03_JPRB,1.2087E-03_JPRB,9.8463E-04_JPRB,8.8414E-04_JPRB, &
     &8.0976E-04_JPRB,7.8758E-04_JPRB,7.7376E-04_JPRB,7.5785E-04_JPRB,7.4152E-04_JPRB,7.3814E-04_JPRB, &
     &7.4278E-04_JPRB,7.1745E-04_JPRB,6.7216E-04_JPRB,6.4097E-04_JPRB/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      SELFREFO(:, 1) = (/ &
     & 5.11926E-01_JPRB, 4.32863E-01_JPRB, 3.66010E-01_JPRB, 3.09482E-01_JPRB, 2.61685E-01_JPRB, &
     & 2.21269E-01_JPRB, 1.87096E-01_JPRB, 1.58200E-01_JPRB, 1.33767E-01_JPRB, 1.13108E-01_JPRB/)
      SELFREFO(:, 2) = (/ &
     & 5.02863E-01_JPRB, 4.35008E-01_JPRB, 3.76310E-01_JPRB, 3.25532E-01_JPRB, 2.81606E-01_JPRB, &
     & 2.43607E-01_JPRB, 2.10736E-01_JPRB, 1.82300E-01_JPRB, 1.57701E-01_JPRB, 1.36422E-01_JPRB/)
      SELFREFO(:, 3) = (/ &
     & 4.57628E-01_JPRB, 3.99663E-01_JPRB, 3.49040E-01_JPRB, 3.04829E-01_JPRB, 2.66218E-01_JPRB, &
     & 2.32498E-01_JPRB, 2.03049E-01_JPRB, 1.77330E-01_JPRB, 1.54869E-01_JPRB, 1.35252E-01_JPRB/)
      SELFREFO(:, 4) = (/ &
     & 4.28634E-01_JPRB, 3.81736E-01_JPRB, 3.39970E-01_JPRB, 3.02773E-01_JPRB, 2.69647E-01_JPRB, &
     & 2.40144E-01_JPRB, 2.13870E-01_JPRB, 1.90470E-01_JPRB, 1.69630E-01_JPRB, 1.51071E-01_JPRB/)
      SELFREFO(:, 5) = (/ &
     & 4.21002E-01_JPRB, 3.77493E-01_JPRB, 3.38480E-01_JPRB, 3.03499E-01_JPRB, 2.72133E-01_JPRB, &
     & 2.44009E-01_JPRB, 2.18792E-01_JPRB, 1.96180E-01_JPRB, 1.75905E-01_JPRB, 1.57726E-01_JPRB/)
      SELFREFO(:, 6) = (/ &
     & 3.97517E-01_JPRB, 3.61167E-01_JPRB, 3.28140E-01_JPRB, 2.98133E-01_JPRB, 2.70871E-01_JPRB, &
     & 2.46101E-01_JPRB, 2.23597E-01_JPRB, 2.03150E-01_JPRB, 1.84573E-01_JPRB, 1.67695E-01_JPRB/)
      SELFREFO(:, 7) = (/ &
     & 3.92114E-01_JPRB, 3.57554E-01_JPRB, 3.26040E-01_JPRB, 2.97304E-01_JPRB, 2.71100E-01_JPRB, &
     & 2.47206E-01_JPRB, 2.25418E-01_JPRB, 2.05550E-01_JPRB, 1.87433E-01_JPRB, 1.70913E-01_JPRB/)
      SELFREFO(:, 8) = (/ &
     & 3.79555E-01_JPRB, 3.47264E-01_JPRB, 3.17720E-01_JPRB, 2.90690E-01_JPRB, 2.65959E-01_JPRB, &
     & 2.43332E-01_JPRB, 2.22631E-01_JPRB, 2.03690E-01_JPRB, 1.86361E-01_JPRB, 1.70506E-01_JPRB/)
      SELFREFO(:, 9) = (/ &
     & 3.92644E-01_JPRB, 3.58048E-01_JPRB, 3.26500E-01_JPRB, 2.97732E-01_JPRB, 2.71498E-01_JPRB, &
     & 2.47576E-01_JPRB, 2.25762E-01_JPRB, 2.05870E-01_JPRB, 1.87731E-01_JPRB, 1.71190E-01_JPRB/)
      SELFREFO(:,10) = (/ &
     & 4.06542E-01_JPRB, 3.71200E-01_JPRB, 3.38930E-01_JPRB, 3.09465E-01_JPRB, 2.82562E-01_JPRB, &
     & 2.57998E-01_JPRB, 2.35569E-01_JPRB, 2.15090E-01_JPRB, 1.96391E-01_JPRB, 1.79318E-01_JPRB/)
      SELFREFO(:,11) = (/ &
     & 4.09672E-01_JPRB, 3.76237E-01_JPRB, 3.45530E-01_JPRB, 3.17329E-01_JPRB, 2.91430E-01_JPRB, &
     & 2.67645E-01_JPRB, 2.45801E-01_JPRB, 2.25740E-01_JPRB, 2.07316E-01_JPRB, 1.90396E-01_JPRB/)
      SELFREFO(:,12) = (/ &
     & 3.85140E-01_JPRB, 3.61989E-01_JPRB, 3.40230E-01_JPRB, 3.19779E-01_JPRB, 3.00557E-01_JPRB, &
     & 2.82490E-01_JPRB, 2.65510E-01_JPRB, 2.49550E-01_JPRB, 2.34549E-01_JPRB, 2.20451E-01_JPRB/)
      SELFREFO(:,13) = (/ &
     & 4.87349E-01_JPRB, 4.42192E-01_JPRB, 4.01220E-01_JPRB, 3.64044E-01_JPRB, 3.30313E-01_JPRB, &
     & 2.99707E-01_JPRB, 2.71937E-01_JPRB, 2.46740E-01_JPRB, 2.23878E-01_JPRB, 2.03134E-01_JPRB/)
      SELFREFO(:,14) = (/ &
     & 5.64339E-01_JPRB, 5.06194E-01_JPRB, 4.54040E-01_JPRB, 4.07259E-01_JPRB, 3.65298E-01_JPRB, &
     & 3.27661E-01_JPRB, 2.93901E-01_JPRB, 2.63620E-01_JPRB, 2.36459E-01_JPRB, 2.12096E-01_JPRB/)
      SELFREFO(:,15) = (/ &
     & 5.91123E-01_JPRB, 5.26420E-01_JPRB, 4.68800E-01_JPRB, 4.17486E-01_JPRB, 3.71790E-01_JPRB, &
     & 3.31095E-01_JPRB, 2.94854E-01_JPRB, 2.62580E-01_JPRB, 2.33839E-01_JPRB, 2.08243E-01_JPRB/)
      SELFREFO(:,16) = (/ &
     & 5.04590E-01_JPRB, 4.65235E-01_JPRB, 4.28950E-01_JPRB, 3.95495E-01_JPRB, 3.64649E-01_JPRB, &
     & 3.36209E-01_JPRB, 3.09987E-01_JPRB, 2.85810E-01_JPRB, 2.63519E-01_JPRB, 2.42966E-01_JPRB/)

IF (LHOOK) CALL DR_HOOK('RRTM_KGB3',1,ZHOOK_HANDLE)
RETURN

END SUBROUTINE RRTM_KGB3
