#!/bin/bash

sims=( $* )

echo ${sims[*]}

cat <<eod>| tmp.jnl
use "diags/ifa_toga_coare_v21_dime.nc"
let mask= if ( rneb ge 0. ) then 1.
let neb=if (rneb ge 0. ) then neb
let un=temp/temp
let fracconv=plul/precip
eod
cat <<eod>| tmpul.jnl
set v ul
plot/hlim=-5.:5. temp[d=1,l=@ave]-temp[d=1,l=1]
eod
cat <<eod>| tmpur.jnl
set v ur
plot/hlim=0.:100. rh[d=1,l=@ave]
eod
cat <<eod>| tmpll.jnl
set v ll
! plot po[d=1]
eod
cat <<eod>| tmplr.jnl
set v lr
! plot po[d=1]
eod


isim=1

o=
for sim in ${sims[*]}  ; do
(( isim=$isim+1))

cat <<eod>> tmp.jnl
use "$sim/histhf.nc"
eod

cat <<eod>> tmpul.jnl
plot/o/title="$sim" temp[d=$isim,l=@ave]-temp[d=$isim,l=1]
eod

cat <<eod>> tmpur.jnl
plot/o/title="$sim" 100*rhum[d=$isim,l=@ave]
eod

cat <<eod>> tmpll.jnl
plot$o/title="$sim"/col=$isim fracconv[d=$isim]
eod

cat <<eod>> tmplr.jnl
plot$o/title="$sim"/col=$isim 100*(mask[d=$isim,l=@sum]/un[d=$isim,l=@sum])*rneb[d=$isim,l=@ave]
eod

o='/o'

done

cat <<eod>> tmp.jnl
go  tmpul.jnl
go  tmpur.jnl
go  tmpll.jnl
go  tmplr.jnl
frame/file=tmp.gif
quit
eod


ferret -gif -nojnl <<eod
go tmp.jnl
quit
eod
#display tmp.gif
