madate=$(date +%Y%m%d)
echo 'version du '$madate
ncatted -a comment,global,a,c,'Forcing and initial conditions for RICO case' cas.nc
ncatted -a author,global,a,c,'MP Lefebvre' cas.nc
ncatted -a version,global,a,c,$madate cas.nc
ncatted -a case,global,a,c,'RICO' cas.nc
ncatted -a startDate,global,a,c,'20041216000000' cas.nc
ncatted -a endDate,global,a,c,'20041219000000' cas.nc
ncatted -a surfaceType,global,a,c,'ocean' cas.nc
ncatted -a surfaceForcing,global,a,c,'ts' cas.nc
ncatted -a forcing1,global,a,c,'Large scale subsidence in w' cas.nc
ncatted -a forcing2,global,a,c,'Large scale temperature forcing due to advection and radiation in tadv' cas.nc
ncatted -a forcing3,global,a,c,'Large Scale horizontal moisture advection in qadvh' cas.nc
ncatted -a forcing4,global,a,c,'Geostrophic wind' cas.nc
ncatted -a tadv,global,a,i,1 cas.nc
ncatted -a tadvh,global,a,i,1 cas.nc
ncatted -a tadvv,global,a,i,0 cas.nc
ncatted -a qadv,global,a,i,1 cas.nc
ncatted -a qadvh,global,a,i,1 cas.nc
ncatted -a qadvv,global,a,i,0 cas.nc
ncatted -a thadv,global,a,i,0 cas.nc
ncatted -a thadvh,global,a,i,0 cas.nc
ncatted -a thadvv,global,a,i,0 cas.nc
ncatted -a trad,global,a,i,0 cas.nc
ncatted -a forc_omega,global,a,i,0 cas.nc
ncatted -a forc_u,global,a,i,1 cas.nc
ncatted -a forc_v,global,a,i,1 cas.nc
ncatted -a forc_w,global,a,i,1 cas.nc
ncatted -a forc_geo,global,a,i,1 cas.nc
ncatted -a forc_ustar,global,a,i,0 cas.nc
ncatted -a nudging_u,global,a,i,0 cas.nc
ncatted -a nudging_v,global,a,i,0 cas.nc
ncatted -a nudging_t,global,a,i,0 cas.nc
ncatted -a nudging_q,global,a,i,0 cas.nc
ncatted -a readme,global,a,c,'http://projects.knmi.nl/rico/setup1d_composite.html' cas.nc
# Delete not usefull variables
ncks -x -v theta cas.nc cas1.nc
ncks -x -v rh cas1.nc cas3.nc
ncks -x -v uadv cas3.nc cas4.nc
ncks -x -v uadvv cas4.nc cas5.nc
ncks -x -v uadvh cas5.nc cas6.nc
ncks -x -v vadv cas6.nc cas7.nc
ncks -x -v vadvv cas7.nc cas8.nc
ncks -x -v vadvh cas8.nc cas9.nc
ncks -x -v thadv cas9.nc cas10.nc
ncks -x -v thadvv cas10.nc cas11.nc
ncks -x -v thadvh cas11.nc cas12.nc
ncks -x -v radv cas12.nc cas13.nc
ncks -x -v radvv cas13.nc cas14.nc
ncks -x -v radvh cas14.nc cas15.nc
ncks -x -v radcool cas15.nc cas16.nc
ncks -x -v sfc_sens_flx cas16.nc cas17.nc
ncks -x -v sfc_lat_flx cas17.nc cas18.nc
ncks -x -v ustar cas18.nc cas19.nc
ncks -x -v q1 cas19.nc cas20.nc
ncks -x -v q2 cas20.nc cas21.nc
ncks -x -v ustress cas21.nc cas22.nc
ncks -x -v vstress cas22.nc cas23.nc
mv cas23.nc rico_driver.nc
ncatted -O -a history,global,d,, rico_driver.nc
rm -f cas*.nc
cp rico_driver.nc cas.nc
